/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.tx;

import java.rmi.RemoteException;
import java.util.Random;
import javax.ejb.EJBException;
import javax.ejb.EJBTransactionRolledbackException;
import javax.ejb.NoSuchEJBException;
import javax.ejb.NoSuchEntityException;
import javax.ejb.TransactionAttributeType;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.tx.ApplicationExceptionDetails;
import org.jboss.as.ejb3.tx.util.StatusHelper;
import org.jboss.invocation.ImmediateInterceptorFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.tm.TransactionTimeoutConfiguration;

public class CMTTxInterceptor
implements Interceptor {
    private static final int MAX_RETRIES = 5;
    private static final Random RANDOM = new Random();
    public static final InterceptorFactory FACTORY = new ImmediateInterceptorFactory((Interceptor)new CMTTxInterceptor());

    protected void endTransaction(TransactionManager tm, Transaction tx) {
        block10: {
            try {
                if (tx != tm.getTransaction()) {
                    throw EjbLogger.ROOT_LOGGER.wrongTxOnThread(tx, tm.getTransaction());
                }
                int txStatus = tx.getStatus();
                if (txStatus == 0) {
                    tm.commit();
                    break block10;
                }
                if (txStatus == 1) {
                    tm.rollback();
                    break block10;
                }
                if (txStatus == 4) {
                    tm.rollback();
                    throw EjbLogger.ROOT_LOGGER.transactionAlreadyRolledBack(tx);
                }
                if (txStatus == 5) {
                    tm.rollback();
                    throw EjbLogger.ROOT_LOGGER.transactionInUnexpectedState(tx, StatusHelper.statusAsString(txStatus));
                }
                tm.suspend();
                throw EjbLogger.ROOT_LOGGER.transactionInUnexpectedState(tx, StatusHelper.statusAsString(txStatus));
            }
            catch (RollbackException e) {
                this.handleEndTransactionException((Exception)((Object)e));
            }
            catch (HeuristicMixedException e) {
                this.handleEndTransactionException((Exception)((Object)e));
            }
            catch (HeuristicRollbackException e) {
                this.handleEndTransactionException((Exception)((Object)e));
            }
            catch (SystemException e) {
                this.handleEndTransactionException((Exception)((Object)e));
            }
        }
    }

    protected int getCurrentTransactionTimeout(EJBComponent component) throws SystemException {
        TransactionManager tm = component.getTransactionManager();
        if (tm instanceof TransactionTimeoutConfiguration) {
            return ((TransactionTimeoutConfiguration)tm).getTransactionTimeout();
        }
        return 0;
    }

    protected void handleEndTransactionException(Exception e) {
        if (e instanceof RollbackException) {
            throw new EJBTransactionRolledbackException("Transaction rolled back", e);
        }
        throw new EJBException(e);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void handleInCallerTx(InterceptorContext invocation, Throwable t, Transaction tx, EJBComponent component) throws Exception {
        Throwable toThrow;
        ApplicationExceptionDetails ae = component.getApplicationException(t.getClass(), invocation.getMethod());
        if (ae != null) {
            if (!ae.isRollback()) throw (Exception)t;
            this.setRollbackOnly(tx);
            throw (Exception)t;
        }
        if (!(t instanceof EJBTransactionRolledbackException)) {
            if (t instanceof Error) {
                toThrow = new EJBTransactionRolledbackException(EjbLogger.ROOT_LOGGER.convertUnexpectedError());
                toThrow.initCause(t);
            } else if (t instanceof NoSuchEJBException || t instanceof NoSuchEntityException) {
                toThrow = (Exception)t;
            } else {
                if (!(t instanceof RuntimeException)) throw (Exception)t;
                toThrow = new EJBTransactionRolledbackException(t.getMessage(), (Exception)t);
            }
        } else {
            toThrow = (Exception)t;
        }
        this.setRollbackOnly(tx);
        throw toThrow;
    }

    public void handleExceptionInOurTx(InterceptorContext invocation, Throwable t, Transaction tx, EJBComponent component) throws Exception {
        ApplicationExceptionDetails ae = component.getApplicationException(t.getClass(), invocation.getMethod());
        if (ae != null) {
            if (ae.isRollback()) {
                this.setRollbackOnly(tx);
            }
            throw (Exception)t;
        }
        if (!(t instanceof EJBException) && !(t instanceof RemoteException)) {
            if (t instanceof Error) {
                Throwable cause = t;
                t = EjbLogger.ROOT_LOGGER.unexpectedError();
                t.initCause(cause);
            } else if (t instanceof RuntimeException) {
                t = new EJBException((Exception)t);
            } else {
                throw (Exception)t;
            }
        }
        this.setRollbackOnly(tx);
        throw (Exception)t;
    }

    public void handleExceptionInNoTx(InterceptorContext invocation, Throwable t, EJBComponent component) throws Exception {
        ApplicationExceptionDetails ae = component.getApplicationException(t.getClass(), invocation.getMethod());
        if (ae != null) {
            throw (Exception)t;
        }
        if (!(t instanceof EJBException) && !(t instanceof RemoteException)) {
            if (t instanceof Error) {
                Throwable cause = t;
                t = EjbLogger.ROOT_LOGGER.unexpectedError();
                t.initCause(cause);
            } else if (t instanceof RuntimeException) {
                t = new EJBException((Exception)t);
            } else {
                throw (Exception)t;
            }
        }
        throw (Exception)t;
    }

    /*
     * Exception decompiling
     */
    public Object processInvocation(InterceptorContext invocation) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected Object invokeInCallerTx(InterceptorContext invocation, Transaction tx, EJBComponent component) throws Exception {
        try {
            return invocation.proceed();
        }
        catch (Throwable t) {
            this.handleInCallerTx(invocation, t, tx, component);
            throw new RuntimeException("UNREACHABLE");
        }
    }

    protected Object invokeInNoTx(InterceptorContext invocation, EJBComponent component) throws Exception {
        try {
            return invocation.proceed();
        }
        catch (Throwable t) {
            this.handleExceptionInNoTx(invocation, t, component);
            throw new RuntimeException("UNREACHABLE");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object invokeInOurTx(InterceptorContext invocation, TransactionManager tm, EJBComponent component) throws Exception {
        for (int i = 0; i < 5; ++i) {
            tm.begin();
            Transaction tx = tm.getTransaction();
            try {
                Object object = invocation.proceed();
                return object;
            }
            catch (Throwable t) {
                this.handleExceptionInOurTx(invocation, t, tx, component);
                continue;
            }
            finally {
                this.endTransaction(tm, tx);
            }
        }
        throw new RuntimeException("UNREACHABLE");
    }

    protected Object mandatory(InterceptorContext invocation, EJBComponent component) throws Exception {
        TransactionManager tm = component.getTransactionManager();
        Transaction tx = tm.getTransaction();
        if (tx == null) {
            throw EjbLogger.ROOT_LOGGER.txRequiredForInvocation(invocation);
        }
        return this.invokeInCallerTx(invocation, tx, component);
    }

    protected Object never(InterceptorContext invocation, EJBComponent component) throws Exception {
        TransactionManager tm = component.getTransactionManager();
        if (tm.getTransaction() != null) {
            throw EjbLogger.ROOT_LOGGER.txPresentForNeverTxAttribute();
        }
        return this.invokeInNoTx(invocation, component);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object notSupported(InterceptorContext invocation, EJBComponent component) throws Exception {
        TransactionManager tm = component.getTransactionManager();
        Transaction tx = tm.getTransaction();
        if (tx != null) {
            tm.suspend();
            try {
                Object object = this.invokeInNoTx(invocation, component);
                return object;
            }
            finally {
                tm.resume(tx);
            }
        }
        return this.invokeInNoTx(invocation, component);
    }

    protected Object required(InterceptorContext invocation, EJBComponent component, int timeout) throws Exception {
        Transaction tx;
        TransactionManager tm = component.getTransactionManager();
        if (timeout != -1) {
            tm.setTransactionTimeout(timeout);
        }
        if ((tx = tm.getTransaction()) == null) {
            return this.invokeInOurTx(invocation, tm, component);
        }
        return this.invokeInCallerTx(invocation, tx, component);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object requiresNew(InterceptorContext invocation, EJBComponent component, int timeout) throws Exception {
        Transaction tx;
        TransactionManager tm = component.getTransactionManager();
        if (timeout != -1) {
            tm.setTransactionTimeout(timeout);
        }
        if ((tx = tm.getTransaction()) != null) {
            tm.suspend();
            try {
                Object object = this.invokeInOurTx(invocation, tm, component);
                return object;
            }
            finally {
                tm.resume(tx);
            }
        }
        return this.invokeInOurTx(invocation, tm, component);
    }

    protected void setRollbackOnly(Transaction tx) {
        try {
            tx.setRollbackOnly();
        }
        catch (SystemException ex) {
            EjbLogger.ROOT_LOGGER.failedToSetRollbackOnly((Exception)((Object)ex));
        }
        catch (IllegalStateException ex) {
            EjbLogger.ROOT_LOGGER.failedToSetRollbackOnly(ex);
        }
    }

    protected Object supports(InterceptorContext invocation, EJBComponent component) throws Exception {
        TransactionManager tm = component.getTransactionManager();
        Transaction tx = tm.getTransaction();
        if (tx == null) {
            return this.invokeInNoTx(invocation, component);
        }
        return this.invokeInCallerTx(invocation, tx, component);
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$javax$ejb$TransactionAttributeType;

        static {
            $SwitchMap$javax$ejb$TransactionAttributeType = new int[TransactionAttributeType.values().length];
            try {
                1.$SwitchMap$javax$ejb$TransactionAttributeType[TransactionAttributeType.MANDATORY.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$javax$ejb$TransactionAttributeType[TransactionAttributeType.NEVER.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$javax$ejb$TransactionAttributeType[TransactionAttributeType.NOT_SUPPORTED.ordinal()] = 3;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$javax$ejb$TransactionAttributeType[TransactionAttributeType.REQUIRED.ordinal()] = 4;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$javax$ejb$TransactionAttributeType[TransactionAttributeType.REQUIRES_NEW.ordinal()] = 5;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$javax$ejb$TransactionAttributeType[TransactionAttributeType.SUPPORTS.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

