/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors.entity;

import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.DeploymentDescriptorEnvironment;
import org.jboss.as.ejb3.component.entity.EntityBeanComponentDescription;
import org.jboss.as.ejb3.deployment.EjbJarDescription;
import org.jboss.as.ejb3.deployment.processors.AbstractDeploymentUnitProcessor;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.metadata.ejb.spec.EnterpriseBeanMetaData;
import org.jboss.metadata.ejb.spec.EntityBeanMetaData;
import org.jboss.metadata.javaee.spec.RemoteEnvironment;
import org.jboss.msc.service.ServiceName;

public class EntityBeanComponentDescriptionFactory
extends AbstractDeploymentUnitProcessor {
    public EntityBeanComponentDescriptionFactory(boolean appclient) {
        super(appclient);
    }

    protected void mark(DeploymentUnit deploymentUnit) {
    }

    @Override
    protected void processBeanMetaData(DeploymentUnit deploymentUnit, EnterpriseBeanMetaData enterpriseBeanMetaData) throws DeploymentUnitProcessingException {
        if (enterpriseBeanMetaData.isEntity()) {
            assert (enterpriseBeanMetaData instanceof EntityBeanMetaData) : enterpriseBeanMetaData + " is not an EntityBeanMetaData";
            this.processEntityBeanMetaData(deploymentUnit, (EntityBeanMetaData)enterpriseBeanMetaData);
        }
    }

    private void processEntityBeanMetaData(DeploymentUnit deploymentUnit, EntityBeanMetaData entity) throws DeploymentUnitProcessingException {
        String remote;
        String home;
        String local;
        if (entity.isCMP()) {
            throw EjbLogger.ROOT_LOGGER.cmpEntityBeansAreNotSupported();
        }
        EjbJarDescription ejbJarDescription = EntityBeanComponentDescriptionFactory.getEjbJarDescription(deploymentUnit);
        String beanName = entity.getName();
        String beanClassName = entity.getEjbClass();
        if (!this.shouldProcess(entity)) {
            return;
        }
        this.mark(deploymentUnit);
        EntityBeanComponentDescription description = this.createDescription(beanName, beanClassName, ejbJarDescription, deploymentUnit.getServiceName(), entity);
        description.setDeploymentDescriptorEnvironment(new DeploymentDescriptorEnvironment("java:comp/env/", (RemoteEnvironment)entity));
        if (this.appclient) {
            deploymentUnit.addToAttachmentList(Attachments.ADDITIONAL_RESOLVABLE_COMPONENTS, (Object)description);
        } else {
            ejbJarDescription.getEEModuleDescription().addComponent((ComponentDescription)description);
        }
        description.setPersistenceType(entity.getPersistenceType());
        description.setReentrant(entity.isReentrant());
        description.setPrimaryKeyType(entity.getPrimKeyClass());
        String localHome = entity.getLocalHome();
        if (localHome != null) {
            description.addLocalHome(localHome);
        }
        if ((local = entity.getLocal()) != null) {
            description.addEjbLocalObjectView(local);
        }
        if ((home = entity.getHome()) != null) {
            description.addRemoteHome(home);
        }
        if ((remote = entity.getRemote()) != null) {
            description.addEjbObjectView(remote);
        }
    }

    protected boolean shouldProcess(EntityBeanMetaData entity) {
        return entity.isBMP();
    }

    protected EntityBeanComponentDescription createDescription(String beanName, String beanClassName, EjbJarDescription ejbJarDescription, ServiceName serviceName, EntityBeanMetaData beanMetaData) {
        return new EntityBeanComponentDescription(beanName, beanClassName, ejbJarDescription, serviceName, beanMetaData);
    }
}

