/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.pool;

import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.as.ejb3.pool.Pool;
import org.jboss.as.ejb3.pool.StatelessObjectFactory;
import org.jboss.logging.Logger;

public abstract class AbstractPool<T>
implements Pool<T> {
    private static final Logger log = Logger.getLogger(AbstractPool.class);
    private final StatelessObjectFactory<T> factory;
    private final AtomicInteger createCount = new AtomicInteger(0);
    private final AtomicInteger removeCount = new AtomicInteger(0);

    protected AbstractPool(StatelessObjectFactory<T> factory) {
        assert (factory != null) : "factory is null";
        this.factory = factory;
    }

    @Override
    public int getCreateCount() {
        return this.createCount.get();
    }

    @Override
    public int getRemoveCount() {
        return this.removeCount.get();
    }

    @Override
    public abstract void setMaxSize(int var1);

    protected T create() {
        T bean = this.factory.create();
        this.createCount.incrementAndGet();
        return bean;
    }

    @Deprecated
    protected void remove(T bean) {
        this.doRemove(bean);
    }

    protected void destroy(T bean) {
        this.doRemove(bean);
    }

    protected void doRemove(T bean) {
        try {
            this.factory.destroy(bean);
        }
        finally {
            this.removeCount.incrementAndGet();
        }
    }
}

