/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.resources;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelOnlyWriteAttributeHandler;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.access.constraint.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.constraint.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.parsing.Attribute;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.domain.controller.operations.DomainServerLifecycleHandlers;
import org.jboss.as.domain.controller.operations.ServerGroupAddHandler;
import org.jboss.as.domain.controller.operations.ServerGroupProfileWriteAttributeHandler;
import org.jboss.as.domain.controller.operations.ServerGroupRemoveHandler;
import org.jboss.as.domain.controller.operations.ServerGroupSocketBindingGroupWriteAttributeHandler;
import org.jboss.as.domain.controller.operations.deployment.ServerGroupDeploymentReplaceHandler;
import org.jboss.as.domain.controller.resources.DomainDeploymentResourceDefinition;
import org.jboss.as.domain.controller.resources.DomainResolver;
import org.jboss.as.host.controller.mgmt.DomainControllerRuntimeIgnoreTransformationRegistry;
import org.jboss.as.host.controller.model.jvm.JvmResourceDefinition;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.repository.HostFileRepository;
import org.jboss.as.server.controller.resources.DeploymentAttributes;
import org.jboss.as.server.controller.resources.SystemPropertyResourceDefinition;
import org.jboss.as.server.deploymentoverlay.DeploymentOverlayDefinition;
import org.jboss.as.server.deploymentoverlay.service.DeploymentOverlayPriority;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ServerGroupResourceDefinition
extends SimpleResourceDefinition {
    public static final PathElement PATH = PathElement.pathElement((String)"server-group");
    public static final SimpleAttributeDefinition PROFILE = SimpleAttributeDefinitionBuilder.create((String)"profile", (ModelType)ModelType.STRING).setValidator((ParameterValidator)new StringLengthValidator(1)).build();
    public static final SimpleAttributeDefinition SOCKET_BINDING_GROUP = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"socket-binding-group", (ModelType)ModelType.STRING, (boolean)false).setXmlName(Attribute.REF.getLocalName()).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.SOCKET_BINDING_REF)).build();
    public static final SimpleAttributeDefinition SOCKET_BINDING_PORT_OFFSET = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"socket-binding-port-offset", (ModelType)ModelType.INT, (boolean)true).setDefaultValue(new ModelNode(0)).setXmlName(Attribute.PORT_OFFSET.getLocalName()).setAllowExpression(true).setValidator((ParameterValidator)new IntRangeValidator(-65535, 65535, true, true)).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.SOCKET_CONFIG)).build();
    public static final SimpleAttributeDefinition MANAGEMENT_SUBSYSTEM_ENDPOINT = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"management-subsystem-endpoint", (ModelType)ModelType.BOOLEAN, (boolean)true).setAllowExpression(true).setDefaultValue(new ModelNode(false)).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.MANAGEMENT_INTERFACES)).build();
    public static final AttributeDefinition[] ADD_ATTRIBUTES = new AttributeDefinition[]{PROFILE, SOCKET_BINDING_GROUP, SOCKET_BINDING_PORT_OFFSET, MANAGEMENT_SUBSYSTEM_ENDPOINT};
    private final boolean master;
    private final ContentRepository contentRepo;
    private final HostFileRepository fileRepository;
    private final DomainControllerRuntimeIgnoreTransformationRegistry runtimeIgnoreTransformationRegistry;

    public ServerGroupResourceDefinition(boolean master, ContentRepository contentRepo, HostFileRepository fileRepository, DomainControllerRuntimeIgnoreTransformationRegistry registry) {
        super(PATH, DomainResolver.getResolver("server-group", false), (OperationStepHandler)new ServerGroupAddHandler(master), (OperationStepHandler)ServerGroupRemoveHandler.INSTANCE);
        this.master = master;
        this.contentRepo = contentRepo;
        this.fileRepository = fileRepository;
        this.runtimeIgnoreTransformationRegistry = registry;
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        for (AttributeDefinition attr : ADD_ATTRIBUTES) {
            if (attr.getName().equals(MANAGEMENT_SUBSYSTEM_ENDPOINT.getName())) {
                resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)MANAGEMENT_SUBSYSTEM_ENDPOINT, null);
                continue;
            }
            if (attr.getName().equals(PROFILE.getName())) {
                resourceRegistration.registerReadWriteAttribute((AttributeDefinition)PROFILE, null, (OperationStepHandler)new ServerGroupProfileWriteAttributeHandler(this.master, this.runtimeIgnoreTransformationRegistry));
                continue;
            }
            if (attr.getName().equals(SOCKET_BINDING_GROUP.getName())) {
                resourceRegistration.registerReadWriteAttribute((AttributeDefinition)SOCKET_BINDING_GROUP, null, (OperationStepHandler)new ServerGroupSocketBindingGroupWriteAttributeHandler(this.master, this.runtimeIgnoreTransformationRegistry));
                continue;
            }
            resourceRegistration.registerReadWriteAttribute(attr, null, (OperationStepHandler)new ModelOnlyWriteAttributeHandler(new AttributeDefinition[]{attr}));
        }
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        resourceRegistration.registerOperationHandler(DeploymentAttributes.SERVER_GROUP_REPLACE_DEPLOYMENT_DEFINITION, (OperationStepHandler)new ServerGroupDeploymentReplaceHandler(this.fileRepository));
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        DomainServerLifecycleHandlers.registerServerGroupHandlers(resourceRegistration);
        resourceRegistration.registerSubModel((ResourceDefinition)JvmResourceDefinition.GLOBAL);
        resourceRegistration.registerSubModel((ResourceDefinition)DomainDeploymentResourceDefinition.createForServerGroup(this.contentRepo, this.fileRepository));
        resourceRegistration.registerSubModel((ResourceDefinition)SystemPropertyResourceDefinition.createForDomainOrHost((SystemPropertyResourceDefinition.Location)SystemPropertyResourceDefinition.Location.SERVER_GROUP));
        resourceRegistration.registerSubModel((ResourceDefinition)new DeploymentOverlayDefinition(DeploymentOverlayPriority.SERVER_GROUP, null, null));
    }
}

