/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller;

import java.util.List;
import java.util.concurrent.ExecutorService;
import org.jboss.as.host.controller.HostControllerService;
import org.jboss.as.host.controller.discovery.DiscoveryOption;
import org.jboss.as.network.NetworkInterfaceBinding;
import org.jboss.as.server.services.net.NetworkInterfaceService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

class DiscoveryService
implements Service<Void> {
    static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"host", "controller", "discovery"});
    private final InjectedValue<NetworkInterfaceBinding> interfaceBinding = new InjectedValue();
    private final InjectedValue<ExecutorService> executorService = new InjectedValue();
    private final List<DiscoveryOption> discoveryOptions;
    private final int port;
    private final boolean isMasterDomainController;

    private DiscoveryService(List<DiscoveryOption> discoveryOptions, int port, boolean isMasterDomainController) {
        this.discoveryOptions = discoveryOptions;
        this.port = port;
        this.isMasterDomainController = isMasterDomainController;
    }

    static void install(ServiceTarget serviceTarget, List<DiscoveryOption> discoveryOptions, String interfaceBinding, int port, boolean isMasterDomainController) {
        DiscoveryService discovery = new DiscoveryService(discoveryOptions, port, isMasterDomainController);
        serviceTarget.addService(SERVICE_NAME, (Service)discovery).addDependency(HostControllerService.HC_EXECUTOR_SERVICE_NAME, ExecutorService.class, discovery.executorService).addDependency(NetworkInterfaceService.JBOSS_NETWORK_INTERFACE.append(new String[]{interfaceBinding}), NetworkInterfaceBinding.class, discovery.interfaceBinding).install();
    }

    public synchronized void start(final StartContext context) throws StartException {
        context.asynchronous();
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    if (DiscoveryService.this.isMasterDomainController && DiscoveryService.this.discoveryOptions != null) {
                        String host = ((NetworkInterfaceBinding)DiscoveryService.this.interfaceBinding.getValue()).getAddress().getHostAddress();
                        for (DiscoveryOption discoveryOption : DiscoveryService.this.discoveryOptions) {
                            discoveryOption.allowDiscovery(host, DiscoveryService.this.port);
                        }
                    }
                    context.complete();
                }
                catch (Exception e) {
                    context.failed(new StartException((Throwable)e));
                }
            }
        };
        ((ExecutorService)this.executorService.getValue()).execute(r);
    }

    public synchronized void stop(final StopContext context) {
        context.asynchronous();
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    if (DiscoveryService.this.isMasterDomainController && DiscoveryService.this.discoveryOptions != null) {
                        for (DiscoveryOption discoveryOption : DiscoveryService.this.discoveryOptions) {
                            discoveryOption.cleanUp();
                        }
                    }
                }
                finally {
                    context.complete();
                }
            }
        };
        ((ExecutorService)this.executorService.getValue()).execute(r);
    }

    public synchronized Void getValue() throws IllegalStateException, IllegalArgumentException {
        return null;
    }
}

