/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.mgmt;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.as.controller.CurrentOperationIdHolder;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.controller.client.OperationAttachments;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.controller.remote.AbstractModelControllerOperationHandlerFactoryService;
import org.jboss.as.controller.remote.ModelControllerClientOperationHandler;
import org.jboss.as.controller.remote.ModelControllerClientOperationHandlerFactoryService;
import org.jboss.as.controller.remote.TransactionalProtocolOperationHandler;
import org.jboss.as.domain.controller.DomainController;
import org.jboss.as.domain.controller.operations.PullDownDataForServerConfigOnSlaveHandler;
import org.jboss.as.host.controller.HostControllerMessages;
import org.jboss.as.host.controller.mgmt.DomainControllerRuntimeIgnoreTransformationRegistry;
import org.jboss.as.host.controller.mgmt.HostControllerRegistrationHandler;
import org.jboss.as.host.controller.mgmt.MasterDomainControllerOperationHandlerImpl;
import org.jboss.as.host.controller.mgmt.SlaveChannelAttachments;
import org.jboss.as.protocol.mgmt.ManagementChannelAssociation;
import org.jboss.as.protocol.mgmt.ManagementChannelHandler;
import org.jboss.as.protocol.mgmt.ManagementClientChannelStrategy;
import org.jboss.as.protocol.mgmt.ManagementPongRequestHandler;
import org.jboss.as.protocol.mgmt.ManagementRequestContext;
import org.jboss.as.protocol.mgmt.ManagementRequestHandlerFactory;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.remoting3.Channel;
import org.jboss.threads.JBossThreadFactory;
import org.wildfly.security.manager.action.GetAccessControlContextAction;

public class MasterDomainControllerOperationHandlerService
extends AbstractModelControllerOperationHandlerFactoryService {
    public static final ServiceName SERVICE_NAME = DomainController.SERVICE_NAME.append(ModelControllerClientOperationHandlerFactoryService.OPERATION_HANDLER_NAME_SUFFIX);
    private final DomainController domainController;
    private final HostControllerRegistrationHandler.OperationExecutor operationExecutor;
    private final TransactionalOperationExecutor txOperationExecutor;
    private final ManagementPongRequestHandler pongRequestHandler = new ManagementPongRequestHandler();
    private final ThreadFactory threadFactory = new JBossThreadFactory(new ThreadGroup("slave-request-threads"), Boolean.FALSE, null, "%G - %t", null, null, (AccessControlContext)AccessController.doPrivileged(GetAccessControlContextAction.getInstance()));
    private final DomainControllerRuntimeIgnoreTransformationRegistry runtimeIgnoreTransformationRegistry;

    public MasterDomainControllerOperationHandlerService(DomainController domainController, HostControllerRegistrationHandler.OperationExecutor operationExecutor, TransactionalOperationExecutor txOperationExecutor, DomainControllerRuntimeIgnoreTransformationRegistry runtimeIgnoreTransformationRegistry) {
        this.domainController = domainController;
        this.operationExecutor = operationExecutor;
        this.txOperationExecutor = txOperationExecutor;
        this.runtimeIgnoreTransformationRegistry = runtimeIgnoreTransformationRegistry;
    }

    public synchronized void start(StartContext context) throws StartException {
        this.pongRequestHandler.resetConnectionId();
        super.start(context);
    }

    public ManagementChannelHandler startReceiving(Channel channel) {
        ManagementChannelHandler handler = new ManagementChannelHandler(ManagementClientChannelStrategy.create((Channel)channel), this.getExecutor());
        handler.addHandlerFactory((ManagementRequestHandlerFactory)new HostControllerRegistrationHandler(handler, this.domainController, this.operationExecutor, this.getExecutor(), this.runtimeIgnoreTransformationRegistry));
        handler.addHandlerFactory((ManagementRequestHandlerFactory)new ModelControllerClientOperationHandler(this.getController(), (ManagementChannelAssociation)handler));
        handler.addHandlerFactory((ManagementRequestHandlerFactory)new MasterDomainControllerOperationHandlerImpl(this.domainController, this.getExecutor()));
        handler.addHandlerFactory((ManagementRequestHandlerFactory)this.pongRequestHandler);
        handler.addHandlerFactory((ManagementRequestHandlerFactory)new DomainTransactionalProtocolOperationHandler(this.txOperationExecutor, (ManagementChannelAssociation)handler));
        channel.receiveMessage(handler.getReceiver());
        return handler;
    }

    private final class SlaveRequest {
        private final int domainId;
        private final AtomicInteger refCount = new AtomicInteger(1);

        SlaveRequest(int domainId) {
            this.domainId = domainId;
        }
    }

    public static interface TransactionalOperationExecutor {
        public ModelNode executeAndAttemptLock(ModelNode var1, OperationMessageHandler var2, ModelController.OperationTransactionControl var3, OperationAttachments var4, OperationStepHandler var5);

        public ModelNode joinActiveOperation(ModelNode var1, OperationMessageHandler var2, ModelController.OperationTransactionControl var3, OperationAttachments var4, OperationStepHandler var5, int var6);
    }

    private class DomainTransactionalProtocolOperationHandler
    extends TransactionalProtocolOperationHandler {
        private final TransactionalOperationExecutor executor;
        private volatile SlaveRequest activeSlaveRequest;

        public DomainTransactionalProtocolOperationHandler(TransactionalOperationExecutor executor, ManagementChannelAssociation channelAssociation) {
            super(null, channelAssociation);
            this.executor = executor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected ModelNode internalExecute(ModelNode operation, ManagementRequestContext<?> context, OperationMessageHandler messageHandler, ProxyController.ProxyOperationControl control, OperationAttachments attachments) {
            DomainTransactionalProtocolOperationHandler domainTransactionalProtocolOperationHandler;
            DomainTransactionalProtocolOperationHandler domainTransactionalProtocolOperationHandler2;
            String operationName = operation.require("operation").asString();
            if (!operationName.equals(PullDownDataForServerConfigOnSlaveHandler.OPERATION_NAME)) {
                throw HostControllerMessages.MESSAGES.cannotExecuteTransactionalOperationFromSlave(operationName);
            }
            final PullDownDataForServerConfigOnSlaveHandler handler = new PullDownDataForServerConfigOnSlaveHandler(SlaveChannelAttachments.getHostName(context.getChannel()), SlaveChannelAttachments.getTransformers(context.getChannel()), MasterDomainControllerOperationHandlerService.this.runtimeIgnoreTransformationRegistry);
            Integer domainControllerLockId = operation.get("operation-headers").hasDefined("domain-controller-lock-id") ? Integer.valueOf(operation.get(new String[]{"operation-headers", "domain-controller-lock-id"}).asInt()) : null;
            Integer slaveLockId = operation.get(new String[]{"operation-headers", "slave-controller-lock-id"}).asInt();
            if (domainControllerLockId == null) {
                domainTransactionalProtocolOperationHandler2 = this;
                synchronized (domainTransactionalProtocolOperationHandler2) {
                    SlaveRequest slaveRequest = this.activeSlaveRequest;
                    if (slaveRequest != null) {
                        domainControllerLockId = slaveRequest.domainId;
                        slaveRequest.refCount.incrementAndGet();
                    }
                }
            }
            try {
                if (domainControllerLockId != null) {
                    domainTransactionalProtocolOperationHandler2 = this.executor.joinActiveOperation(operation, messageHandler, (ModelController.OperationTransactionControl)control, attachments, handler, domainControllerLockId);
                    return domainTransactionalProtocolOperationHandler2;
                }
                ModelNode result = this.executor.executeAndAttemptLock(operation, messageHandler, (ModelController.OperationTransactionControl)control, attachments, new OperationStepHandler(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                        Integer domainControllerLockId = CurrentOperationIdHolder.getCurrentOperationID();
                        1 var4_4 = this;
                        synchronized (var4_4) {
                            DomainTransactionalProtocolOperationHandler.this.activeSlaveRequest = new SlaveRequest(domainControllerLockId);
                        }
                        context.addStep(operation, handler, OperationContext.Stage.MODEL);
                        context.stepCompleted();
                    }
                });
                domainTransactionalProtocolOperationHandler = result;
                return domainTransactionalProtocolOperationHandler;
            }
            finally {
                domainTransactionalProtocolOperationHandler = this;
                synchronized (domainTransactionalProtocolOperationHandler) {
                    int refcount;
                    SlaveRequest slaveRequest = this.activeSlaveRequest;
                    if (slaveRequest != null && (refcount = slaveRequest.refCount.decrementAndGet()) == 0) {
                        this.activeSlaveRequest = null;
                    }
                }
            }
        }
    }
}

