/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.common;

import io.undertow.Undertow;
import io.undertow.UndertowOptions;
import io.undertow.connector.ByteBufferPool;
import io.undertow.security.api.AuthenticationMode;
import io.undertow.security.handlers.AuthenticationCallHandler;
import io.undertow.security.handlers.AuthenticationConstraintHandler;
import io.undertow.security.handlers.AuthenticationMechanismsHandler;
import io.undertow.security.handlers.SecurityInitialHandler;
import io.undertow.security.idm.Account;
import io.undertow.security.idm.Credential;
import io.undertow.security.idm.IdentityManager;
import io.undertow.security.idm.PasswordCredential;
import io.undertow.security.impl.BasicAuthenticationMechanism;
import io.undertow.server.DefaultByteBufferPool;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.util.NetworkUtils;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.marshalling.river.RiverMarshallerFactory;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.InitializationError;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Xnio;
import org.xnio.XnioWorker;

public class HTTPTestServer
extends BlockJUnit4ClassRunner {
    protected static final MarshallerFactory marshallerFactory = new RiverMarshallerFactory();
    public static final int BUFFER_SIZE = Integer.getInteger("test.bufferSize", 24576);
    private static final PathHandler PATH_HANDLER = new PathHandler();
    private static final PathHandler SERVICES_HANDLER = new PathHandler();
    public static final String SFSB_ID = "SFSB_ID";
    public static final String WILDFLY_SERVICES = "/wildfly-services";
    public static final String INITIAL_SESSION_AFFINITY = "initial-session-affinity";
    public static final String LAZY_SESSION_AFFINITY = "lazy-session-affinity";
    private static boolean first = true;
    private static Undertow undertow;
    private static XnioWorker worker;
    private static final DefaultByteBufferPool pool;
    private static final Set<String> registeredPaths;
    private static final Set<String> registeredServices;

    public static String getDefaultServerURL() {
        return HTTPTestServer.getDefaultRootServerURL() + WILDFLY_SERVICES;
    }

    public static String getDefaultRootServerURL() {
        return "http://" + NetworkUtils.formatPossibleIpv6Address((String)HTTPTestServer.getHostAddress()) + ":" + HTTPTestServer.getHostPort();
    }

    public HTTPTestServer(Class<?> klass) throws InitializationError {
        super(klass);
    }

    public static ByteBufferPool getBufferPool() {
        return pool;
    }

    public Description getDescription() {
        return super.getDescription();
    }

    public void run(RunNotifier notifier) {
        this.runInternal(notifier);
        notifier.addListener(new RunListener(){

            public void testFinished(Description description) throws Exception {
                for (String reg : registeredPaths) {
                    PATH_HANDLER.removePrefixPath(reg);
                }
                registeredPaths.clear();
                for (String reg : registeredServices) {
                    SERVICES_HANDLER.removePrefixPath(reg);
                }
                registeredServices.clear();
            }
        });
        super.run(notifier);
    }

    public static void registerPathHandler(String path, HttpHandler handler) {
        PATH_HANDLER.addPrefixPath(path, handler);
        registeredPaths.add(path);
    }

    public static void registerServicesHandler(String path, HttpHandler handler) {
        SERVICES_HANDLER.addPrefixPath(path, handler);
        registeredServices.add(path);
    }

    public static XnioWorker getWorker() {
        return worker;
    }

    private void runInternal(RunNotifier notifier) {
        try {
            if (first) {
                first = false;
                Xnio xnio = Xnio.getInstance((String)"nio");
                PATH_HANDLER.addPrefixPath(WILDFLY_SERVICES, (HttpHandler)SERVICES_HANDLER);
                worker = xnio.createWorker(OptionMap.create((Option)Options.WORKER_TASK_CORE_THREADS, (Object)20, (Option)Options.WORKER_IO_THREADS, (Object)10));
                this.registerPaths(SERVICES_HANDLER);
                undertow = Undertow.builder().addHttpListener(HTTPTestServer.getHostPort(), HTTPTestServer.getHostAddress()).setServerOption(UndertowOptions.REQUIRE_HOST_HTTP11, (Object)true).setHandler((HttpHandler)new SecurityInitialHandler(AuthenticationMode.PRO_ACTIVE, new IdentityManager(){

                    public Account verify(Account account) {
                        return null;
                    }

                    public Account verify(String id, Credential credential) {
                        if (credential instanceof PasswordCredential && id.equals("administrator") && Arrays.equals(((PasswordCredential)credential).getPassword(), "password1!".toCharArray())) {
                            return new Account(){

                                public Principal getPrincipal() {
                                    return () -> "administrator";
                                }

                                public Set<String> getRoles() {
                                    return Collections.emptySet();
                                }
                            };
                        }
                        return null;
                    }

                    public Account verify(Credential credential) {
                        return null;
                    }
                }, (HttpHandler)new AuthenticationConstraintHandler((HttpHandler)new AuthenticationMechanismsHandler((HttpHandler)new AuthenticationCallHandler((HttpHandler)PATH_HANDLER), Collections.singletonList(new BasicAuthenticationMechanism("test")))))).build();
                undertow.start();
                notifier.addListener(new RunListener(){

                    public void testRunFinished(Result result) throws Exception {
                        undertow.stop();
                    }
                });
            }
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
    }

    protected void registerPaths(PathHandler servicesHandler) {
    }

    public static String getHostAddress() {
        return System.getProperty("server.address", "localhost");
    }

    public static int getHostPort() {
        return Integer.getInteger("server.port", 7788);
    }

    private static String handleDash(String s) {
        if (s.equals("-")) {
            return "";
        }
        return s;
    }

    static {
        pool = new DefaultByteBufferPool(true, BUFFER_SIZE, 1000, 10, 100);
        registeredPaths = new HashSet<String>();
        registeredServices = new HashSet<String>();
    }
}

