/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.common;

import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import org.junit.Assert;
import org.junit.Test;
import org.wildfly.client.config.ConfigXMLParseException;
import org.wildfly.httpclient.common.HttpClientXmlParser;
import org.wildfly.httpclient.common.WildflyHttpContext;

public class WildflyClientParserTestCase {
    @Test
    public void testXMLParsing() throws URISyntaxException, ConfigXMLParseException {
        WildflyHttpContext.Builder builder = HttpClientXmlParser.parseConfig((URI)this.getClass().getClassLoader().getResource("ejb-client.xml").toURI());
        Assert.assertEquals((Object)InetSocketAddress.createUnresolved("127.0.0.1", 3456), (Object)builder.getDefaultBindAddress());
        Assert.assertEquals((long)10000L, (long)builder.getIdleTimeout());
        Assert.assertEquals((long)1L, (long)builder.getMaxConnections());
        Assert.assertEquals((long)1L, (long)builder.getMaxStreamsPerConnection());
        Assert.assertEquals((Object)false, (Object)builder.getEagerlyAcquireSession());
        Assert.assertEquals((long)1L, (long)builder.getTargets().size());
        WildflyHttpContext.Builder.HttpConfigBuilder context = (WildflyHttpContext.Builder.HttpConfigBuilder)builder.getTargets().get(0);
        Assert.assertEquals((Object)InetSocketAddress.createUnresolved("127.0.0.1", 5678), (Object)context.getBindAddress());
        Assert.assertEquals((long)30000L, (long)context.getIdleTimeout());
        Assert.assertEquals((long)20L, (long)context.getMaxConnections());
        Assert.assertEquals((long)20L, (long)context.getMaxStreamsPerConnection());
        Assert.assertEquals((Object)true, (Object)context.getEagerlyAcquireSession());
        Assert.assertEquals((Object)new URI("http://localhost:8080"), (Object)context.getUri());
    }
}

