/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.common;

import io.undertow.Undertow;
import io.undertow.UndertowOptions;
import io.undertow.connector.ByteBufferPool;
import io.undertow.security.api.AuthenticationMode;
import io.undertow.security.handlers.AuthenticationCallHandler;
import io.undertow.security.handlers.AuthenticationConstraintHandler;
import io.undertow.security.handlers.AuthenticationMechanismsHandler;
import io.undertow.security.handlers.SecurityInitialHandler;
import io.undertow.security.idm.Account;
import io.undertow.security.idm.Credential;
import io.undertow.security.idm.DigestCredential;
import io.undertow.security.idm.IdentityManager;
import io.undertow.security.idm.PasswordCredential;
import io.undertow.security.idm.X509CertificateCredential;
import io.undertow.security.impl.BasicAuthenticationMechanism;
import io.undertow.security.impl.ClientCertAuthenticationMechanism;
import io.undertow.security.impl.DigestAuthenticationMechanism;
import io.undertow.server.DefaultByteBufferPool;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.CanonicalPathHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.error.SimpleErrorPageHandler;
import io.undertow.util.HexConverter;
import io.undertow.util.NetworkUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.InitializationError;
import org.wildfly.security.WildFlyElytronProvider;
import org.xnio.IoUtils;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.SslClientAuthMode;
import org.xnio.Xnio;
import org.xnio.XnioWorker;

public class HTTPTestServer
extends BlockJUnit4ClassRunner {
    public static final int BUFFER_SIZE = Integer.getInteger("test.bufferSize", 24576);
    private static final PathHandler PATH_HANDLER = new PathHandler();
    private static final PathHandler SERVICES_HANDLER = new PathHandler();
    public static final String WILDFLY_SERVICES = "/wildfly-services";
    public static final String INITIAL_SESSION_AFFINITY = "initial-session-affinity";
    private static final String SERVER_KEY_STORE = "server.keystore";
    private static final String SERVER_TRUST_STORE = "server.truststore";
    public static final String CLIENT_KEY_STORE = "client.keystore";
    public static final String CLIENT_TRUST_STORE = "client.truststore";
    public static final char[] STORE_PASSWORD = "password".toCharArray();
    private static boolean first = true;
    private static Undertow undertow;
    private static XnioWorker worker;
    private static final DefaultByteBufferPool pool;
    private static final Set<String> registeredPaths;
    private static final Set<String> registeredServices;

    public static String getDefaultServerURL() {
        return HTTPTestServer.getDefaultRootServerURL() + WILDFLY_SERVICES;
    }

    public static String getDefaultRootServerURL() {
        return "http://" + NetworkUtils.formatPossibleIpv6Address((String)HTTPTestServer.getHostAddress()) + ":" + HTTPTestServer.getHostPort();
    }

    public static String getDefaultSSLRootServerURL() {
        return "https://" + NetworkUtils.formatPossibleIpv6Address((String)HTTPTestServer.getHostAddress()) + ":" + HTTPTestServer.getSSLHostPort();
    }

    public static String getDefaultSSLServerURL() {
        return HTTPTestServer.getDefaultSSLRootServerURL() + WILDFLY_SERVICES;
    }

    public HTTPTestServer(Class<?> klass) throws InitializationError {
        super(klass);
    }

    public static ByteBufferPool getBufferPool() {
        return pool;
    }

    public Description getDescription() {
        return super.getDescription();
    }

    public void run(RunNotifier notifier) {
        this.runInternal(notifier);
        notifier.addListener(new RunListener(){

            public void testFinished(Description description) throws Exception {
                for (String reg : registeredPaths) {
                    PATH_HANDLER.removePrefixPath(reg);
                }
                registeredPaths.clear();
                for (String reg : registeredServices) {
                    SERVICES_HANDLER.removePrefixPath(reg);
                }
                registeredServices.clear();
            }
        });
        super.run(notifier);
    }

    public static void registerPathHandler(String path, HttpHandler handler) {
        PATH_HANDLER.addPrefixPath(path, handler);
        registeredPaths.add(path);
    }

    public static void registerServicesHandler(String path, HttpHandler handler) {
        SERVICES_HANDLER.addPrefixPath(path, handler);
        registeredServices.add(path);
    }

    public static XnioWorker getWorker() {
        return worker;
    }

    private void runInternal(RunNotifier notifier) {
        try {
            if (first) {
                first = false;
                Xnio xnio = Xnio.getInstance((String)"nio");
                PATH_HANDLER.addPrefixPath(WILDFLY_SERVICES, (HttpHandler)SERVICES_HANDLER);
                worker = xnio.createWorker(OptionMap.create((Option)Options.WORKER_TASK_CORE_THREADS, (Object)20, (Option)Options.WORKER_IO_THREADS, (Object)10));
                this.registerPaths(SERVICES_HANDLER);
                undertow = Undertow.builder().addHttpListener(HTTPTestServer.getHostPort(), HTTPTestServer.getHostAddress()).addHttpsListener(HTTPTestServer.getSSLHostPort(), HTTPTestServer.getHostAddress(), this.createServerSslContext()).setServerOption(UndertowOptions.REQUIRE_HOST_HTTP11, (Object)true).setServerOption(UndertowOptions.NO_REQUEST_TIMEOUT, (Object)1000).setSocketOption(Options.SSL_CLIENT_AUTH_MODE, (Object)SslClientAuthMode.REQUIRED).setHandler((HttpHandler)new SecurityInitialHandler(AuthenticationMode.PRO_ACTIVE, new IdentityManager(){

                    public Account verify(Account account) {
                        return null;
                    }

                    public Account verify(String id, Credential credential) {
                        if (credential instanceof PasswordCredential) {
                            if (id.equals("administrator") && Arrays.equals(((PasswordCredential)credential).getPassword(), "password1!".toCharArray())) {
                                return new TestAccount();
                            }
                        } else if (credential instanceof DigestCredential) {
                            DigestCredential digCred = (DigestCredential)credential;
                            MessageDigest digest = null;
                            try {
                                digest = digCred.getAlgorithm().getMessageDigest();
                                digest.update(id.getBytes(StandardCharsets.UTF_8));
                                digest.update((byte)58);
                                digest.update(digCred.getRealm().getBytes(StandardCharsets.UTF_8));
                                digest.update((byte)58);
                                char[] expectedPassword = "password1!".toCharArray();
                                digest.update(new String(expectedPassword).getBytes(StandardCharsets.UTF_8));
                                if (digCred.verifyHA1(HexConverter.convertToHexBytes((byte[])digest.digest()))) {
                                    TestAccount testAccount = new TestAccount();
                                    return testAccount;
                                }
                            }
                            catch (NoSuchAlgorithmException e) {
                                throw new IllegalStateException("Unsupported Algorithm", e);
                            }
                            finally {
                                digest.reset();
                            }
                        }
                        return null;
                    }

                    public Account verify(Credential credential) {
                        final X509CertificateCredential cred = (X509CertificateCredential)credential;
                        return new Account(){

                            public Principal getPrincipal() {
                                return cred.getCertificate().getSubjectX500Principal();
                            }

                            public Set<String> getRoles() {
                                return Collections.emptySet();
                            }
                        };
                    }
                }, this.getRootHandler())).build();
                undertow.start();
                notifier.addListener(new RunListener(){

                    public void testRunFinished(Result result) throws Exception {
                        undertow.stop();
                    }
                });
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected HttpHandler getRootHandler() {
        AuthenticationCallHandler root = new AuthenticationCallHandler((HttpHandler)PATH_HANDLER);
        root = new AuthenticationMechanismsHandler((HttpHandler)root, Arrays.asList(new BasicAuthenticationMechanism("myRealm", "BASIC", true), new DigestAuthenticationMechanism("test", "localhost", "DIGEST"), new ClientCertAuthenticationMechanism(true)));
        root = new AuthenticationConstraintHandler((HttpHandler)root);
        root = new SimpleErrorPageHandler((HttpHandler)root);
        root = new CanonicalPathHandler((HttpHandler)root);
        return root;
    }

    private SSLContext createServerSslContext() {
        return HTTPTestServer.createSSLContext(HTTPTestServer.loadKeyStore(SERVER_KEY_STORE), HTTPTestServer.loadKeyStore(SERVER_TRUST_STORE));
    }

    private static SSLContext createSSLContext(KeyStore keyStore, KeyStore trustStore) {
        KeyManager[] keyManagers;
        try {
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, STORE_PASSWORD);
            keyManagers = keyManagerFactory.getKeyManagers();
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new RuntimeException("Unable to initialise KeyManager[]", e);
        }
        TrustManager[] trustManagers = null;
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(trustStore);
            trustManagers = trustManagerFactory.getTrustManagers();
        }
        catch (KeyStoreException | NoSuchAlgorithmException e) {
            throw new RuntimeException("Unable to initialise TrustManager[]", e);
        }
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(keyManagers, trustManagers, null);
            return sslContext;
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new RuntimeException("Unable to create and initialise the SSLContext", e);
        }
    }

    public static KeyStore loadKeyStore(String name) {
        InputStream stream = HTTPTestServer.class.getClassLoader().getResourceAsStream(name);
        if (stream == null) {
            throw new RuntimeException("Could not load keystore");
        }
        try {
            KeyStore loadedKeystore = KeyStore.getInstance("JKS");
            loadedKeystore.load(stream, STORE_PASSWORD);
            KeyStore keyStore = loadedKeystore;
            return keyStore;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new RuntimeException(String.format("Unable to load KeyStore %s", name), e);
        }
        finally {
            IoUtils.safeClose((Closeable)stream);
        }
    }

    protected void registerPaths(PathHandler servicesHandler) {
    }

    public static String getHostAddress() {
        return System.getProperty("server.address", "localhost");
    }

    public static int getHostPort() {
        return Integer.getInteger("server.port", 7788);
    }

    public static int getSSLHostPort() {
        return HTTPTestServer.getHostPort() + 1;
    }

    static {
        pool = new DefaultByteBufferPool(true, BUFFER_SIZE, 1000, 10, 100);
        registeredPaths = new HashSet<String>();
        registeredServices = new HashSet<String>();
        Security.addProvider((Provider)new WildFlyElytronProvider());
    }

    private static class TestAccount
    implements Account {
        private TestAccount() {
        }

        public Principal getPrincipal() {
            return () -> "administrator";
        }

        public Set<String> getRoles() {
            return Collections.emptySet();
        }
    }
}

