/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.common;

import io.undertow.client.ClientRequest;
import io.undertow.client.ClientResponse;
import io.undertow.security.impl.DigestWWWAuthenticateToken;
import io.undertow.server.session.SecureRandomSessionIdGenerator;
import io.undertow.util.FlexBase64;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import io.undertow.util.HexConverter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.wildfly.httpclient.common.HttpClientMessages;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.AuthenticationContextConfigurationClient;
import org.wildfly.security.auth.principal.NamePrincipal;

class PoolAuthenticationContext {
    private static final AuthenticationContextConfigurationClient AUTH_CONTEXT_CLIENT = AccessController.doPrivileged(AuthenticationContextConfigurationClient::new);
    private volatile Type current;
    private String realm;
    private String domain;
    private String nonce;
    private String opaque;
    private String algorithm;
    private String qop;
    private int nccount = 1;
    private static final SecureRandomSessionIdGenerator cnonceGenerator = new SecureRandomSessionIdGenerator();

    PoolAuthenticationContext() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean handleResponse(ClientResponse response) {
        if (response.getResponseCode() != 401) {
            return false;
        }
        String authenticate = response.getResponseHeaders().getFirst(Headers.WWW_AUTHENTICATE);
        if (authenticate == null) {
            return false;
        }
        String auth = authenticate.toLowerCase(Locale.ENGLISH);
        if (auth.startsWith("basic ")) {
            this.current = Type.BASIC;
            return true;
        }
        if (auth.startsWith("digest ")) {
            this.current = Type.DIGEST;
            Map result = DigestWWWAuthenticateToken.parseHeader((String)authenticate.substring(7));
            PoolAuthenticationContext poolAuthenticationContext = this;
            synchronized (poolAuthenticationContext) {
                this.domain = (String)result.get(DigestWWWAuthenticateToken.DOMAIN);
                this.nonce = (String)result.get(DigestWWWAuthenticateToken.NONCE);
                this.opaque = (String)result.get(DigestWWWAuthenticateToken.OPAQUE);
                this.algorithm = (String)result.get(DigestWWWAuthenticateToken.ALGORITHM);
                String s = (String)result.get(DigestWWWAuthenticateToken.MESSAGE_QOP);
                this.qop = null;
                if (s != null) {
                    for (String p : s.split(",")) {
                        if (!p.equals("auth")) continue;
                        this.qop = p;
                    }
                    if (this.qop == null) {
                        throw HttpClientMessages.MESSAGES.unsupportedQopInDigest();
                    }
                }
                this.realm = (String)result.get(DigestWWWAuthenticateToken.REALM);
                this.nccount = 1;
                if (this.algorithm.startsWith("\"")) {
                    this.algorithm = this.algorithm.substring(1, this.algorithm.length() - 1);
                }
            }
            return true;
        }
        return false;
    }

    boolean prepareRequest(URI uri, ClientRequest request, AuthenticationConfiguration authenticationConfiguration) {
        if (this.current == Type.NONE) {
            return false;
        }
        AuthenticationConfiguration config = authenticationConfiguration;
        if (config == null) {
            config = AUTH_CONTEXT_CLIENT.getAuthenticationConfiguration(uri, AuthenticationContext.captureCurrent());
        }
        CallbackHandler callbackHandler = AUTH_CONTEXT_CLIENT.getCallbackHandler(config);
        NameCallback nameCallback = new NameCallback("user name");
        PasswordCallback passwordCallback = new PasswordCallback("password", false);
        try {
            callbackHandler.handle(new Callback[]{nameCallback, passwordCallback});
        }
        catch (IOException | UnsupportedCallbackException e) {
            return false;
        }
        String name = nameCallback.getName();
        if (name == null) {
            return false;
        }
        char[] password = passwordCallback.getPassword();
        if (password == null) {
            return false;
        }
        NamePrincipal principal = new NamePrincipal(name);
        if (this.current == Type.BASIC) {
            String challenge = principal.getName() + ":" + new String(password);
            request.getRequestHeaders().put(Headers.AUTHORIZATION, "Basic " + FlexBase64.encodeString((byte[])challenge.getBytes(StandardCharsets.UTF_8), (boolean)false));
            return true;
        }
        if (this.current == Type.DIGEST) {
            String cnonce = cnonceGenerator.createSessionId();
            String digestUri = null;
            try {
                String query;
                String path;
                int pos = request.getPath().indexOf("?");
                if (pos > 0) {
                    path = request.getPath().substring(0, pos);
                    query = request.getPath().substring(pos + 1);
                } else {
                    path = request.getPath();
                    query = null;
                }
                digestUri = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), path, query, null).toString();
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            PoolAuthenticationContext poolAuthenticationContext = this;
            synchronized (poolAuthenticationContext) {
                StringBuilder sb = new StringBuilder("Digest username=\"");
                sb.append(principal.getName());
                sb.append("\", uri=\"");
                sb.append(digestUri);
                sb.append("\", realm=\"");
                sb.append(this.realm);
                sb.append("\"");
                StringBuilder ncBuilder = new StringBuilder();
                if (this.qop != null) {
                    sb.append(", nc=");
                    String nonceCountString = Integer.toHexString(this.nccount++);
                    for (int i = nonceCountString.length(); i < 8; ++i) {
                        ncBuilder.append("0");
                    }
                    ncBuilder.append(nonceCountString);
                    sb.append(ncBuilder.toString());
                    sb.append(", cnonce=\"");
                    sb.append(cnonce);
                    sb.append("\"");
                }
                sb.append(", algorithm=");
                sb.append(this.algorithm);
                sb.append(", nonce=\"");
                sb.append(this.nonce);
                sb.append("\", opaque=\"");
                sb.append(this.opaque);
                sb.append("\", qop=auth");
                String a1 = principal.getName() + ":" + this.realm + ":" + new String(password);
                String a2 = request.getMethod().toString() + ":" + digestUri;
                try {
                    MessageDigest digest = MessageDigest.getInstance(this.algorithm);
                    digest.update(a1.getBytes(StandardCharsets.UTF_8));
                    byte[] hashedA1 = HexConverter.convertToHexBytes((byte[])digest.digest());
                    digest.reset();
                    digest.update(a2.getBytes(StandardCharsets.UTF_8));
                    String hashedA2 = HexConverter.convertToHexString((byte[])digest.digest());
                    digest.reset();
                    digest.update(hashedA1);
                    digest.update((byte)58);
                    digest.update(this.nonce.getBytes(StandardCharsets.UTF_8));
                    digest.update((byte)58);
                    if (this.qop != null) {
                        digest.update(ncBuilder.toString().getBytes(StandardCharsets.UTF_8));
                        digest.update((byte)58);
                        digest.update(cnonce.getBytes(StandardCharsets.UTF_8));
                        digest.update((byte)58);
                        digest.update("auth".getBytes(StandardCharsets.UTF_8));
                        digest.update((byte)58);
                    }
                    digest.update(hashedA2.getBytes(StandardCharsets.UTF_8));
                    sb.append(", response=\"");
                    sb.append(HexConverter.convertToHexString((byte[])digest.digest()));
                    sb.append("\"");
                    request.getRequestHeaders().put(Headers.AUTHORIZATION, sb.toString());
                    return true;
                }
                catch (NoSuchAlgorithmException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return false;
    }

    boolean isStale(ClientResponse response) {
        if (this.current != Type.DIGEST) {
            return false;
        }
        if (response.getResponseCode() != 401) {
            return false;
        }
        HeaderValues headers = response.getResponseHeaders().get(Headers.WWW_AUTHENTICATE);
        if (headers == null) {
            return false;
        }
        for (String authenticate : headers) {
            Map result;
            String auth = authenticate.toLowerCase(Locale.ENGLISH);
            if (!auth.startsWith("digest ") || !(result = DigestWWWAuthenticateToken.parseHeader((String)authenticate.substring(7))).containsKey(DigestWWWAuthenticateToken.STALE)) continue;
            return true;
        }
        return false;
    }

    static enum Type {
        NONE,
        BASIC,
        DIGEST;

    }
}

