/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.common;

import io.undertow.client.ClientCallback;
import io.undertow.client.ClientConnection;
import io.undertow.client.ClientExchange;
import io.undertow.client.ClientRequest;
import io.undertow.client.ClientResponse;
import io.undertow.client.ContinueNotification;
import io.undertow.client.PushCallback;
import io.undertow.connector.ByteBufferPool;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.AbstractAttachable;
import io.undertow.util.AttachmentKey;
import io.undertow.util.AttachmentList;
import io.undertow.util.HeaderValues;
import io.undertow.util.HttpString;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import javax.net.ssl.SSLContext;
import org.jboss.marshalling.ClassNameTransformer;
import org.wildfly.httpclient.common.HostPool;
import org.wildfly.httpclient.common.HttpClientMessages;
import org.wildfly.httpclient.common.HttpConnectionPool;
import org.wildfly.httpclient.common.HttpConnectionPoolFactory;
import org.wildfly.httpclient.common.HttpMarshallerFactory;
import org.wildfly.httpclient.common.HttpMarshallerFactoryProvider;
import org.wildfly.security.manager.WildFlySecurityManager;
import org.xnio.OptionMap;
import org.xnio.XnioWorker;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;

final class EENamespaceInteroperability {
    private static final String VARIABLE_CONSTANT = "javax.ejb.FAKE_STRING";
    private static final boolean JAKARTAEE_ENVIRONMENT = "javax.ejb.FAKE_STRING".startsWith("jakarta");
    static final boolean EE_NAMESPACE_INTEROPERABLE_MODE = JAKARTAEE_ENVIRONMENT && Boolean.parseBoolean(WildFlySecurityManager.getPropertyPrivileged((String)"org.wildfly.ee.namespace.interop", (String)"false"));
    private static final HttpString EE_NAMESPACE = new HttpString("x-wf-ee-ns");
    private static final String JAKARTA_EE = "jakarta";
    private static final String EE_INTEROP = "interop";
    private static final AttachmentKey<HttpMarshallerFactory> HTTP_MARSHALLER_FACTORY_KEY = AttachmentKey.create(HttpMarshallerFactory.class);
    private static final AttachmentKey<HttpMarshallerFactory> HTTP_UNMARSHALLER_FACTORY_KEY = AttachmentKey.create(HttpMarshallerFactory.class);
    private static final HttpMarshallerFactory INTEROPERABLE_MARSHALLER_FACTORY = new HttpMarshallerFactory(ClassNameTransformer.JAVAEE_TO_JAKARTAEE);

    private EENamespaceInteroperability() {
    }

    static HttpHandler createInteroperabilityHandler(HttpHandler httpHandler) {
        return new EENamespaceInteroperabilityHandler(httpHandler);
    }

    static HttpHandler createPartialInteroperabilityHandler(HttpHandler httpHandler) {
        return new EENamespacePartialInteroperabilityHandler(httpHandler);
    }

    static HttpMarshallerFactoryProvider getHttpMarshallerFactoryProvider() {
        return new HttpMarshallerFactoryProvider(){

            @Override
            public HttpMarshallerFactory getMarshallerFactory(AbstractAttachable attachable) {
                return (HttpMarshallerFactory)attachable.getAttachment(HTTP_MARSHALLER_FACTORY_KEY);
            }

            @Override
            public HttpMarshallerFactory getUnmarshallerFactory(AbstractAttachable attachable) {
                return (HttpMarshallerFactory)attachable.getAttachment(HTTP_UNMARSHALLER_FACTORY_KEY);
            }
        };
    }

    static HttpConnectionPoolFactory getHttpConnectionPoolFactory() {
        return HttpConnectionPool::new;
    }

    static {
        if (EE_NAMESPACE_INTEROPERABLE_MODE) {
            HttpClientMessages.MESSAGES.javaeeToJakartaeeBackwardCompatibilityLayerInstalled();
        }
    }

    private static class EENamespacePartialInteroperabilityHandler
    implements HttpHandler {
        private final HttpHandler next;

        EENamespacePartialInteroperabilityHandler(HttpHandler next) {
            this.next = next;
        }

        public void handleRequest(HttpServerExchange exchange) throws Exception {
            if (exchange.getRequestHeaders().contains(EE_NAMESPACE) && exchange.getRequestHeaders().getFirst(EE_NAMESPACE).equals(EENamespaceInteroperability.EE_INTEROP)) {
                exchange.getResponseHeaders().add(EE_NAMESPACE, EENamespaceInteroperability.JAKARTA_EE);
                exchange.putAttachment(HTTP_UNMARSHALLER_FACTORY_KEY, (Object)INTEROPERABLE_MARSHALLER_FACTORY);
                exchange.putAttachment(HTTP_MARSHALLER_FACTORY_KEY, (Object)HttpMarshallerFactory.DEFAULT_FACTORY);
            }
            this.next.handleRequest(exchange);
        }
    }

    private static class EENamespaceInteroperabilityHandler
    implements HttpHandler {
        private final HttpHandler next;

        EENamespaceInteroperabilityHandler(HttpHandler next) {
            this.next = next;
        }

        public void handleRequest(HttpServerExchange exchange) throws Exception {
            if (exchange.getRequestHeaders().contains(EE_NAMESPACE)) {
                switch (exchange.getRequestHeaders().getFirst(EE_NAMESPACE)) {
                    case "interop": {
                        exchange.getResponseHeaders().add(EE_NAMESPACE, EENamespaceInteroperability.JAKARTA_EE);
                        exchange.putAttachment(HTTP_UNMARSHALLER_FACTORY_KEY, (Object)INTEROPERABLE_MARSHALLER_FACTORY);
                        exchange.putAttachment(HTTP_MARSHALLER_FACTORY_KEY, (Object)HttpMarshallerFactory.DEFAULT_FACTORY);
                        break;
                    }
                    case "jakarta": {
                        exchange.putAttachment(HTTP_MARSHALLER_FACTORY_KEY, (Object)HttpMarshallerFactory.DEFAULT_FACTORY);
                        exchange.putAttachment(HTTP_UNMARSHALLER_FACTORY_KEY, (Object)HttpMarshallerFactory.DEFAULT_FACTORY);
                    }
                }
            } else {
                exchange.putAttachment(HTTP_MARSHALLER_FACTORY_KEY, (Object)INTEROPERABLE_MARSHALLER_FACTORY);
                exchange.putAttachment(HTTP_UNMARSHALLER_FACTORY_KEY, (Object)INTEROPERABLE_MARSHALLER_FACTORY);
            }
            this.next.handleRequest(exchange);
        }
    }

    private static class HttpConnectionPool
    extends org.wildfly.httpclient.common.HttpConnectionPool {
        protected HttpConnectionPool(int maxConnections, int maxStreamsPerConnection, XnioWorker worker, ByteBufferPool byteBufferPool, OptionMap options, HostPool hostPool, long connectionIdleTimeout) {
            super(maxConnections, maxStreamsPerConnection, worker, byteBufferPool, options, hostPool, connectionIdleTimeout);
        }

        @Override
        protected HttpConnectionPool.ClientConnectionHolder createClientConnectionHolder(ClientConnection connection, URI uri, SSLContext sslContext) {
            return new ClientConnectionHolder(connection, uri, sslContext);
        }

        protected class ClientConnectionHolder
        extends HttpConnectionPool.ClientConnectionHolder {
            private static final int NEW = 4;
            private static final int JAKARTA_EE_NS = 8;

            private ClientConnectionHolder(ClientConnection connection, URI uri, SSLContext sslContext) {
                super(connection, uri, sslContext);
                this.setFlags(4);
            }

            @Override
            public void sendRequest(ClientRequest request, final ClientCallback<ClientExchange> callback) {
                if (this.hasFlags(4)) {
                    request.getRequestHeaders().put(EE_NAMESPACE, EENamespaceInteroperability.EE_INTEROP);
                    request.putAttachment(HTTP_MARSHALLER_FACTORY_KEY, (Object)INTEROPERABLE_MARSHALLER_FACTORY);
                    this.clearFlags(4);
                } else if (this.hasFlags(8)) {
                    request.getRequestHeaders().put(EE_NAMESPACE, EENamespaceInteroperability.JAKARTA_EE);
                    request.putAttachment(HTTP_MARSHALLER_FACTORY_KEY, (Object)HttpMarshallerFactory.DEFAULT_FACTORY);
                } else {
                    request.putAttachment(HTTP_MARSHALLER_FACTORY_KEY, (Object)INTEROPERABLE_MARSHALLER_FACTORY);
                }
                super.sendRequest(request, new ClientCallback<ClientExchange>(){

                    public void completed(ClientExchange result) {
                        callback.completed((Object)new EEInteroperableClientExchange(result));
                    }

                    public void failed(IOException e) {
                        callback.failed(e);
                    }
                });
            }

            private final class EEInteroperableClientExchange
            implements ClientExchange {
                private final ClientExchange wrappedExchange;

                public EEInteroperableClientExchange(ClientExchange clientExchange) {
                    this.wrappedExchange = clientExchange;
                }

                public void setResponseListener(final ClientCallback<ClientExchange> responseListener) {
                    this.wrappedExchange.setResponseListener((ClientCallback)new ClientCallback<ClientExchange>(){

                        public void completed(ClientExchange result) {
                            HeaderValues serverEENamespace;
                            ClientResponse response = result.getResponse();
                            if (!ClientConnectionHolder.this.hasFlags(8) && (serverEENamespace = response.getResponseHeaders().get(EE_NAMESPACE)) != null && serverEENamespace.contains((Object)EENamespaceInteroperability.JAKARTA_EE)) {
                                ClientConnectionHolder.this.setFlags(8);
                                result.getRequest().putAttachment(HTTP_MARSHALLER_FACTORY_KEY, (Object)HttpMarshallerFactory.DEFAULT_FACTORY);
                            }
                            responseListener.completed((Object)result);
                        }

                        public void failed(IOException e) {
                            responseListener.failed(e);
                        }
                    });
                }

                public void setContinueHandler(ContinueNotification continueHandler) {
                    this.wrappedExchange.setContinueHandler(continueHandler);
                }

                public void setPushHandler(PushCallback pushCallback) {
                    this.wrappedExchange.setPushHandler(pushCallback);
                }

                public StreamSinkChannel getRequestChannel() {
                    return this.wrappedExchange.getRequestChannel();
                }

                public StreamSourceChannel getResponseChannel() {
                    return this.wrappedExchange.getResponseChannel();
                }

                public ClientRequest getRequest() {
                    return this.wrappedExchange.getRequest();
                }

                public ClientResponse getResponse() {
                    return this.wrappedExchange.getResponse();
                }

                public ClientResponse getContinueResponse() {
                    return this.wrappedExchange.getContinueResponse();
                }

                public ClientConnection getConnection() {
                    return this.wrappedExchange.getConnection();
                }

                public <T> T getAttachment(AttachmentKey<T> key) {
                    return (T)this.wrappedExchange.getAttachment(key);
                }

                public <T> List<T> getAttachmentList(AttachmentKey<? extends List<T>> key) {
                    return this.wrappedExchange.getAttachmentList(key);
                }

                public <T> T putAttachment(AttachmentKey<T> key, T value) {
                    return (T)this.wrappedExchange.putAttachment(key, value);
                }

                public <T> T removeAttachment(AttachmentKey<T> key) {
                    return (T)this.wrappedExchange.removeAttachment(key);
                }

                public <T> void addToAttachmentList(AttachmentKey<AttachmentList<T>> key, T value) {
                    this.wrappedExchange.addToAttachmentList(key, value);
                }
            }
        }
    }
}

