/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.common;

import io.undertow.Undertow;
import io.undertow.UndertowOptions;
import io.undertow.connector.ByteBufferPool;
import io.undertow.security.api.AuthenticationMode;
import io.undertow.security.handlers.AuthenticationCallHandler;
import io.undertow.security.idm.Account;
import io.undertow.server.DefaultByteBufferPool;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.BlockingHandler;
import io.undertow.server.handlers.CanonicalPathHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.error.SimpleErrorPageHandler;
import io.undertow.util.NetworkUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Permission;
import java.security.Principal;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.spec.KeySpec;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.InitializationError;
import org.wildfly.elytron.web.undertow.server.ElytronContextAssociationHandler;
import org.wildfly.security.WildFlyElytronProvider;
import org.wildfly.security.auth.permission.LoginPermission;
import org.wildfly.security.auth.realm.SimpleMapBackedSecurityRealm;
import org.wildfly.security.auth.realm.SimpleRealmEntry;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.auth.server.http.HttpAuthenticationFactory;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.http.HttpServerAuthenticationMechanism;
import org.wildfly.security.http.HttpServerAuthenticationMechanismFactory;
import org.wildfly.security.http.basic.BasicMechanismFactory;
import org.wildfly.security.http.cert.ClientCertMechanismFactory;
import org.wildfly.security.http.digest.DigestMechanismFactory;
import org.wildfly.security.http.util.AggregateServerMechanismFactory;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.spec.ClearPasswordSpec;
import org.wildfly.security.permission.PermissionVerifier;
import org.xnio.IoUtils;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.SslClientAuthMode;
import org.xnio.Xnio;
import org.xnio.XnioWorker;

public class HTTPTestServer
extends BlockJUnit4ClassRunner {
    public static final int BUFFER_SIZE = Integer.getInteger("test.bufferSize", 24576);
    private static final PathHandler PATH_HANDLER = new PathHandler();
    private static final PathHandler SERVICES_HANDLER = new PathHandler();
    public static final String WILDFLY_SERVICES = "/wildfly-services";
    public static final String INITIAL_SESSION_AFFINITY = "initial-session-affinity";
    private static final String SERVER_KEY_STORE = "server.keystore";
    private static final String SERVER_TRUST_STORE = "server.truststore";
    public static final String CLIENT_KEY_STORE = "client.keystore";
    public static final String CLIENT_TRUST_STORE = "client.truststore";
    public static final char[] STORE_PASSWORD = "password".toCharArray();
    private static boolean first = true;
    private static Undertow undertow;
    private static XnioWorker worker;
    private static final DefaultByteBufferPool pool;
    private static final Set<String> registeredPaths;
    private static final Set<String> registeredServices;
    private SecurityDomain securityDomain;

    public static String getDefaultServerURL() {
        return HTTPTestServer.getDefaultRootServerURL() + WILDFLY_SERVICES;
    }

    public static String getDefaultRootServerURL() {
        return "http://" + NetworkUtils.formatPossibleIpv6Address((String)HTTPTestServer.getHostAddress()) + ":" + HTTPTestServer.getHostPort();
    }

    public static String getDefaultSSLRootServerURL() {
        return "https://" + NetworkUtils.formatPossibleIpv6Address((String)HTTPTestServer.getHostAddress()) + ":" + HTTPTestServer.getSSLHostPort();
    }

    public static String getDefaultSSLServerURL() {
        return HTTPTestServer.getDefaultSSLRootServerURL() + WILDFLY_SERVICES;
    }

    public HTTPTestServer(Class<?> klass) throws InitializationError {
        super(klass);
    }

    public static ByteBufferPool getBufferPool() {
        return pool;
    }

    public Description getDescription() {
        return super.getDescription();
    }

    public void run(RunNotifier notifier) {
        this.runInternal(notifier);
        notifier.addListener(new RunListener(){

            public void testFinished(Description description) throws Exception {
                for (String reg : registeredPaths) {
                    PATH_HANDLER.removePrefixPath(reg);
                }
                registeredPaths.clear();
                for (String reg : registeredServices) {
                    SERVICES_HANDLER.removePrefixPath(reg);
                }
                registeredServices.clear();
            }
        });
        super.run(notifier);
    }

    public static void registerPathHandler(String path, HttpHandler handler) {
        PATH_HANDLER.addPrefixPath(path, handler);
        registeredPaths.add(path);
    }

    public static void registerServicesHandler(String path, HttpHandler handler) {
        SERVICES_HANDLER.addPrefixPath(path, handler);
        registeredServices.add(path);
    }

    public static XnioWorker getWorker() {
        return worker;
    }

    private HttpHandler securityContextAssociationHandlerElytron() {
        ElytronContextAssociationHandler.Builder builder = ElytronContextAssociationHandler.builder();
        builder.setAuthenticationMode(AuthenticationMode.PRO_ACTIVE).setSecurityDomain(this.getSecurityDomain()).setMechanismSupplier(this::authenticationMechanisms).setNext(this.getRootHandler());
        return builder.build();
    }

    private List<HttpServerAuthenticationMechanism> authenticationMechanisms() {
        BasicMechanismFactory basic = new BasicMechanismFactory();
        DigestMechanismFactory digest = new DigestMechanismFactory();
        ClientCertMechanismFactory clientCert = new ClientCertMechanismFactory();
        AggregateServerMechanismFactory aggregated = new AggregateServerMechanismFactory(new HttpServerAuthenticationMechanismFactory[]{basic, digest, clientCert});
        HttpAuthenticationFactory httpAuthenticationFactory = HttpAuthenticationFactory.builder().setSecurityDomain(this.getSecurityDomain()).setFactory((HttpServerAuthenticationMechanismFactory)aggregated).build();
        return httpAuthenticationFactory.getMechanismNames().stream().map(mechanismName -> {
            try {
                return (HttpServerAuthenticationMechanism)httpAuthenticationFactory.createMechanism(mechanismName);
            }
            catch (HttpAuthenticationException e) {
                throw new RuntimeException("Failed to create mechanism.", e);
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private SecurityDomain getSecurityDomain() {
        if (this.securityDomain != null) {
            return this.securityDomain;
        }
        try {
            PasswordFactory passwordFactory = PasswordFactory.getInstance((String)"clear");
            HashMap<String, SimpleRealmEntry> passwordMap = new HashMap<String, SimpleRealmEntry>();
            passwordMap.put("administrator", new SimpleRealmEntry(Collections.singletonList(new PasswordCredential(passwordFactory.generatePassword((KeySpec)new ClearPasswordSpec("password1!".toCharArray()))))));
            SimpleMapBackedSecurityRealm simpleRealm = new SimpleMapBackedSecurityRealm();
            simpleRealm.setIdentityMap(passwordMap);
            SecurityDomain.Builder builder = SecurityDomain.builder().setPermissionMapper((principal, roles) -> PermissionVerifier.from((Permission)new LoginPermission()));
            builder.addRealm("test", (SecurityRealm)simpleRealm);
            this.securityDomain = builder.build();
            return this.securityDomain;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create SecurityDomain", e);
        }
    }

    private void runInternal(RunNotifier notifier) {
        try {
            if (first) {
                first = false;
                Xnio xnio = Xnio.getInstance((String)"nio");
                PATH_HANDLER.addPrefixPath(WILDFLY_SERVICES, (HttpHandler)SERVICES_HANDLER);
                worker = xnio.createWorker(OptionMap.create((Option)Options.WORKER_TASK_CORE_THREADS, (Object)20, (Option)Options.WORKER_IO_THREADS, (Object)10));
                this.registerPaths(SERVICES_HANDLER);
                undertow = Undertow.builder().addHttpListener(HTTPTestServer.getHostPort(), HTTPTestServer.getHostAddress()).addHttpsListener(HTTPTestServer.getSSLHostPort(), HTTPTestServer.getHostAddress(), this.createServerSslContext()).setServerOption(UndertowOptions.REQUIRE_HOST_HTTP11, (Object)true).setServerOption(UndertowOptions.NO_REQUEST_TIMEOUT, (Object)1000).setSocketOption(Options.SSL_CLIENT_AUTH_MODE, (Object)SslClientAuthMode.REQUIRED).setHandler(this.securityContextAssociationHandlerElytron()).build();
                undertow.start();
                notifier.addListener(new RunListener(){

                    public void testRunFinished(Result result) throws Exception {
                        undertow.stop();
                    }
                });
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected HttpHandler getRootHandler() {
        BlockingHandler root = new BlockingHandler((HttpHandler)PATH_HANDLER);
        root = new AuthenticationCallHandler((HttpHandler)root);
        root = new SimpleErrorPageHandler((HttpHandler)root);
        root = new CanonicalPathHandler((HttpHandler)root);
        return root;
    }

    private SSLContext createServerSslContext() {
        return HTTPTestServer.createSSLContext(HTTPTestServer.loadKeyStore(SERVER_KEY_STORE), HTTPTestServer.loadKeyStore(SERVER_TRUST_STORE));
    }

    public static SSLContext createClientSSLContext() {
        return HTTPTestServer.createSSLContext(HTTPTestServer.loadKeyStore(CLIENT_KEY_STORE), HTTPTestServer.loadKeyStore(CLIENT_TRUST_STORE));
    }

    private static SSLContext createSSLContext(KeyStore keyStore, KeyStore trustStore) {
        KeyManager[] keyManagers;
        try {
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, STORE_PASSWORD);
            keyManagers = keyManagerFactory.getKeyManagers();
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new RuntimeException("Unable to initialise KeyManager[]", e);
        }
        TrustManager[] trustManagers = null;
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(trustStore);
            trustManagers = trustManagerFactory.getTrustManagers();
        }
        catch (KeyStoreException | NoSuchAlgorithmException e) {
            throw new RuntimeException("Unable to initialise TrustManager[]", e);
        }
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(keyManagers, trustManagers, null);
            return sslContext;
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new RuntimeException("Unable to create and initialise the SSLContext", e);
        }
    }

    public static KeyStore loadKeyStore(String name) {
        InputStream stream = HTTPTestServer.class.getClassLoader().getResourceAsStream(name);
        if (stream == null) {
            throw new RuntimeException("Could not load keystore");
        }
        try {
            KeyStore loadedKeystore = KeyStore.getInstance("JKS");
            loadedKeystore.load(stream, STORE_PASSWORD);
            KeyStore keyStore = loadedKeystore;
            return keyStore;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new RuntimeException(String.format("Unable to load KeyStore %s", name), e);
        }
        finally {
            IoUtils.safeClose((Closeable)stream);
        }
    }

    protected void registerPaths(PathHandler servicesHandler) {
    }

    public static String getHostAddress() {
        return System.getProperty("server.address", "localhost");
    }

    public static int getHostPort() {
        return Integer.getInteger("server.port", 7788);
    }

    public static int getSSLHostPort() {
        return HTTPTestServer.getHostPort() + 1;
    }

    static {
        pool = new DefaultByteBufferPool(true, BUFFER_SIZE, 1000, 10, 100);
        registeredPaths = new HashSet<String>();
        registeredServices = new HashSet<String>();
        Security.addProvider((Provider)new WildFlyElytronProvider());
    }

    private static class TestAccount
    implements Account {
        private TestAccount() {
        }

        public Principal getPrincipal() {
            return () -> "administrator";
        }

        public Set<String> getRoles() {
            return Collections.emptySet();
        }
    }
}

