package org.wildfly.httpclient.common;

import java.util.Locale;
import io.undertow.client.ClientResponse;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.wildfly.httpclient.common.ContentType;
import javax.naming.AuthenticationException;
import org.jboss.logging.DelegatingBasicLogger;
import java.lang.SecurityException;
import java.io.IOException;
import java.lang.String;
import org.jboss.logging.Logger;
import java.lang.Exception;
import java.lang.RuntimeException;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.util.Arrays;
import org.wildfly.client.config.ConfigXMLParseException;


import static org.jboss.logging.Logger.Level.ERROR;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2024-10-22T18:37:43-0300")
public class HttpClientMessages_$logger extends DelegatingBasicLogger implements HttpClientMessages, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = HttpClientMessages_$logger.class.getName();
    public HttpClientMessages_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String portValueOutOfRange$str() {
        return "WFHTTP000002: Port value %s out of range";
    }
    @Override
    public final ConfigXMLParseException portValueOutOfRange(final int port) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(getLoggingLocale(), portValueOutOfRange$str(), port));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    @Override
    public final void failedToAcquireSession(final Throwable t) {
        super.log.logf(FQCN, ERROR, t, failedToAcquireSession$str());
    }
    protected String failedToAcquireSession$str() {
        return "WFHTTP000003: Failed to acquire session";
    }
    protected String invalidResponseType$str() {
        return "WFHTTP000004: Invalid response type %s";
    }
    @Override
    public final IOException invalidResponseType(final org.wildfly.httpclient.common.ContentType type) {
        final IOException result = new IOException(String.format(getLoggingLocale(), invalidResponseType$str(), type));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidResponseCode$str() {
        return "WFHTTP000005: Invalid response code %s (full response %s)";
    }
    @Override
    public final IOException invalidResponseCode(final int responseCode, final ClientResponse response) {
        final IOException result = new IOException(String.format(getLoggingLocale(), invalidResponseCode$str(), responseCode, response));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void failedToWriteException(final Exception ex) {
        super.log.logf(FQCN, ERROR, ex, failedToWriteException$str());
    }
    protected String failedToWriteException$str() {
        return "WFHTTP000006: Failed to write exception";
    }
    protected String invalidContentEncoding$str() {
        return "WFHTTP000007: Invalid content encoding %s";
    }
    @Override
    public final IOException invalidContentEncoding(final String encoding) {
        final IOException result = new IOException(String.format(getLoggingLocale(), invalidContentEncoding$str(), encoding));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String authenticationFailed0$str() {
        return "WFHTTP000008: Authentication failed";
    }
    @Override
    public final SecurityException authenticationFailed() {
        final SecurityException result = new SecurityException(String.format(getLoggingLocale(), authenticationFailed0$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unsupportedQopInDigest$str() {
        return "WFHTTP000009: Unsupported qop version in digest auth";
    }
    @Override
    public final RuntimeException unsupportedQopInDigest() {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), unsupportedQopInDigest$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void failedToParseAuthenticationInfo(final Exception e) {
        super.log.logf(FQCN, ERROR, e, failedToParseAuthenticationInfo$str());
    }
    protected String failedToParseAuthenticationInfo$str() {
        return "WFHTTP000010: Error parsing authentication-info header";
    }
    protected String streamIsClosed$str() {
        return "WFHTTP000011: Stream is closed";
    }
    @Override
    public final IOException streamIsClosed() {
        final IOException result = new IOException(String.format(getLoggingLocale(), streamIsClosed$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String blockingIoFromIOThread$str() {
        return "WFHTTP000012: Attempted to do blocking IO from the IO thread. This is prohibited as it may result in deadlocks";
    }
    @Override
    public final IllegalStateException blockingIoFromIOThread() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), blockingIoFromIOThread$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String authenticationFailed1$str() {
        return "WFHTTP000013: Authentication failed (full response %s)";
    }
    @Override
    public final AuthenticationException authenticationFailed(final ClientResponse response) {
        final AuthenticationException result = new AuthenticationException(String.format(getLoggingLocale(), authenticationFailed1$str(), response));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
