/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.common;

import io.undertow.client.ClientRequest;
import io.undertow.client.ClientResponse;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import io.undertow.util.Methods;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import javax.naming.AuthenticationException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.httpclient.common.ClientAuthUtils;
import org.wildfly.httpclient.common.HTTPTestServer;
import org.wildfly.httpclient.common.HttpTargetContext;
import org.wildfly.httpclient.common.WildflyHttpContext;
import org.wildfly.security.auth.client.AuthenticationConfiguration;

@RunWith(value=HTTPTestServer.class)
public class AuthenticationExceptionTestCase {
    @Before
    public void setUp() {
        HTTPTestServer.registerPathHandler("/", new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) {
                exchange.setStatusCode(401);
                exchange.getResponseHeaders().add(Headers.CONTENT_TYPE, "text/html");
            }
        });
    }

    @Test
    public void testAuthenticationExceptionOnAuthenticationFailure() throws URISyntaxException {
        System.clearProperty("org.wildfly.httpclient.io-exception-on-failed-auth");
        this.assertRequestException(AuthenticationException.class);
    }

    @Test
    public void testLegacyGeneralExceptionOnAuthenticationFailure() throws URISyntaxException {
        System.setProperty("org.wildfly.httpclient.io-exception-on-failed-auth", "true");
        this.assertRequestException(IOException.class);
    }

    private void assertRequestException(Class<? extends Exception> exceptionType) throws URISyntaxException {
        ClientRequest request = new ClientRequest().setMethod(Methods.GET).setPath("/");
        CompletableFuture<ClientResponse> responseFuture = this.doClientRequest(request);
        try {
            responseFuture.join();
            Assert.fail((String)"CompletionException is expected");
        }
        catch (CompletionException e) {
            Throwable cause = e.getCause();
            Assert.assertNotNull((Object)cause);
            String expectedTypeMessage = String.format("Expected %s, got %s", exceptionType.getSimpleName(), cause.getClass().getSimpleName());
            Assert.assertEquals((String)expectedTypeMessage, cause.getClass(), exceptionType);
        }
    }

    private CompletableFuture<ClientResponse> doClientRequest(ClientRequest request) throws URISyntaxException {
        ClientAuthUtils.setupBasicAuth(request, new URI(HTTPTestServer.getDefaultServerURL() + request.getPath()));
        final CompletableFuture<ClientResponse> responseFuture = new CompletableFuture<ClientResponse>();
        HttpTargetContext context = WildflyHttpContext.getCurrent().getTargetContext(new URI(HTTPTestServer.getDefaultServerURL()));
        context.sendRequest(request, null, AuthenticationConfiguration.empty(), null, new HttpTargetContext.HttpResultHandler(){

            public void handleResult(InputStream result, ClientResponse response, Closeable doneCallback) {
                responseFuture.complete(response);
            }
        }, new HttpTargetContext.HttpFailureHandler(){

            public void handleFailure(Throwable throwable) {
                responseFuture.completeExceptionally(throwable);
            }
        }, null, null, true);
        return responseFuture;
    }
}

