/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.common;

import io.undertow.server.handlers.Cookie;
import io.undertow.server.handlers.CookieImpl;
import java.net.URI;
import java.net.URISyntaxException;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.httpclient.common.HTTPTestServer;
import org.wildfly.httpclient.common.HttpTargetContext;
import org.wildfly.httpclient.common.WildflyHttpContext;
import org.wildfly.security.auth.client.AuthenticationContext;

@RunWith(value=HTTPTestServer.class)
public class AcquireAffinityTestCase {
    @Test
    public void testAcquireAffinity() throws URISyntaxException {
        HTTPTestServer.registerServicesHandler("common/v1/affinity", exchange -> exchange.setResponseCookie((Cookie)new CookieImpl("JSESSIONID", "foo")));
        AuthenticationContext cc = AuthenticationContext.captureCurrent();
        HttpTargetContext context = WildflyHttpContext.getCurrent().getTargetContext(new URI(HTTPTestServer.getDefaultServerURL()));
        context.clearSessionId();
        Assert.assertEquals((Object)"foo", (Object)context.awaitSessionId(true, null));
    }
}

