/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.ejb;

import io.undertow.client.ClientRequest;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.Methods;
import java.lang.reflect.Method;

class HttpEJBInvocationBuilder {
    private static final HttpString INVOCATION_ID = new HttpString("X-wf-invocation-id");
    private static final String INVOCATION_ACCEPT = "application/x-wf-ejb-response;version=1,application/x-wf-jbmar-exception;version=1";
    private static final String STATEFUL_CREATE_ACCEPT = "application/x-wf-jbmar-exception;version=1";
    private String appName;
    private String moduleName;
    private String distinctName;
    private String beanName;
    private String beanId;
    private String view;
    private Method method;
    private InvocationType invocationType;
    private Long invocationId;
    private int version = 1;

    HttpEJBInvocationBuilder() {
    }

    public String getAppName() {
        return this.appName;
    }

    public HttpEJBInvocationBuilder setAppName(String appName) {
        this.appName = appName;
        return this;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public HttpEJBInvocationBuilder setModuleName(String moduleName) {
        this.moduleName = moduleName;
        return this;
    }

    public String getDistinctName() {
        return this.distinctName;
    }

    public HttpEJBInvocationBuilder setDistinctName(String distinctName) {
        this.distinctName = distinctName;
        return this;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public HttpEJBInvocationBuilder setBeanName(String beanName) {
        this.beanName = beanName;
        return this;
    }

    public String getBeanId() {
        return this.beanId;
    }

    public HttpEJBInvocationBuilder setBeanId(String beanId) {
        this.beanId = beanId;
        return this;
    }

    public Method getMethod() {
        return this.method;
    }

    public HttpEJBInvocationBuilder setMethod(Method method) {
        this.method = method;
        return this;
    }

    public String getView() {
        return this.view;
    }

    public HttpEJBInvocationBuilder setView(String view) {
        this.view = view;
        return this;
    }

    public InvocationType getInvocationType() {
        return this.invocationType;
    }

    public HttpEJBInvocationBuilder setInvocationType(InvocationType invocationType) {
        this.invocationType = invocationType;
        return this;
    }

    public Long getInvocationId() {
        return this.invocationId;
    }

    public HttpEJBInvocationBuilder setInvocationId(Long invocationId) {
        this.invocationId = invocationId;
        return this;
    }

    public int getVersion() {
        return this.version;
    }

    public HttpEJBInvocationBuilder setVersion(int version) {
        this.version = version;
        return this;
    }

    private String buildPath(String mountPoint, String type, String appName, String moduleName, String distinctName, String beanName) {
        StringBuilder sb = new StringBuilder();
        this.buildBeanPath(mountPoint, type, appName, moduleName, distinctName, beanName, sb);
        return sb.toString();
    }

    private String buildPath(String mountPoint, String type, String appName, String moduleName, String distinctName, String beanName, String beanId, String view, Method method) {
        StringBuilder sb = new StringBuilder();
        this.buildBeanPath(mountPoint, type, appName, moduleName, distinctName, beanName, sb);
        sb.append("/");
        if (beanId == null) {
            sb.append("-");
        } else {
            sb.append(beanId);
        }
        sb.append("/");
        sb.append(view);
        sb.append("/");
        sb.append(method.getName());
        for (Class<?> param : method.getParameterTypes()) {
            sb.append("/");
            sb.append(param.getName());
        }
        return sb.toString();
    }

    private void buildBeanPath(String mountPoint, String type, String appName, String moduleName, String distinctName, String beanName, StringBuilder sb) {
        this.buildModulePath(mountPoint, type, appName, moduleName, distinctName, sb);
        sb.append("/");
        sb.append(beanName);
    }

    private void buildModulePath(String mountPoint, String type, String appName, String moduleName, String distinctName, StringBuilder sb) {
        if (mountPoint != null) {
            sb.append(mountPoint);
        }
        sb.append("/ejb/v");
        sb.append(this.version);
        sb.append("/");
        sb.append(type);
        sb.append("/");
        if (appName == null || appName.isEmpty()) {
            sb.append("-");
        } else {
            sb.append(appName);
        }
        sb.append("/");
        if (moduleName == null || moduleName.isEmpty()) {
            sb.append("-");
        } else {
            sb.append(moduleName);
        }
        sb.append("/");
        if (distinctName == null || distinctName.isEmpty()) {
            sb.append("-");
        } else {
            sb.append(distinctName);
        }
    }

    public ClientRequest createRequest(String mountPoint) {
        ClientRequest clientRequest = new ClientRequest();
        if (this.invocationType == InvocationType.METHOD_INVOCATION) {
            clientRequest.setMethod(Methods.POST);
            clientRequest.getRequestHeaders().add(Headers.ACCEPT, INVOCATION_ACCEPT);
            if (this.invocationId != null) {
                clientRequest.getRequestHeaders().put(INVOCATION_ID, this.invocationId.longValue());
            }
            clientRequest.setPath(this.buildPath(mountPoint, "invoke", this.appName, this.moduleName, this.distinctName, this.beanName, this.beanId, this.view, this.method));
            clientRequest.getRequestHeaders().put(Headers.CONTENT_TYPE, "application/x-wf-ejb-jbmar-invocation;version=1");
        } else if (this.invocationType == InvocationType.STATEFUL_CREATE) {
            clientRequest.setMethod(Methods.POST);
            clientRequest.getRequestHeaders().put(Headers.CONTENT_TYPE, "application/x-wf-jbmar-sess-open;version=1");
            clientRequest.setPath(this.buildPath(mountPoint, "open", this.appName, this.moduleName, this.distinctName, this.beanName));
            clientRequest.getRequestHeaders().add(Headers.ACCEPT, STATEFUL_CREATE_ACCEPT);
        }
        return clientRequest;
    }

    public static enum InvocationType {
        METHOD_INVOCATION,
        STATEFUL_CREATE,
        CANCEL;

    }
}

