/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.ejb;

import io.undertow.client.ClientRequest;
import io.undertow.util.Headers;
import io.undertow.util.Methods;
import java.io.Closeable;
import java.net.URI;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import org.jboss.ejb.client.EJBClientConnection;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.ejb.client.EJBModuleIdentifier;
import org.jboss.marshalling.ByteInput;
import org.jboss.marshalling.InputStreamByteInput;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.ObjectTable;
import org.jboss.marshalling.Unmarshaller;
import org.wildfly.discovery.AttributeValue;
import org.wildfly.discovery.FilterSpec;
import org.wildfly.discovery.ServiceType;
import org.wildfly.discovery.ServiceURL;
import org.wildfly.discovery.spi.DiscoveryProvider;
import org.wildfly.discovery.spi.DiscoveryRequest;
import org.wildfly.discovery.spi.DiscoveryResult;
import org.wildfly.httpclient.common.HttpTargetContext;
import org.wildfly.httpclient.common.WildflyHttpContext;
import org.wildfly.httpclient.ejb.EjbHeaders;
import org.wildfly.httpclient.ejb.EjbHttpClientMessages;
import org.wildfly.httpclient.ejb.HttpProtocolV1ObjectTable;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.AuthenticationContextConfigurationClient;
import org.xnio.IoUtils;

public final class HttpEJBDiscoveryProvider
implements DiscoveryProvider {
    private static final String DISCOVERY_PATH = "/ejb/v1/discover";
    private static final String DISCOVERY_ACCEPT = "application/x-wf-ejb-jbmar-discovery-response;version=1,application/x-wf-jbmar-exception;version=1";
    private static final AuthenticationContextConfigurationClient AUTH_CONFIGURATION_CLIENT = (AuthenticationContextConfigurationClient)AccessController.doPrivileged(AuthenticationContextConfigurationClient.ACTION);
    private Set<ServiceURL> serviceURLCache = new HashSet<ServiceURL>();
    private AtomicBoolean shouldRefreshCache = new AtomicBoolean(true);

    HttpEJBDiscoveryProvider() {
    }

    public DiscoveryRequest discover(ServiceType serviceType, FilterSpec filterSpec, DiscoveryResult discoveryResult) {
        EJBClientContext ejbClientContext = EJBClientContext.getCurrent();
        if (this.shouldRefreshCache.get()) {
            this.refreshCache(ejbClientContext);
        }
        this.searchCache(discoveryResult, filterSpec);
        return DiscoveryRequest.NULL;
    }

    private boolean supportsScheme(String s) {
        switch (s) {
            case "http": 
            case "https": {
                return true;
            }
        }
        return false;
    }

    private void searchCache(DiscoveryResult discoveryResult, FilterSpec filterSpec) {
        for (ServiceURL serviceURL : this.serviceURLCache) {
            if (!serviceURL.satisfies(filterSpec)) continue;
            discoveryResult.addMatch(serviceURL.getLocationURI());
        }
        discoveryResult.complete();
    }

    private void refreshCache(EJBClientContext ejbClientContext) {
        this.serviceURLCache.clear();
        List httpConnections = ejbClientContext.getConfiguredConnections().stream().filter(connection -> this.supportsScheme(connection.getDestination().getScheme())).collect(Collectors.toList());
        CountDownLatch outstandingLatch = new CountDownLatch(httpConnections.size());
        for (EJBClientConnection connection2 : httpConnections) {
            this.disoverFromConnection(connection2, outstandingLatch);
        }
        try {
            outstandingLatch.await();
            this.shouldRefreshCache.set(false);
        }
        catch (InterruptedException e) {
            EjbHttpClientMessages.MESSAGES.httpDiscoveryInterrupted(e);
        }
        this.shouldRefreshCache.set(false);
    }

    private void disoverFromConnection(EJBClientConnection connection, CountDownLatch outstandingLatch) {
        SSLContext sslContext;
        URI newUri = connection.getDestination();
        HttpTargetContext targetContext = WildflyHttpContext.getCurrent().getTargetContext(newUri);
        AuthenticationContext authenticationContext = AuthenticationContext.captureCurrent();
        AuthenticationContextConfigurationClient client = AUTH_CONFIGURATION_CLIENT;
        try {
            sslContext = client.getSSLContext(newUri, authenticationContext);
        }
        catch (GeneralSecurityException e2) {
            return;
        }
        AuthenticationConfiguration authenticationConfiguration = client.getAuthenticationConfiguration(newUri, authenticationContext, -1, "ejb", "jboss");
        ClientRequest request = new ClientRequest().setPath(targetContext.getUri().getPath() + DISCOVERY_PATH).setMethod(Methods.GET);
        request.getRequestHeaders().add(Headers.ACCEPT, DISCOVERY_ACCEPT);
        targetContext.sendRequest(request, sslContext, authenticationConfiguration, null, (result, response, closeable) -> {
            try {
                MarshallingConfiguration marshallingConfiguration = this.createMarshallingConfig();
                Unmarshaller unmarshaller = targetContext.createUnmarshaller(marshallingConfiguration);
                unmarshaller.start((ByteInput)new InputStreamByteInput(result));
                int size = unmarshaller.readInt();
                for (int i = 0; i < size; ++i) {
                    EJBModuleIdentifier ejbModuleIdentifier = (EJBModuleIdentifier)unmarshaller.readObject();
                    ServiceURL url = this.createServiceURL(newUri, ejbModuleIdentifier);
                    this.serviceURLCache.add(url);
                }
            }
            catch (Exception e) {
                EjbHttpClientMessages.MESSAGES.unableToPerformEjbDiscovery(e);
            }
            finally {
                outstandingLatch.countDown();
                IoUtils.safeClose((Closeable)closeable);
            }
        }, e -> {
            EjbHttpClientMessages.MESSAGES.unableToPerformEjbDiscovery(e);
            outstandingLatch.countDown();
        }, EjbHeaders.EJB_DISCOVERY_RESPONSE_VERSION_ONE, null);
    }

    private MarshallingConfiguration createMarshallingConfig() {
        MarshallingConfiguration marshallingConfiguration = new MarshallingConfiguration();
        marshallingConfiguration.setObjectTable((ObjectTable)HttpProtocolV1ObjectTable.INSTANCE);
        marshallingConfiguration.setVersion(2);
        return marshallingConfiguration;
    }

    private ServiceURL createServiceURL(URI newUri, EJBModuleIdentifier moduleIdentifier) {
        ServiceURL.Builder builder = new ServiceURL.Builder();
        builder.setUri(newUri);
        builder.setAbstractType(EJBClientContext.EJB_SERVICE_TYPE.getAbstractType());
        builder.setAbstractTypeAuthority(EJBClientContext.EJB_SERVICE_TYPE.getAbstractTypeAuthority());
        String appName = moduleIdentifier.getAppName();
        String moduleName = moduleIdentifier.getModuleName();
        String distinctName = moduleIdentifier.getDistinctName();
        if (distinctName.isEmpty()) {
            if (appName.isEmpty()) {
                builder.addAttribute("ejb-module", AttributeValue.fromString((String)moduleName));
            } else {
                builder.addAttribute("ejb-module", AttributeValue.fromString((String)(appName + "/" + moduleName)));
            }
        } else if (appName.isEmpty()) {
            builder.addAttribute("ejb-module-distinct", AttributeValue.fromString((String)(moduleName + "/" + distinctName)));
        } else {
            builder.addAttribute("ejb-module-distinct", AttributeValue.fromString((String)(appName + "/" + moduleName + "/" + distinctName)));
        }
        return builder.create();
    }

    public void processMissingTarget(URI location, Exception cause) {
        this.shouldRefreshCache.set(true);
    }
}

