/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.ejb;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.Cookie;
import io.undertow.server.handlers.CookieImpl;
import io.undertow.server.session.SecureRandomSessionIdGenerator;
import io.undertow.server.session.SessionIdGenerator;
import io.undertow.util.Headers;
import java.io.InputStream;
import java.net.SocketAddress;
import java.util.Base64;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import javax.ejb.NoSuchEJBException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import org.jboss.ejb.client.EJBIdentifier;
import org.jboss.ejb.client.SessionID;
import org.jboss.ejb.server.Association;
import org.jboss.ejb.server.SessionOpenRequest;
import org.jboss.marshalling.ByteInput;
import org.jboss.marshalling.InputStreamByteInput;
import org.jboss.marshalling.ObjectTable;
import org.jboss.marshalling.Unmarshaller;
import org.wildfly.common.annotation.NotNull;
import org.wildfly.httpclient.common.ContentType;
import org.wildfly.httpclient.common.ElytronIdentityHandler;
import org.wildfly.httpclient.common.HttpMarshallerFactory;
import org.wildfly.httpclient.common.HttpServerHelper;
import org.wildfly.httpclient.common.HttpServiceConfig;
import org.wildfly.httpclient.ejb.EjbConstants;
import org.wildfly.httpclient.ejb.EjbHttpClientMessages;
import org.wildfly.httpclient.ejb.HttpProtocolV1ObjectTable;
import org.wildfly.httpclient.ejb.RemoteHTTPHandler;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.transaction.client.ImportResult;
import org.wildfly.transaction.client.LocalTransactionContext;

class HttpSessionOpenHandler
extends RemoteHTTPHandler {
    private final Association association;
    private final ExecutorService executorService;
    private final SessionIdGenerator sessionIdGenerator = new SecureRandomSessionIdGenerator();
    private final LocalTransactionContext localTransactionContext;
    private final HttpServiceConfig httpServiceConfig;

    HttpSessionOpenHandler(Association association, ExecutorService executorService, LocalTransactionContext localTransactionContext, HttpServiceConfig httpServiceConfig) {
        super(executorService);
        this.association = association;
        this.executorService = executorService;
        this.localTransactionContext = localTransactionContext;
        this.httpServiceConfig = httpServiceConfig;
    }

    @Override
    protected void handleInternal(final HttpServerExchange exchange) throws Exception {
        String[] parts;
        String ct = exchange.getRequestHeaders().getFirst(Headers.CONTENT_TYPE);
        ContentType contentType = ContentType.parse((String)ct);
        if (contentType == null || contentType.getVersion() != 1 || !EjbConstants.SESSION_OPEN.getType().equals(contentType.getType())) {
            exchange.setStatusCode(400);
            EjbHttpClientMessages.MESSAGES.debugf("Bad content type %s", ct);
            return;
        }
        String relativePath = exchange.getRelativePath();
        if (relativePath.startsWith("/")) {
            relativePath = relativePath.substring(1);
        }
        if ((parts = relativePath.split("/")).length != 4) {
            exchange.setStatusCode(404);
            return;
        }
        String app = HttpSessionOpenHandler.handleDash(parts[0]);
        String module = HttpSessionOpenHandler.handleDash(parts[1]);
        String distinct = HttpSessionOpenHandler.handleDash(parts[2]);
        String bean = parts[3];
        Cookie cookie = (Cookie)exchange.getRequestCookies().get("JSESSIONID");
        String sessionAffinity = null;
        if (cookie != null) {
            sessionAffinity = cookie.getValue();
        }
        final EJBIdentifier ejbIdentifier = new EJBIdentifier(app, module, bean, distinct);
        exchange.dispatch((Executor)this.executorService, () -> {
            Transaction transaction;
            RemoteHTTPHandler.ReceivedTransaction txConfig;
            try {
                HttpMarshallerFactory httpUnmarshallerFactory = this.httpServiceConfig.getHttpUnmarshallerFactory(exchange);
                Unmarshaller unmarshaller = httpUnmarshallerFactory.createUnmarshaller((ObjectTable)HttpProtocolV1ObjectTable.INSTANCE);
                try (InputStream inputStream = exchange.getInputStream();){
                    unmarshaller.start((ByteInput)new InputStreamByteInput(inputStream));
                    txConfig = this.readTransaction(unmarshaller);
                    unmarshaller.finish();
                }
            }
            catch (Exception e) {
                HttpServerHelper.sendException((HttpServerExchange)exchange, (HttpServiceConfig)this.httpServiceConfig, (int)500, (Throwable)e);
                return;
            }
            if (txConfig == null || this.localTransactionContext == null) {
                transaction = null;
            } else {
                try {
                    ImportResult result = this.localTransactionContext.findOrImportTransaction(txConfig.getXid(), txConfig.getRemainingTime());
                    transaction = result.getTransaction();
                }
                catch (XAException e) {
                    throw new IllegalStateException(e);
                }
            }
            this.association.receiveSessionOpenRequest(new SessionOpenRequest(){

                public boolean hasTransaction() {
                    return txConfig != null;
                }

                public Transaction getTransaction() throws SystemException, IllegalStateException {
                    return transaction;
                }

                public SocketAddress getPeerAddress() {
                    return exchange.getSourceAddress();
                }

                public SocketAddress getLocalAddress() {
                    return exchange.getDestinationAddress();
                }

                public Executor getRequestExecutor() {
                    return HttpSessionOpenHandler.this.executorService != null ? HttpSessionOpenHandler.this.executorService : exchange.getIoThread().getWorker();
                }

                public String getProtocol() {
                    return exchange.getProtocol().toString();
                }

                public boolean isBlockingCaller() {
                    return false;
                }

                public EJBIdentifier getEJBIdentifier() {
                    return ejbIdentifier;
                }

                public SecurityIdentity getSecurityIdentity() {
                    return (SecurityIdentity)exchange.getAttachment(ElytronIdentityHandler.IDENTITY_KEY);
                }

                public void writeException(@NotNull Exception exception) {
                    HttpServerHelper.sendException((HttpServerExchange)exchange, (HttpServiceConfig)HttpSessionOpenHandler.this.httpServiceConfig, (int)500, (Throwable)exception);
                }

                public void writeNoSuchEJB() {
                    HttpServerHelper.sendException((HttpServerExchange)exchange, (HttpServiceConfig)HttpSessionOpenHandler.this.httpServiceConfig, (int)404, (Throwable)new NoSuchEJBException());
                }

                public void writeWrongViewType() {
                    HttpServerHelper.sendException((HttpServerExchange)exchange, (HttpServiceConfig)HttpSessionOpenHandler.this.httpServiceConfig, (int)404, (Throwable)EjbHttpClientMessages.MESSAGES.wrongViewType());
                }

                public void writeCancelResponse() {
                    throw new RuntimeException("nyi");
                }

                public void writeNotStateful() {
                    HttpServerHelper.sendException((HttpServerExchange)exchange, (HttpServiceConfig)HttpSessionOpenHandler.this.httpServiceConfig, (int)500, (Throwable)EjbHttpClientMessages.MESSAGES.notStateful());
                }

                public void convertToStateful(@NotNull SessionID sessionId) throws IllegalArgumentException, IllegalStateException {
                    Cookie sessionCookie = (Cookie)exchange.getRequestCookies().get("JSESSIONID");
                    if (sessionCookie == null) {
                        String rootPath = exchange.getResolvedPath();
                        int ejbIndex = rootPath.lastIndexOf("/ejb");
                        if (ejbIndex > 0) {
                            rootPath = rootPath.substring(0, ejbIndex);
                        }
                        exchange.getResponseCookies().put("JSESSIONID", new CookieImpl("JSESSIONID", HttpSessionOpenHandler.this.sessionIdGenerator.createSessionId()).setPath(rootPath));
                    }
                    exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, EjbConstants.EJB_RESPONSE_NEW_SESSION.toString());
                    exchange.getResponseHeaders().put(EjbConstants.EJB_SESSION_ID, Base64.getUrlEncoder().encodeToString(sessionId.getEncodedForm()));
                    exchange.setStatusCode(204);
                    exchange.endExchange();
                }

                public <C> C getProviderInterface(Class<C> providerInterfaceType) {
                    return null;
                }
            });
        });
    }

    private static String handleDash(String s) {
        if (s.equals("-")) {
            return "";
        }
        return s;
    }
}

