/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.naming;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.RoutingHandler;
import io.undertow.server.handlers.BlockingHandler;
import io.undertow.util.Headers;
import io.undertow.util.Methods;
import io.undertow.util.PathTemplateMatch;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Deque;
import java.util.function.Function;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.jboss.marshalling.ByteInput;
import org.jboss.marshalling.ByteOutput;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.ContextClassResolver;
import org.jboss.marshalling.InputStreamByteInput;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.Unmarshaller;
import org.wildfly.httpclient.common.ContentType;
import org.wildfly.httpclient.common.ElytronIdentityHandler;
import org.wildfly.httpclient.common.HttpServerHelper;
import org.wildfly.httpclient.common.MarshallingHelper;
import org.wildfly.httpclient.common.NoFlushByteOutput;
import org.wildfly.httpclient.naming.HttpNamingClientMessages;
import org.wildfly.httpclient.naming.NamingConstants;

public class HttpRemoteNamingService {
    private final Context localContext;
    private final Function<String, Boolean> classResolverFilter;

    public HttpRemoteNamingService(Context localContext) {
        this(localContext, null);
    }

    public HttpRemoteNamingService(Context localContext, Function<String, Boolean> classResolverFilter) {
        this.localContext = localContext;
        this.classResolverFilter = classResolverFilter;
    }

    public HttpHandler createHandler() {
        RoutingHandler routingHandler = new RoutingHandler();
        String nameParamPathSuffix = "/{name}";
        routingHandler.add(Methods.POST, "/v1/lookup/{name}", (HttpHandler)new LookupHandler());
        routingHandler.add(Methods.GET, "/v1/lookuplink/{name}", (HttpHandler)new LookupLinkHandler());
        routingHandler.add(Methods.PUT, "/v1/bind/{name}", (HttpHandler)new BindHandler());
        routingHandler.add(Methods.PATCH, "/v1/rebind/{name}", (HttpHandler)new RebindHandler());
        routingHandler.add(Methods.DELETE, "/v1/unbind/{name}", (HttpHandler)new UnbindHandler());
        routingHandler.add(Methods.DELETE, "/v1/dest-subctx/{name}", (HttpHandler)new DestroySubcontextHandler());
        routingHandler.add(Methods.GET, "/v1/list/{name}", (HttpHandler)new ListHandler());
        routingHandler.add(Methods.GET, "/v1/list-bindings/{name}", (HttpHandler)new ListBindingsHandler());
        routingHandler.add(Methods.PATCH, "/v1/rename/{name}", (HttpHandler)new RenameHandler());
        routingHandler.add(Methods.PUT, "/v1/create-subcontext/{name}", (HttpHandler)new CreateSubContextHandler());
        return new BlockingHandler((HttpHandler)new ElytronIdentityHandler((HttpHandler)routingHandler));
    }

    private static void doMarshall(HttpServerExchange exchange, Object result) throws IOException {
        exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, NamingConstants.VALUE.toString());
        Marshaller marshaller = MarshallingHelper.newMarshaller((MarshallingConfiguration)MarshallingHelper.newConfig());
        marshaller.start((ByteOutput)new NoFlushByteOutput(Marshalling.createByteOutput((OutputStream)exchange.getOutputStream())));
        marshaller.writeObject(result);
        marshaller.finish();
        marshaller.flush();
    }

    public static void sendException(HttpServerExchange exchange, int status, Throwable e) throws IOException {
        HttpServerHelper.sendException((HttpServerExchange)exchange, (int)status, (Throwable)e);
    }

    private static class FilterClassResolver
    extends ContextClassResolver {
        private final Function<String, Boolean> filter;

        private FilterClassResolver(Function<String, Boolean> filter) {
            this.filter = filter;
        }

        public Class<?> resolveClass(Unmarshaller unmarshaller, String name, long serialVersionUID) throws IOException, ClassNotFoundException {
            this.checkFilter(name);
            return super.resolveClass(unmarshaller, name, serialVersionUID);
        }

        public Class<?> resolveProxyClass(Unmarshaller unmarshaller, String[] interfaces) throws IOException, ClassNotFoundException {
            for (String name : interfaces) {
                this.checkFilter(name);
            }
            return super.resolveProxyClass(unmarshaller, interfaces);
        }

        private void checkFilter(String className) throws InvalidClassException {
            if (this.filter.apply(className) != Boolean.TRUE) {
                throw HttpNamingClientMessages.MESSAGES.cannotResolveFilteredClass(className);
            }
        }
    }

    private class BindHandler
    extends NameHandler {
        private BindHandler() {
        }

        @Override
        protected final Object doOperation(HttpServerExchange exchange, String name) throws NamingException {
            ContentType contentType = ContentType.parse((String)exchange.getRequestHeaders().getFirst(Headers.CONTENT_TYPE));
            if (contentType == null || !contentType.getType().equals(NamingConstants.VALUE.getType()) || contentType.getVersion() != 1) {
                exchange.setStatusCode(400);
                exchange.endExchange();
                return null;
            }
            FilterClassResolver resolver = HttpRemoteNamingService.this.classResolverFilter != null ? new FilterClassResolver(HttpRemoteNamingService.this.classResolverFilter) : null;
            MarshallingConfiguration marshallingConfiguration = MarshallingHelper.newConfig((ClassResolver)resolver);
            try (InputStream inputStream = exchange.getInputStream();){
                Unmarshaller unmarshaller = MarshallingHelper.newUnmarshaller((MarshallingConfiguration)marshallingConfiguration);
                unmarshaller.start((ByteInput)new InputStreamByteInput(inputStream));
                Object object = unmarshaller.readObject();
                unmarshaller.finish();
                this.doOperation(name, object);
            }
            catch (Exception e) {
                if (e instanceof NamingException) {
                    throw (NamingException)e;
                }
                NamingException nm = new NamingException(e.getMessage());
                nm.initCause(e);
                throw nm;
            }
            return null;
        }

        protected void doOperation(String name, Object object) throws NamingException {
            HttpRemoteNamingService.this.localContext.bind(name, object);
        }
    }

    private class RebindHandler
    extends BindHandler {
        private RebindHandler() {
        }

        @Override
        protected void doOperation(String name, Object object) throws NamingException {
            HttpRemoteNamingService.this.localContext.rebind(name, object);
        }
    }

    private class ListHandler
    extends NameHandler {
        private ListHandler() {
        }

        @Override
        protected Object doOperation(HttpServerExchange exchange, String name) throws NamingException {
            NamingEnumeration<NameClassPair> namingEnumeration = HttpRemoteNamingService.this.localContext.list(name);
            return Collections.list(namingEnumeration);
        }
    }

    private class DestroySubcontextHandler
    extends NameHandler {
        private DestroySubcontextHandler() {
        }

        @Override
        protected Object doOperation(HttpServerExchange exchange, String name) throws NamingException {
            HttpRemoteNamingService.this.localContext.destroySubcontext(name);
            return null;
        }
    }

    private class RenameHandler
    extends NameHandler {
        private RenameHandler() {
        }

        @Override
        protected Object doOperation(HttpServerExchange exchange, String name) throws NamingException {
            Deque newName = (Deque)exchange.getQueryParameters().get("new");
            if (newName == null || newName.isEmpty()) {
                exchange.setStatusCode(400);
                exchange.endExchange();
                return null;
            }
            try {
                String nn = URLDecoder.decode((String)newName.getFirst(), StandardCharsets.UTF_8.name());
                HttpRemoteNamingService.this.localContext.rename(name, nn);
                return null;
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private class ListBindingsHandler
    extends NameHandler {
        private ListBindingsHandler() {
        }

        @Override
        protected Object doOperation(HttpServerExchange exchange, String name) throws NamingException {
            NamingEnumeration<Binding> namingEnumeration = HttpRemoteNamingService.this.localContext.listBindings(name);
            return Collections.list(namingEnumeration);
        }
    }

    private class UnbindHandler
    extends NameHandler {
        private UnbindHandler() {
        }

        @Override
        protected Object doOperation(HttpServerExchange exchange, String name) throws NamingException {
            HttpRemoteNamingService.this.localContext.unbind(name);
            return null;
        }
    }

    private class CreateSubContextHandler
    extends NameHandler {
        private CreateSubContextHandler() {
        }

        @Override
        protected Object doOperation(HttpServerExchange exchange, String name) throws NamingException {
            return HttpRemoteNamingService.this.localContext.createSubcontext(name);
        }
    }

    private final class LookupLinkHandler
    extends NameHandler {
        private LookupLinkHandler() {
        }

        @Override
        protected Object doOperation(HttpServerExchange exchange, String name) throws NamingException {
            return HttpRemoteNamingService.this.localContext.lookupLink(name);
        }
    }

    private final class LookupHandler
    extends NameHandler {
        private LookupHandler() {
        }

        @Override
        protected Object doOperation(HttpServerExchange exchange, String name) throws NamingException {
            return HttpRemoteNamingService.this.localContext.lookup(name);
        }
    }

    private abstract class NameHandler
    implements HttpHandler {
        private NameHandler() {
        }

        public final void handleRequest(HttpServerExchange exchange) throws Exception {
            PathTemplateMatch params = (PathTemplateMatch)exchange.getAttachment(PathTemplateMatch.ATTACHMENT_KEY);
            String name = URLDecoder.decode((String)params.getParameters().get("name"), StandardCharsets.UTF_8.name());
            try {
                Object result = this.doOperation(exchange, name);
                if (exchange.isComplete()) {
                    return;
                }
                if (result == null) {
                    exchange.setStatusCode(200);
                } else if (result instanceof Context) {
                    exchange.setStatusCode(204);
                } else {
                    HttpRemoteNamingService.doMarshall(exchange, result);
                }
            }
            catch (Throwable e) {
                HttpRemoteNamingService.sendException(exchange, 500, e);
            }
        }

        protected abstract Object doOperation(HttpServerExchange var1, String var2) throws NamingException;
    }
}

