/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.transaction;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.RoutingHandler;
import io.undertow.util.Headers;
import io.undertow.util.Methods;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Deque;
import java.util.function.Function;
import javax.transaction.xa.Xid;
import org.jboss.marshalling.ByteBufferInput;
import org.jboss.marshalling.ByteInput;
import org.jboss.marshalling.ByteOutput;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.OutputStreamByteOutput;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.marshalling.river.RiverMarshallerFactory;
import org.wildfly.httpclient.common.ContentType;
import org.wildfly.httpclient.transaction.HttpRemoteTransactionMessages;
import org.wildfly.httpclient.transaction.TransactionConstants;
import org.wildfly.transaction.client.ContextTransactionManager;
import org.wildfly.transaction.client.ImportResult;
import org.wildfly.transaction.client.LocalTransaction;
import org.wildfly.transaction.client.LocalTransactionContext;
import org.wildfly.transaction.client.SimpleXid;

public class HttpRemoteTransactionService {
    private final LocalTransactionContext transactionContext;
    private final Function<LocalTransaction, Xid> xidResolver;
    private final ContextTransactionManager transactionManager = ContextTransactionManager.getInstance();
    private static final MarshallerFactory MARSHALLER_FACTORY = new RiverMarshallerFactory();

    public HttpRemoteTransactionService(LocalTransactionContext transactionContext, Function<LocalTransaction, Xid> xidResolver) {
        this.transactionContext = transactionContext;
        this.xidResolver = xidResolver;
    }

    public HttpHandler createHandler() {
        RoutingHandler routingHandler = new RoutingHandler();
        routingHandler.add(Methods.POST, "/v1/ut/begin", (HttpHandler)new BeginHandler());
        routingHandler.add(Methods.POST, "/v1/ut/rollback", (HttpHandler)new UTRollbackHandler());
        routingHandler.add(Methods.POST, "/v1/ut/commit", (HttpHandler)new UTCommitHandler());
        routingHandler.add(Methods.POST, "/v1/xa/bc", (HttpHandler)new XABeforeCompletionHandler());
        routingHandler.add(Methods.POST, "/v1/xa/commit", (HttpHandler)new XACommitHandler());
        routingHandler.add(Methods.POST, "/v1/xa/forget", (HttpHandler)new XAForgetHandler());
        routingHandler.add(Methods.POST, "/v1/xa/prep", (HttpHandler)new XAPrepHandler());
        routingHandler.add(Methods.POST, "/v1/xa/rollback", (HttpHandler)new XARollbackHandler());
        routingHandler.add(Methods.GET, "/v1/xa/recover", (HttpHandler)new XARecoveryHandler());
        return routingHandler;
    }

    static MarshallingConfiguration createMarshallingConf() {
        MarshallingConfiguration marshallingConfiguration = new MarshallingConfiguration();
        marshallingConfiguration.setVersion(2);
        return marshallingConfiguration;
    }

    public static void sendException(HttpServerExchange exchange, int status, Throwable e) {
        try {
            exchange.setStatusCode(status);
            exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "application/x-wf-jbmar-exception;version=1");
            MarshallingConfiguration marshallingConfiguration = new MarshallingConfiguration();
            marshallingConfiguration.setVersion(2);
            Marshaller marshaller = MARSHALLER_FACTORY.createMarshaller(marshallingConfiguration);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            ByteOutput byteOutput = Marshalling.createByteOutput((OutputStream)outputStream);
            marshaller.start(byteOutput);
            marshaller.writeObject((Object)e);
            marshaller.write(0);
            marshaller.finish();
            marshaller.flush();
            exchange.getResponseSender().send(ByteBuffer.wrap(outputStream.toByteArray()));
        }
        catch (IOException e1) {
            HttpRemoteTransactionMessages.MESSAGES.debugf(e, "Failed to write exception", new Object[0]);
        }
    }

    class XACommitHandler
    extends AbstractTransactionHandler {
        XACommitHandler() {
        }

        @Override
        protected void handleImpl(HttpServerExchange exchange, ImportResult<LocalTransaction> transaction) throws Exception {
            Deque opc = (Deque)exchange.getQueryParameters().get("opc");
            boolean onePhase = false;
            if (opc != null && !opc.isEmpty()) {
                onePhase = Boolean.parseBoolean((String)opc.poll());
            }
            transaction.getControl().commit(onePhase);
        }
    }

    class XARollbackHandler
    extends AbstractTransactionHandler {
        XARollbackHandler() {
        }

        @Override
        protected void handleImpl(HttpServerExchange exchange, ImportResult<LocalTransaction> transaction) throws Exception {
            transaction.getControl().rollback();
        }
    }

    class XAPrepHandler
    extends AbstractTransactionHandler {
        XAPrepHandler() {
        }

        @Override
        protected void handleImpl(HttpServerExchange exchange, ImportResult<LocalTransaction> transaction) throws Exception {
            transaction.getControl().prepare();
        }
    }

    class XAForgetHandler
    extends AbstractTransactionHandler {
        XAForgetHandler() {
        }

        @Override
        protected void handleImpl(HttpServerExchange exchange, ImportResult<LocalTransaction> transaction) throws Exception {
            transaction.getControl().forget();
        }
    }

    class XABeforeCompletionHandler
    extends AbstractTransactionHandler {
        XABeforeCompletionHandler() {
        }

        @Override
        protected void handleImpl(HttpServerExchange exchange, ImportResult<LocalTransaction> transaction) throws Exception {
            transaction.getControl().beforeCompletion();
        }
    }

    class UTCommitHandler
    extends AbstractTransactionHandler {
        UTCommitHandler() {
        }

        @Override
        protected void handleImpl(HttpServerExchange exchange, ImportResult<LocalTransaction> transaction) throws Exception {
            HttpRemoteTransactionService.this.transactionManager.commit();
        }
    }

    class UTRollbackHandler
    extends AbstractTransactionHandler {
        UTRollbackHandler() {
        }

        @Override
        protected void handleImpl(HttpServerExchange exchange, ImportResult<LocalTransaction> transaction) throws Exception {
            HttpRemoteTransactionService.this.transactionManager.rollback();
        }
    }

    class XARecoveryHandler
    implements HttpHandler {
        XARecoveryHandler() {
        }

        public void handleRequest(HttpServerExchange exchange) throws Exception {
            try {
                String flagsStringString = exchange.getRequestHeaders().getFirst(TransactionConstants.RECOVERY_FLAGS);
                if (flagsStringString == null) {
                    exchange.setStatusCode(400);
                    HttpRemoteTransactionMessages.MESSAGES.debugf("Exchange %s is missing %s header", exchange, TransactionConstants.RECOVERY_FLAGS);
                    return;
                }
                int flags = Integer.parseInt(flagsStringString);
                String parentName = exchange.getRequestHeaders().getFirst(TransactionConstants.RECOVERY_PARENT_NAME);
                if (parentName == null) {
                    exchange.setStatusCode(400);
                    HttpRemoteTransactionMessages.MESSAGES.debugf("Exchange %s is missing %s header", exchange, TransactionConstants.RECOVERY_PARENT_NAME);
                    return;
                }
                Xid[] recoveryList = HttpRemoteTransactionService.this.transactionContext.getRecoveryInterface().recover(flags, parentName);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                Marshaller marshaller = MARSHALLER_FACTORY.createMarshaller(HttpRemoteTransactionService.createMarshallingConf());
                marshaller.start((ByteOutput)new OutputStreamByteOutput((OutputStream)out));
                marshaller.writeInt(recoveryList.length);
                for (int i = 0; i < recoveryList.length; ++i) {
                    Xid xid = recoveryList[i];
                    marshaller.writeInt(xid.getFormatId());
                    marshaller.writeInt(xid.getGlobalTransactionId().length);
                    marshaller.write(xid.getGlobalTransactionId());
                    marshaller.writeInt(xid.getBranchQualifier().length);
                    marshaller.write(xid.getBranchQualifier());
                }
                marshaller.finish();
                exchange.getResponseSender().send(ByteBuffer.wrap(out.toByteArray()));
            }
            catch (Exception e) {
                HttpRemoteTransactionService.sendException(exchange, 500, e);
            }
        }
    }

    class BeginHandler
    implements HttpHandler {
        BeginHandler() {
        }

        public void handleRequest(HttpServerExchange exchange) throws Exception {
            try {
                String timeoutString = exchange.getRequestHeaders().getFirst(TransactionConstants.TIMEOUT);
                if (timeoutString == null) {
                    exchange.setStatusCode(400);
                    HttpRemoteTransactionMessages.MESSAGES.debugf("Exchange %s is missing %s header", exchange, TransactionConstants.TIMEOUT);
                    return;
                }
                Integer timeout = Integer.parseInt(timeoutString);
                exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, TransactionConstants.NEW_TRANSACTION.toString());
                LocalTransaction transaction = HttpRemoteTransactionService.this.transactionContext.beginTransaction(timeout.intValue());
                Xid xid = (Xid)HttpRemoteTransactionService.this.xidResolver.apply(transaction);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                Marshaller marshaller = MARSHALLER_FACTORY.createMarshaller(HttpRemoteTransactionService.createMarshallingConf());
                marshaller.start((ByteOutput)new OutputStreamByteOutput((OutputStream)out));
                marshaller.writeInt(xid.getFormatId());
                marshaller.writeInt(xid.getGlobalTransactionId().length);
                marshaller.write(xid.getGlobalTransactionId());
                marshaller.writeInt(xid.getBranchQualifier().length);
                marshaller.write(xid.getBranchQualifier());
                marshaller.finish();
                exchange.getResponseSender().send(ByteBuffer.wrap(out.toByteArray()));
            }
            catch (Exception e) {
                HttpRemoteTransactionService.sendException(exchange, 500, e);
            }
        }
    }

    abstract class AbstractTransactionHandler
    implements HttpHandler {
        AbstractTransactionHandler() {
        }

        public final void handleRequest(HttpServerExchange exchange) throws Exception {
            ContentType contentType = ContentType.parse((String)exchange.getRequestHeaders().getFirst(Headers.CONTENT_TYPE));
            if (contentType == null || contentType.getVersion() != 1 || !contentType.getType().equals("application/x-wf-jbmar-xid")) {
                exchange.setStatusCode(400);
                HttpRemoteTransactionMessages.MESSAGES.debugf("Exchange %s has incorrect or missing content type", exchange);
                return;
            }
            exchange.getRequestReceiver().receiveFullBytes((exchange1, message) -> {
                try {
                    Unmarshaller unmarshaller = MARSHALLER_FACTORY.createUnmarshaller(HttpRemoteTransactionService.createMarshallingConf());
                    unmarshaller.start((ByteInput)new ByteBufferInput(ByteBuffer.wrap(message)));
                    int formatId = unmarshaller.readInt();
                    int len = unmarshaller.readInt();
                    byte[] globalId = new byte[len];
                    unmarshaller.readFully(globalId);
                    len = unmarshaller.readInt();
                    byte[] branchId = new byte[len];
                    unmarshaller.readFully(branchId);
                    SimpleXid simpleXid = new SimpleXid(formatId, globalId, branchId);
                    unmarshaller.finish();
                    ImportResult transaction = HttpRemoteTransactionService.this.transactionContext.findOrImportTransaction((Xid)simpleXid, 0);
                    HttpRemoteTransactionService.this.transactionManager.resume(transaction.getTransaction());
                    try {
                        this.handleImpl(exchange1, (ImportResult<LocalTransaction>)transaction);
                    }
                    finally {
                        HttpRemoteTransactionService.this.transactionManager.suspend();
                    }
                }
                catch (Exception e) {
                    HttpRemoteTransactionService.sendException(exchange1, 500, e);
                }
            });
        }

        protected abstract void handleImpl(HttpServerExchange var1, ImportResult<LocalTransaction> var2) throws Exception;
    }
}

