/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.iiop.openjdk.csiv2;

import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import org.jboss.security.RunAs;
import org.jboss.security.SecurityContextAssociation;
import org.wildfly.security.manager.WildFlySecurityManager;

class SecurityActions {
    private static final PrivilegedAction<Principal> GET_PRINCIPLE_ACTION = new PrivilegedAction<Principal>(){

        @Override
        public Principal run() {
            return SecurityContextAssociation.getPrincipal();
        }
    };
    private static final PrivilegedAction<Object> GET_CREDENTIAL_ACTION = new PrivilegedAction<Object>(){

        @Override
        public Object run() {
            return SecurityContextAssociation.getCredential();
        }
    };
    private static final PrivilegedAction<RunAs> PEEK_RUN_AS_IDENTITY_ACTION = new PrivilegedAction<RunAs>(){

        @Override
        public RunAs run() {
            return SecurityContextAssociation.peekRunAsIdentity();
        }
    };

    SecurityActions() {
    }

    static Principal getPrincipal() {
        if (WildFlySecurityManager.isChecking()) {
            return AccessController.doPrivileged(GET_PRINCIPLE_ACTION);
        }
        return SecurityContextAssociation.getPrincipal();
    }

    static Object getCredential() {
        if (WildFlySecurityManager.isChecking()) {
            return AccessController.doPrivileged(GET_CREDENTIAL_ACTION);
        }
        return SecurityContextAssociation.getCredential();
    }

    static RunAs peekRunAsIdentity() {
        if (WildFlySecurityManager.isChecking()) {
            return AccessController.doPrivileged(PEEK_RUN_AS_IDENTITY_ACTION);
        }
        return SecurityContextAssociation.peekRunAsIdentity();
    }
}

