/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jaxrs;

import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.jaxrs.JaxrsAttribute;
import org.jboss.as.jaxrs.JaxrsServerConfig;
import org.jboss.as.jaxrs.JaxrsServerConfigService;
import org.jboss.as.jaxrs.deployment.JaxrsAnnotationProcessor;
import org.jboss.as.jaxrs.deployment.JaxrsCdiIntegrationProcessor;
import org.jboss.as.jaxrs.deployment.JaxrsComponentDeployer;
import org.jboss.as.jaxrs.deployment.JaxrsDependencyProcessor;
import org.jboss.as.jaxrs.deployment.JaxrsIntegrationProcessor;
import org.jboss.as.jaxrs.deployment.JaxrsMethodParameterProcessor;
import org.jboss.as.jaxrs.deployment.JaxrsScanningProcessor;
import org.jboss.as.jaxrs.deployment.JaxrsSpringProcessor;
import org.jboss.as.jaxrs.logging.JaxrsLogger;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.resteasy.spi.ResteasyDeployment;

class JaxrsSubsystemAdd
extends AbstractBoottimeAddStepHandler {
    static final JaxrsSubsystemAdd INSTANCE = new JaxrsSubsystemAdd(new AttributeDefinition[0]);

    JaxrsSubsystemAdd(AttributeDefinition ... attributes) {
        super(attributes);
    }

    protected void performBoottime(final OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        final ServiceTarget serviceTarget = context.getServiceTarget();
        JaxrsLogger.JAXRS_LOGGER.resteasyVersion(ResteasyDeployment.class.getPackage().getImplementationVersion());
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            public void execute(DeploymentProcessorTarget processorTarget) {
                processorTarget.addDeploymentProcessor("jaxrs", Phase.PARSE, 10752, (DeploymentUnitProcessor)new JaxrsAnnotationProcessor());
                processorTarget.addDeploymentProcessor("jaxrs", Phase.DEPENDENCIES, 3456, (DeploymentUnitProcessor)new JaxrsSpringProcessor(serviceTarget));
                processorTarget.addDeploymentProcessor("jaxrs", Phase.DEPENDENCIES, 3328, (DeploymentUnitProcessor)new JaxrsDependencyProcessor());
                processorTarget.addDeploymentProcessor("jaxrs", Phase.POST_MODULE, 6656, (DeploymentUnitProcessor)new JaxrsScanningProcessor());
                processorTarget.addDeploymentProcessor("jaxrs", Phase.POST_MODULE, 6912, (DeploymentUnitProcessor)new JaxrsComponentDeployer());
                CapabilityServiceSupport capabilities = context.getCapabilityServiceSupport();
                if (capabilities.hasCapability("org.wildfly.weld")) {
                    processorTarget.addDeploymentProcessor("jaxrs", Phase.POST_MODULE, 7168, (DeploymentUnitProcessor)new JaxrsCdiIntegrationProcessor());
                }
                processorTarget.addDeploymentProcessor("jaxrs", Phase.POST_MODULE, 7200, (DeploymentUnitProcessor)new JaxrsMethodParameterProcessor());
                processorTarget.addDeploymentProcessor("jaxrs", Phase.INSTALL, 5376, (DeploymentUnitProcessor)new JaxrsIntegrationProcessor());
            }
        }, OperationContext.Stage.RUNTIME);
        JaxrsServerConfig serverConfig = JaxrsSubsystemAdd.createServerConfig(operation, context);
        JaxrsServerConfigService.install(serviceTarget, serverConfig);
    }

    private static JaxrsServerConfig createServerConfig(ModelNode configuration, OperationContext context) throws OperationFailedException {
        JaxrsServerConfig config = new JaxrsServerConfig();
        if (configuration.hasDefined("jaxrs-2-0-request-matching")) {
            config.setJaxrs20RequestMatching(JaxrsAttribute.JAXRS_2_0_REQUEST_MATCHING.resolveModelAttribute(context, configuration));
        }
        if (configuration.hasDefined("resteasy-add-charset")) {
            config.setResteasyAddCharset(JaxrsAttribute.RESTEASY_ADD_CHARSET.resolveModelAttribute(context, configuration));
        }
        if (configuration.hasDefined("resteasy-buffer-exception-entity")) {
            config.setResteasyBufferExceptionEntity(JaxrsAttribute.RESTEASY_BUFFER_EXCEPTION_ENTITY.resolveModelAttribute(context, configuration));
        }
        if (configuration.hasDefined("resteasy-disable-html-sanitizer")) {
            config.setResteasyDisableHtmlSanitizer(JaxrsAttribute.RESTEASY_DISABLE_HTML_SANITIZER.resolveModelAttribute(context, configuration));
        }
        if (configuration.hasDefined("resteasy-disable-providers")) {
            config.setResteasyDisableProviders(JaxrsAttribute.RESTEASY_DISABLE_PROVIDERS.resolveModelAttribute(context, configuration));
        }
        if (configuration.hasDefined("resteasy-document-expand-entity-references")) {
            config.setResteasyDocumentExpandEntityReferences(JaxrsAttribute.RESTEASY_DOCUMENT_EXPAND_ENTITY_REFERENCES.resolveModelAttribute(context, configuration));
        }
        if (configuration.hasDefined("resteasy-document-secure-disableDTDs")) {
            config.setResteasyDocumentExpandEntityReferences(JaxrsAttribute.RESTEASY_DOCUMENT_SECURE_DISABLE_DTDS.resolveModelAttribute(context, configuration));
        }
        if (configuration.hasDefined("resteasy-document-secure-processing-feature")) {
            config.setResteasyDocumentSecureProcessingFeature(JaxrsAttribute.RESTEASY_DOCUMENT_SECURE_PROCESSING_FEATURE.resolveModelAttribute(context, configuration));
        }
        if (configuration.hasDefined("resteasy-gzip-max-input")) {
            config.setResteasyGzipMaxInput(JaxrsAttribute.RESTEASY_GZIP_MAX_INPUT.resolveModelAttribute(context, configuration));
        }
        if (configuration.hasDefined("resteasy-jndi-resources")) {
            config.setResteasyJndiResources(JaxrsAttribute.RESTEASY_JNDI_RESOURCES.resolveModelAttribute(context, configuration));
        }
        if (configuration.hasDefined("resteasy-language-mappings")) {
            config.setResteasyLanguageMappings(JaxrsAttribute.RESTEASY_LANGUAGE_MAPPINGS.resolveModelAttribute(context, configuration));
        }
        if (configuration.hasDefined("resteasy-media-type-mappings")) {
            config.setResteasyMediaTypeMappings(JaxrsAttribute.RESTEASY_MEDIA_TYPE_MAPPINGS.resolveModelAttribute(context, configuration));
        }
        if (configuration.hasDefined("resteasy-media-type-param-mapping")) {
            config.setResteasyMediaTypeParamMapping(JaxrsAttribute.RESTEASY_MEDIA_TYPE_PARAM_MAPPING.resolveModelAttribute(context, configuration));
        }
        if (configuration.hasDefined("resteasy-prefer-jackson-over-jsonb")) {
            config.setResteasyPreferJacksonOverJsonB(JaxrsAttribute.RESTEASY_PREFER_JACKSON_OVER_JSONB.resolveModelAttribute(context, configuration));
        }
        if (configuration.hasDefined("resteasy-providers")) {
            config.setResteasyProviders(JaxrsAttribute.RESTEASY_PROVIDERS.resolveModelAttribute(context, configuration));
        }
        if (configuration.hasDefined("resteasy-rfc7232preconditions")) {
            config.setResteasyRFC7232Preconditions(JaxrsAttribute.RESTEASY_RFC7232_PRECONDITIONS.resolveModelAttribute(context, configuration));
        }
        if (configuration.hasDefined("resteasy-role-based-security")) {
            config.setResteasyRoleBasedSecurity(JaxrsAttribute.RESTEASY_ROLE_BASED_SECURITY.resolveModelAttribute(context, configuration));
        }
        if (configuration.hasDefined("resteasy-secure-random-max-use")) {
            config.setResteasySecureDisableDTDs(JaxrsAttribute.RESTEASY_SECURE_RANDOM_MAX_USE.resolveModelAttribute(context, configuration));
        }
        if (configuration.hasDefined("resteasy-use-builtin-providers")) {
            config.setResteasyUseBuiltinProviders(JaxrsAttribute.RESTEASY_USE_BUILTIN_PROVIDERS.resolveModelAttribute(context, configuration));
        }
        if (configuration.hasDefined("resteasy-use-container-form-params")) {
            config.setResteasyUseContainerFormParams(JaxrsAttribute.RESTEASY_USE_CONTAINER_FORM_PARAMS.resolveModelAttribute(context, configuration));
        }
        if (configuration.hasDefined("resteasy-wider-request-matching")) {
            config.setResteasyWiderRequestMatching(JaxrsAttribute.RESTEASY_WIDER_REQUEST_MATCHING.resolveModelAttribute(context, configuration));
        }
        return config;
    }
}

