/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jaxrs;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.transform.ExtensionTransformerRegistration;
import org.jboss.as.controller.transform.SubsystemTransformerRegistration;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.ChainedTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.DiscardAttributeChecker;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.TransformationDescriptionBuilder;
import org.jboss.as.jaxrs.JaxrsAttribute;
import org.wildfly.security.manager.WildFlySecurityManager;

public class JaxrsTransformers
implements ExtensionTransformerRegistration {
    private static final String BYPASS_TRANSFORMER = "org.wildfly.jaxrs.unsupported.bypass.2.0.0.transformer";
    private static final ModelVersion MODEL_VERSION_1_0_0 = ModelVersion.create((int)1, (int)0, (int)0);
    private final ModelVersion MODEL_VERSION_2_0_0 = ModelVersion.create((int)2, (int)0, (int)0);

    public String getSubsystemName() {
        return "jaxrs";
    }

    public void registerTransformers(SubsystemTransformerRegistration subsystemRegistration) {
        ModelVersion[] modelVersions;
        ModelVersion target;
        if (JaxrsTransformers.isByPassTransformers()) {
            target = MODEL_VERSION_1_0_0;
            modelVersions = new ModelVersion[]{MODEL_VERSION_1_0_0};
        } else {
            target = this.MODEL_VERSION_2_0_0;
            modelVersions = new ModelVersion[]{this.MODEL_VERSION_2_0_0, MODEL_VERSION_1_0_0};
        }
        ChainedTransformationDescriptionBuilder chainedBuilder = TransformationDescriptionBuilder.Factory.createChainedSubystemInstance((ModelVersion)subsystemRegistration.getCurrentSubsystemVersion());
        ResourceTransformationDescriptionBuilder builder300 = chainedBuilder.createBuilder(subsystemRegistration.getCurrentSubsystemVersion(), target);
        JaxrsTransformers.registerTransformers_3_0_0(builder300);
        chainedBuilder.buildAndRegister(subsystemRegistration, (ModelVersion[][])new ModelVersion[][]{modelVersions});
    }

    private static void registerTransformers_3_0_0(ResourceTransformationDescriptionBuilder builder) {
        AttributeTransformationDescriptionBuilder attributeBuilder = builder.getAttributeBuilder();
        JaxrsTransformers.checkAttribute(attributeBuilder, (AttributeDefinition)JaxrsAttribute.JAXRS_2_0_REQUEST_MATCHING);
        JaxrsTransformers.checkAttribute(attributeBuilder, (AttributeDefinition)JaxrsAttribute.RESTEASY_ADD_CHARSET);
        JaxrsTransformers.checkAttribute(attributeBuilder, (AttributeDefinition)JaxrsAttribute.RESTEASY_BUFFER_EXCEPTION_ENTITY);
        JaxrsTransformers.checkAttribute(attributeBuilder, (AttributeDefinition)JaxrsAttribute.RESTEASY_DISABLE_HTML_SANITIZER);
        JaxrsTransformers.checkAttribute(attributeBuilder, (AttributeDefinition)JaxrsAttribute.RESTEASY_DISABLE_PROVIDERS);
        JaxrsTransformers.checkAttribute(attributeBuilder, (AttributeDefinition)JaxrsAttribute.RESTEASY_DOCUMENT_EXPAND_ENTITY_REFERENCES);
        JaxrsTransformers.checkAttribute(attributeBuilder, (AttributeDefinition)JaxrsAttribute.RESTEASY_DOCUMENT_SECURE_DISABLE_DTDS);
        JaxrsTransformers.checkAttribute(attributeBuilder, (AttributeDefinition)JaxrsAttribute.RESTEASY_DOCUMENT_SECURE_PROCESSING_FEATURE);
        JaxrsTransformers.checkAttribute(attributeBuilder, (AttributeDefinition)JaxrsAttribute.RESTEASY_GZIP_MAX_INPUT);
        JaxrsTransformers.checkAttribute(attributeBuilder, (AttributeDefinition)JaxrsAttribute.RESTEASY_JNDI_RESOURCES);
        JaxrsTransformers.checkAttribute(attributeBuilder, (AttributeDefinition)JaxrsAttribute.RESTEASY_LANGUAGE_MAPPINGS);
        JaxrsTransformers.checkAttribute(attributeBuilder, (AttributeDefinition)JaxrsAttribute.RESTEASY_MEDIA_TYPE_MAPPINGS);
        JaxrsTransformers.checkAttribute(attributeBuilder, (AttributeDefinition)JaxrsAttribute.RESTEASY_MEDIA_TYPE_PARAM_MAPPING);
        JaxrsTransformers.checkAttribute(attributeBuilder, (AttributeDefinition)JaxrsAttribute.RESTEASY_PREFER_JACKSON_OVER_JSONB);
        JaxrsTransformers.checkAttribute(attributeBuilder, (AttributeDefinition)JaxrsAttribute.RESTEASY_PROVIDERS);
        JaxrsTransformers.checkAttribute(attributeBuilder, (AttributeDefinition)JaxrsAttribute.RESTEASY_RFC7232_PRECONDITIONS);
        JaxrsTransformers.checkAttribute(attributeBuilder, (AttributeDefinition)JaxrsAttribute.RESTEASY_ROLE_BASED_SECURITY);
        JaxrsTransformers.checkAttribute(attributeBuilder, (AttributeDefinition)JaxrsAttribute.RESTEASY_SECURE_RANDOM_MAX_USE);
        JaxrsTransformers.checkAttribute(attributeBuilder, (AttributeDefinition)JaxrsAttribute.RESTEASY_USE_BUILTIN_PROVIDERS);
        JaxrsTransformers.checkAttribute(attributeBuilder, (AttributeDefinition)JaxrsAttribute.RESTEASY_USE_CONTAINER_FORM_PARAMS);
        JaxrsTransformers.checkAttribute(attributeBuilder, (AttributeDefinition)JaxrsAttribute.RESTEASY_WIDER_REQUEST_MATCHING);
        attributeBuilder.end();
    }

    private static void checkAttribute(AttributeTransformationDescriptionBuilder builder, AttributeDefinition attribute) {
        ((AttributeTransformationDescriptionBuilder)builder.setDiscard(DiscardAttributeChecker.DEFAULT_VALUE, new AttributeDefinition[]{attribute})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{attribute});
    }

    private static boolean isByPassTransformers() {
        String value = WildFlySecurityManager.getPropertyPrivileged((String)BYPASS_TRANSFORMER, null);
        if (value == null) {
            return false;
        }
        return value.isEmpty() || Boolean.parseBoolean(value);
    }
}

