/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.jberet;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.wildfly.jberet._private.WildFlyBatchMessages;

public class BatchConfiguration {
    public static final String JOB_REPOSITORY_TYPE = "job-repository-type";
    public static final String JNDI_NAME = "datasource-jndi";
    private static final BatchConfiguration INSTANCE = new BatchConfiguration();
    private final ConcurrentMap<String, String> properties = new ConcurrentHashMap<String, String>();

    private BatchConfiguration() {
    }

    public static BatchConfiguration getInstance() {
        return INSTANCE;
    }

    public Properties createProperties() {
        Properties result = new Properties();
        result.putAll((Map<?, ?>)this.properties);
        return result;
    }

    public boolean requiresJndiName() {
        return JobRepositoryType.JDBC.toString().equals(this.properties.get(JOB_REPOSITORY_TYPE)) && !this.properties.containsKey(JNDI_NAME);
    }

    public String put(String key, String value) {
        return this.properties.put(key, value);
    }

    public void setJobRepositoryType(String jobRepositoryType) {
        if (!JobRepositoryType.MAP.containsKey(jobRepositoryType)) {
            throw WildFlyBatchMessages.MESSAGES.invalidJobRepositoryType(jobRepositoryType);
        }
        this.put(JOB_REPOSITORY_TYPE, jobRepositoryType);
    }

    public void setJndiName(String jndiName) {
        this.put(JNDI_NAME, jndiName);
    }

    public static enum JobRepositoryType {
        JDBC{

            public String toString() {
                return "jdbc";
            }
        }
        ,
        IN_MEMORY{

            public String toString() {
                return "in-memory";
            }
        };

        private static final Map<String, JobRepositoryType> MAP;

        public static JobRepositoryType of(String value) {
            if (MAP.containsKey(value)) {
                return MAP.get(value);
            }
            throw WildFlyBatchMessages.MESSAGES.invalidJobRepositoryType(value);
        }

        static {
            MAP = new HashMap<String, JobRepositoryType>();
            MAP.put(JDBC.toString(), JDBC);
            MAP.put(IN_MEMORY.toString(), IN_MEMORY);
        }
    }
}

