/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.jberet;

import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.Set;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.jberet.creation.AbstractArtifactFactory;
import org.wildfly.jberet._private.WildFlyBatchLogger;

public final class WildFlyArtifactFactory
extends AbstractArtifactFactory {
    private final BeanManager beanManager;

    public WildFlyArtifactFactory(BeanManager beanManager) {
        this.beanManager = beanManager;
    }

    public Class<?> getArtifactClass(String ref, ClassLoader classLoader) {
        Bean<?> bean = this.getBean(ref);
        return bean == null ? null : bean.getBeanClass();
    }

    public Object create(String ref, Class<?> cls, ClassLoader classLoader) throws Exception {
        Bean<?> bean = this.getBean(ref);
        return bean == null ? null : this.beanManager.getReference(bean, (Type)bean.getBeanClass(), this.beanManager.createCreationalContext(bean));
    }

    private Bean<?> getBean(String ref) {
        if (this.beanManager == null) {
            return null;
        }
        WildFlyBatchLogger.LOGGER.tracef("Looking up bean reference for '%s'", ref);
        Set beans = this.beanManager.getBeans(ref);
        Iterator iter = beans.iterator();
        if (iter.hasNext()) {
            Bean bean = (Bean)iter.next();
            WildFlyBatchLogger.LOGGER.tracef("Found bean '%s' for reference '%s'", bean, ref);
            return bean;
        }
        WildFlyBatchLogger.LOGGER.tracef("No bean found for reference '%s;'", ref);
        return null;
    }
}

