/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jmx;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.RestartParentResourceAddHandler;
import org.jboss.as.controller.RestartParentResourceRemoveHandler;
import org.jboss.as.controller.RestartParentWriteAttributeHandler;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.jmx.AuditLoggerInfo;
import org.jboss.as.jmx.ExposeModelResourceExpression;
import org.jboss.as.jmx.ExposeModelResourceResolved;
import org.jboss.as.jmx.JMXExtension;
import org.jboss.as.jmx.JMXSubsystemAdd;
import org.jboss.as.jmx.JmxMessages;
import org.jboss.as.jmx.MBeanServerService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;

abstract class ExposeModelResource
extends SimpleResourceDefinition {
    private final AuditLoggerInfo auditLoggerInfo;
    private final SimpleAttributeDefinition domainName;

    ExposeModelResource(PathElement pathElement, AuditLoggerInfo auditLoggerInfo, SimpleAttributeDefinition domainName, SimpleAttributeDefinition ... otherAttributes) {
        super(pathElement, JMXExtension.getResourceDescriptionResolver("expose-model." + pathElement.getValue()), (OperationStepHandler)new ShowModelAdd(auditLoggerInfo, domainName, otherAttributes), (OperationStepHandler)new ShowModelRemove(auditLoggerInfo));
        this.auditLoggerInfo = auditLoggerInfo;
        this.domainName = domainName;
    }

    static SimpleAttributeDefinition getDomainNameAttribute(String childName) {
        if ("resolved".equals(childName)) {
            return ExposeModelResourceResolved.DOMAIN_NAME;
        }
        if ("expression".equals(childName)) {
            return ExposeModelResourceExpression.DOMAIN_NAME;
        }
        throw JmxMessages.MESSAGES.unknownChild(childName);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)this.domainName, null, (OperationStepHandler)new JMXWriteAttributeHandler((AttributeDefinition)this.domainName));
    }

    private static class ShowModelRemove
    extends RestartParentResourceRemoveHandler {
        private final AuditLoggerInfo auditLoggerInfo;

        private ShowModelRemove(AuditLoggerInfo auditLoggerInfo) {
            super("subsystem");
            this.auditLoggerInfo = auditLoggerInfo;
        }

        protected void recreateParentService(OperationContext context, PathAddress parentAddress, ModelNode parentModel, ServiceVerificationHandler verificationHandler) throws OperationFailedException {
            JMXSubsystemAdd.launchServices(context, parentModel, verificationHandler, this.auditLoggerInfo, null);
        }

        protected ServiceName getParentServiceName(PathAddress parentAddress) {
            return MBeanServerService.SERVICE_NAME;
        }
    }

    private static class ShowModelAdd
    extends RestartParentResourceAddHandler {
        private final AuditLoggerInfo auditLoggerInfo;
        private final SimpleAttributeDefinition domainName;
        private final SimpleAttributeDefinition[] otherAttributes;

        private ShowModelAdd(AuditLoggerInfo auditLoggerInfo, SimpleAttributeDefinition domainName, SimpleAttributeDefinition ... otherAttributes) {
            super("subsystem");
            this.auditLoggerInfo = auditLoggerInfo;
            this.domainName = domainName;
            this.otherAttributes = otherAttributes;
        }

        protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
            this.domainName.validateAndSet(operation, model);
            if (this.otherAttributes.length > 0) {
                for (SimpleAttributeDefinition attr : this.otherAttributes) {
                    attr.validateAndSet(operation, model);
                }
            }
        }

        protected void recreateParentService(OperationContext context, PathAddress parentAddress, ModelNode parentModel, ServiceVerificationHandler verificationHandler) throws OperationFailedException {
            JMXSubsystemAdd.launchServices(context, parentModel, verificationHandler, this.auditLoggerInfo, null);
        }

        protected ServiceName getParentServiceName(PathAddress parentAddress) {
            return MBeanServerService.SERVICE_NAME;
        }
    }

    class JMXWriteAttributeHandler
    extends RestartParentWriteAttributeHandler {
        JMXWriteAttributeHandler(AttributeDefinition attr) {
            super("subsystem", new AttributeDefinition[]{attr});
        }

        protected void recreateParentService(OperationContext context, PathAddress parentAddress, ModelNode parentModel, ServiceVerificationHandler verificationHandler) throws OperationFailedException {
            JMXSubsystemAdd.launchServices(context, parentModel, verificationHandler, ExposeModelResource.this.auditLoggerInfo, null);
        }

        protected ServiceName getParentServiceName(PathAddress parentAddress) {
            return MBeanServerService.SERVICE_NAME;
        }
    }
}

