/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.processor.secondLevelCache;

import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Properties;
import java.util.UUID;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.jboss.as.clustering.msc.ServiceContainerHelper;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.jpa.messages.JpaLogger;
import org.jboss.as.jpa.processor.secondLevelCache.CacheDeploymentListener;
import org.jboss.as.server.CurrentServiceContainer;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jipijapa.cache.spi.Classification;
import org.jipijapa.cache.spi.Wrapper;
import org.jipijapa.event.spi.EventListener;
import org.jipijapa.plugin.spi.PersistenceUnitMetadata;
import org.wildfly.clustering.infinispan.spi.InfinispanCacheRequirement;
import org.wildfly.clustering.infinispan.spi.InfinispanRequirement;
import org.wildfly.clustering.service.AliasServiceBuilder;

public class InfinispanCacheDeploymentListener
implements EventListener {
    public static final String CACHE_TYPE = "cachetype";
    public static final String CACHE_PRIVATE = "private";
    public static final String CONTAINER = "container";
    public static final String NAME = "name";
    public static final String CACHES = "caches";
    public static final String DEFAULT_CACHE_CONTAINER = "hibernate";

    public void beforeEntityManagerFactoryCreate(Classification classification, PersistenceUnitMetadata persistenceUnitMetadata) {
    }

    public void afterEntityManagerFactoryCreate(Classification classification, PersistenceUnitMetadata persistenceUnitMetadata) {
    }

    public Wrapper startCache(Classification classification, Properties properties) throws Exception {
        EmbeddedCacheManager embeddedCacheManager;
        String cache_type = properties.getProperty(CACHE_TYPE);
        String container = properties.getProperty(CONTAINER);
        ServiceName containerServiceName = ServiceName.parse((String)InfinispanRequirement.CONTAINER.resolve(container));
        LinkedList<ServiceName> serviceNames = new LinkedList<ServiceName>();
        if (CACHE_PRIVATE.equals(cache_type)) {
            String name = properties.getProperty(NAME, UUID.randomUUID().toString());
            ServiceName serviceName = ServiceName.JBOSS.append(new String[]{DEFAULT_CACHE_CONTAINER, name});
            serviceNames.add(serviceName);
            ServiceContainer target = InfinispanCacheDeploymentListener.currentServiceContainer();
            String[] caches = properties.getProperty(CACHES).split("\\s+");
            ArrayList<ServiceController> controllers = new ArrayList<ServiceController>(caches.length);
            for (String cache : caches) {
                ServiceName aliasServiceName = serviceName.append(new String[]{cache});
                ServiceName configServiceName = ServiceName.parse((String)InfinispanCacheRequirement.CONFIGURATION.resolve(container, cache));
                controllers.add(new AliasServiceBuilder(aliasServiceName, configServiceName, Configuration.class).build((ServiceTarget)target).setInitialMode(ServiceController.Mode.ACTIVE).install());
            }
            embeddedCacheManager = (EmbeddedCacheManager)new AliasServiceBuilder(serviceName, containerServiceName, EmbeddedCacheManager.class).build((ServiceTarget)target).setInitialMode(ServiceController.Mode.ACTIVE).install().awaitValue();
            for (ServiceController controller : controllers) {
                serviceNames.add(controller.getName());
                controller.awaitValue();
            }
        } else {
            ServiceContainer registry = InfinispanCacheDeploymentListener.currentServiceContainer();
            embeddedCacheManager = (EmbeddedCacheManager)registry.getRequiredService(containerServiceName).getValue();
        }
        return new CacheWrapper(embeddedCacheManager, serviceNames);
    }

    public void addCacheDependencies(Classification classification, Properties properties) {
        ServiceBuilder<?> builder = CacheDeploymentListener.getInternalDeploymentServiceBuilder();
        CapabilityServiceSupport support = CacheDeploymentListener.getInternalDeploymentCapablityServiceSupport();
        String container = properties.getProperty(CONTAINER);
        for (String cache : properties.getProperty(CACHES).split("\\s+")) {
            builder.addDependency(InfinispanCacheRequirement.CONFIGURATION.getServiceName(support, container, cache));
        }
    }

    public void stopCache(Classification classification, Wrapper wrapper) {
        CacheWrapper cacheWrapper = (CacheWrapper)wrapper;
        ServiceContainer registry = InfinispanCacheDeploymentListener.currentServiceContainer();
        for (ServiceName serviceName : cacheWrapper.getServiceNames()) {
            ServiceController service;
            if (JpaLogger.ROOT_LOGGER.isTraceEnabled()) {
                JpaLogger.ROOT_LOGGER.tracef("stop second level cache by removing dependency on service '%s'", serviceName.getCanonicalName());
            }
            if ((service = registry.getService(serviceName)) == null) continue;
            ServiceContainerHelper.remove((ServiceController)service);
        }
    }

    private static ServiceContainer currentServiceContainer() {
        if (System.getSecurityManager() == null) {
            return CurrentServiceContainer.getServiceContainer();
        }
        return (ServiceContainer)AccessController.doPrivileged(CurrentServiceContainer.GET_ACTION);
    }

    private static class CacheWrapper
    implements Wrapper {
        private final EmbeddedCacheManager embeddedCacheManager;
        private final Collection<ServiceName> serviceNames;

        CacheWrapper(EmbeddedCacheManager embeddedCacheManager, Collection<ServiceName> serviceNames) {
            this.embeddedCacheManager = embeddedCacheManager;
            this.serviceNames = serviceNames;
        }

        public Object getValue() {
            return this.embeddedCacheManager;
        }

        Collection<ServiceName> getServiceNames() {
            return this.serviceNames;
        }
    }
}

