/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.processor.secondlevelcache;

import java.security.AccessController;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.function.Supplier;
import org.infinispan.manager.EmbeddedCacheManager;
import org.jboss.as.controller.ServiceNameFactory;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.jpa.messages.JpaLogger;
import org.jboss.as.jpa.processor.secondlevelcache.CacheDeploymentListener;
import org.jboss.as.server.CurrentServiceContainer;
import org.jboss.msc.service.LifecycleEvent;
import org.jboss.msc.service.LifecycleListener;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jipijapa.cache.spi.Classification;
import org.jipijapa.cache.spi.Wrapper;
import org.jipijapa.event.spi.EventListener;
import org.jipijapa.plugin.spi.PersistenceUnitMetadata;
import org.wildfly.clustering.infinispan.service.InfinispanServiceDescriptor;
import org.wildfly.service.descriptor.BinaryServiceDescriptor;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;

public class InfinispanCacheDeploymentListener
implements EventListener {
    public static final String CACHE_TYPE = "cachetype";
    public static final String CACHE_PRIVATE = "private";
    public static final String CONTAINER = "container";
    public static final String NAME = "name";
    public static final String CACHES = "caches";
    public static final String PENDING_PUTS = "pending-puts";
    public static final String DEFAULT_CACHE_CONTAINER = "hibernate";

    public void beforeEntityManagerFactoryCreate(Classification classification, PersistenceUnitMetadata persistenceUnitMetadata) {
    }

    public void afterEntityManagerFactoryCreate(Classification classification, PersistenceUnitMetadata persistenceUnitMetadata) {
    }

    public Wrapper startCache(Classification classification, Properties properties) throws Exception {
        ServiceContainer target = InfinispanCacheDeploymentListener.currentServiceContainer();
        String container = properties.getProperty(CONTAINER);
        String cacheType = properties.getProperty(CACHE_TYPE);
        ServiceName containerServiceName = ServiceNameFactory.resolveServiceName((UnaryServiceDescriptor)InfinispanServiceDescriptor.CACHE_CONTAINER, (String)container);
        String name = properties.getProperty(NAME, UUID.randomUUID().toString());
        ServiceBuilder builder = target.addService(ServiceName.JBOSS.append(new String[]{DEFAULT_CACHE_CONTAINER, name}));
        Supplier manager = builder.requires(containerServiceName);
        if (CACHE_PRIVATE.equals(cacheType)) {
            String[] caches;
            for (String cache : caches = properties.getProperty(CACHES).split("\\s+")) {
                builder.requires(ServiceNameFactory.resolveServiceName((BinaryServiceDescriptor)InfinispanServiceDescriptor.CACHE_CONFIGURATION, (String)container, (String)cache));
            }
        }
        final CountDownLatch latch = new CountDownLatch(1);
        builder.addListener(new LifecycleListener(){

            public void handleEvent(ServiceController<?> controller, LifecycleEvent event) {
                if (event == LifecycleEvent.UP) {
                    latch.countDown();
                    controller.removeListener((LifecycleListener)this);
                }
            }
        });
        ServiceController controller = builder.install();
        latch.await();
        return new CacheWrapper((EmbeddedCacheManager)manager.get(), controller);
    }

    public void addCacheDependencies(Classification classification, Properties properties) {
        ServiceBuilder<?> builder = CacheDeploymentListener.getInternalDeploymentServiceBuilder();
        CapabilityServiceSupport support = CacheDeploymentListener.getInternalDeploymentCapablityServiceSupport();
        String container = properties.getProperty(CONTAINER);
        for (String cache : properties.getProperty(CACHES).split("\\s+")) {
            if (cache.equals(PENDING_PUTS) && !support.hasCapability(InfinispanServiceDescriptor.CACHE_CONFIGURATION, container, cache)) continue;
            builder.requires(support.getCapabilityServiceName(InfinispanServiceDescriptor.CACHE_CONFIGURATION, container, cache));
        }
    }

    public void stopCache(Classification classification, Wrapper wrapper) {
        ((CacheWrapper)wrapper).close();
    }

    private static ServiceContainer currentServiceContainer() {
        if (System.getSecurityManager() == null) {
            return CurrentServiceContainer.getServiceContainer();
        }
        return (ServiceContainer)AccessController.doPrivileged(CurrentServiceContainer.GET_ACTION);
    }

    private static class CacheWrapper
    implements Wrapper,
    AutoCloseable {
        private final EmbeddedCacheManager embeddedCacheManager;
        private final ServiceController<?> controller;

        CacheWrapper(EmbeddedCacheManager embeddedCacheManager, ServiceController<?> controller) {
            this.embeddedCacheManager = embeddedCacheManager;
            this.controller = controller;
        }

        public Object getValue() {
            return this.embeddedCacheManager;
        }

        @Override
        public void close() {
            if (JpaLogger.ROOT_LOGGER.isTraceEnabled()) {
                JpaLogger.ROOT_LOGGER.tracef("stop second level cache by removing dependency on service '%s'", this.controller.getName().getCanonicalName());
            }
            final CountDownLatch latch = new CountDownLatch(1);
            this.controller.addListener(new LifecycleListener(){

                public void handleEvent(ServiceController<?> controller, LifecycleEvent event) {
                    if (event == LifecycleEvent.REMOVED) {
                        latch.countDown();
                    }
                }
            });
            this.controller.setMode(ServiceController.Mode.REMOVE);
            try {
                latch.await();
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

