/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.transaction;

import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import org.jboss.as.jpa.JpaLogger;
import org.jboss.as.jpa.JpaMessages;
import org.jboss.as.jpa.container.EntityManagerUtil;
import org.jboss.as.jpa.container.ExtendedEntityManager;
import org.jboss.tm.TxUtils;

public class TransactionUtil {
    private static volatile TransactionSynchronizationRegistry transactionSynchronizationRegistry;
    private static volatile TransactionManager transactionManager;
    private static final String ARJUNA_REAPER_THREAD_NAME = "Transaction Reaper Worker";

    public static void setTransactionManager(TransactionManager tm) {
        if (transactionManager == null) {
            transactionManager = tm;
        }
    }

    public static TransactionManager getTransactionManager() {
        return transactionManager;
    }

    public static void setTransactionSynchronizationRegistry(TransactionSynchronizationRegistry transactionSynchronizationRegistry) {
        if (TransactionUtil.transactionSynchronizationRegistry == null) {
            TransactionUtil.transactionSynchronizationRegistry = transactionSynchronizationRegistry;
        }
    }

    public static boolean isInTx() {
        Transaction tx = TransactionUtil.getTransaction();
        return tx != null && TxUtils.isActive((Transaction)tx);
    }

    public static void registerExtendedUnderlyingWithTransaction(String scopedPuName, EntityManager xpc, EntityManager underlyingEntityManager) {
        TransactionUtil.registerSynchronization(xpc, scopedPuName, false);
        underlyingEntityManager.joinTransaction();
        TransactionUtil.putEntityManagerInTransactionRegistry(scopedPuName, xpc);
    }

    public static EntityManager getTransactionScopedEntityManager(String puScopedName) {
        return TransactionUtil.getEntityManagerInTransactionRegistry(puScopedName);
    }

    public static EntityManager getOrCreateTransactionScopedEntityManager(EntityManagerFactory emf, String scopedPuName, Map properties) {
        EntityManager entityManager = TransactionUtil.getEntityManagerInTransactionRegistry(scopedPuName);
        if (entityManager == null) {
            entityManager = EntityManagerUtil.createEntityManager(emf, properties);
            if (JpaLogger.JPA_LOGGER.isDebugEnabled()) {
                JpaLogger.JPA_LOGGER.debugf("%s: created entity manager session %s", (Object)TransactionUtil.getEntityManagerDetails(entityManager), (Object)TransactionUtil.getTransaction().toString());
            }
            boolean autoCloseEntityManager = true;
            TransactionUtil.registerSynchronization(entityManager, scopedPuName, autoCloseEntityManager);
            TransactionUtil.putEntityManagerInTransactionRegistry(scopedPuName, entityManager);
        } else if (JpaLogger.JPA_LOGGER.isDebugEnabled()) {
            JpaLogger.JPA_LOGGER.debugf("%s: reuse entity manager session already in tx %s", (Object)TransactionUtil.getEntityManagerDetails(entityManager), (Object)TransactionUtil.getTransaction().toString());
        }
        return entityManager;
    }

    private static void registerSynchronization(EntityManager entityManager, String puScopedName, boolean closeEMAtTxEnd) {
        TransactionUtil.getTransactionSynchronizationRegistry().registerInterposedSynchronization((Synchronization)new SessionSynchronization(entityManager, closeEMAtTxEnd, puScopedName));
    }

    private static Transaction getTransaction() {
        try {
            return transactionManager.getTransaction();
        }
        catch (SystemException e) {
            throw JpaMessages.MESSAGES.errorGettingTransaction((Exception)((Object)e));
        }
    }

    public static TransactionSynchronizationRegistry getTransactionSynchronizationRegistry() {
        return transactionSynchronizationRegistry;
    }

    private static String currentThread() {
        return Thread.currentThread().getName();
    }

    private static String getEntityManagerDetails(EntityManager manager) {
        String result = TransactionUtil.currentThread() + ":";
        result = manager instanceof ExtendedEntityManager ? result + manager.toString() : result + "[transaction scoped EntityManager]";
        return result;
    }

    private static EntityManager getEntityManagerInTransactionRegistry(String scopedPuName) {
        return (EntityManager)TransactionUtil.getTransactionSynchronizationRegistry().getResource((Object)scopedPuName);
    }

    private static void putEntityManagerInTransactionRegistry(String scopedPuName, EntityManager entityManager) {
        TransactionUtil.getTransactionSynchronizationRegistry().putResource((Object)scopedPuName, (Object)entityManager);
    }

    private static class SessionSynchronization
    implements Synchronization {
        private EntityManager manager;
        private boolean closeAtTxCompletion;
        private String scopedPuName;

        public SessionSynchronization(EntityManager session, boolean close, String scopedPuName) {
            this.manager = session;
            this.closeAtTxCompletion = close;
            this.scopedPuName = scopedPuName;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            block4: {
                if (this.closeAtTxCompletion && this.safeToClose(status)) {
                    try {
                        if (JpaLogger.JPA_LOGGER.isDebugEnabled()) {
                            JpaLogger.JPA_LOGGER.debugf("%s: closing entity managersession", (Object)TransactionUtil.getEntityManagerDetails(this.manager));
                        }
                        this.manager.close();
                    }
                    catch (Exception ignored) {
                        if (!JpaLogger.JPA_LOGGER.isDebugEnabled()) break block4;
                        JpaLogger.JPA_LOGGER.debugf((Throwable)ignored, "ignoring error that occurred while closing EntityManager for %s (", (Object)this.scopedPuName);
                    }
                }
            }
        }

        private boolean safeToClose(int status) {
            boolean isItSafe = true;
            if (3 != status) {
                String currentThreadName = TransactionUtil.currentThread();
                boolean isBackgroundReaperThread = currentThreadName != null && currentThreadName.startsWith(TransactionUtil.ARJUNA_REAPER_THREAD_NAME);
                isItSafe = !isBackgroundReaperThread;
            }
            return isItSafe;
        }
    }
}

