/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.management;

import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.jpa.management.EntityManagerFactoryLookup;
import org.jboss.as.jpa.management.Path;
import org.jboss.as.jpa.management.StatisticNameLookup;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jipijapa.management.spi.EntityManagerFactoryAccess;
import org.jipijapa.management.spi.StatisticName;
import org.jipijapa.management.spi.Statistics;

public class ManagementResourceDefinition
extends SimpleResourceDefinition {
    private final Statistics statistics;
    private final EntityManagerFactoryLookup entityManagerFactoryLookup;
    private final ResourceDescriptionResolver descriptionResolver;
    private static final ModelVersion ENABLED_ATTRIBUTE_DEPRECATED_MODEL_VERSION = ModelVersion.create((int)1, (int)2, (int)0);
    private static final String ENABLED_ATTRIBUTE = "enabled";

    public ManagementResourceDefinition(PathElement pathElement, ResourceDescriptionResolver descriptionResolver, Statistics statistics, EntityManagerFactoryLookup entityManagerFactoryLookup) {
        super(pathElement, descriptionResolver);
        this.statistics = statistics;
        this.entityManagerFactoryLookup = entityManagerFactoryLookup;
        this.descriptionResolver = descriptionResolver;
    }

    private ModelType getModelType(Class type) {
        if (Integer.class.equals((Object)type)) {
            return ModelType.INT;
        }
        if (Long.class.equals((Object)type)) {
            return ModelType.LONG;
        }
        if (String.class.equals((Object)type)) {
            return ModelType.STRING;
        }
        if (Boolean.class.equals((Object)type)) {
            return ModelType.BOOLEAN;
        }
        return ModelType.OBJECT;
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        super.registerChildren(resourceRegistration);
        for (String sublevelChildName : this.statistics.getChildrenNames()) {
            Statistics sublevelStatistics = this.statistics.getChild(sublevelChildName);
            StandardResourceDescriptionResolver sublevelResourceDescriptionResolver = new StandardResourceDescriptionResolver(sublevelChildName, sublevelStatistics.getResourceBundleName(), sublevelStatistics.getClass().getClassLoader());
            resourceRegistration.registerSubModel((ResourceDefinition)new ManagementResourceDefinition(PathElement.pathElement((String)sublevelChildName), (ResourceDescriptionResolver)sublevelResourceDescriptionResolver, sublevelStatistics, this.entityManagerFactoryLookup));
        }
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        super.registerAttributes(resourceRegistration);
        for (final String statisticName : this.statistics.getNames()) {
            final ModelType modelType = this.getModelType(this.statistics.getType(statisticName));
            SimpleAttributeDefinitionBuilder simpleAttributeDefinitionBuilder = new SimpleAttributeDefinitionBuilder(statisticName, modelType, true).setXmlName(statisticName).setAllowExpression(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME});
            if (!this.statistics.isAttribute(statisticName)) continue;
            if (ENABLED_ATTRIBUTE.equals(statisticName)) {
                simpleAttributeDefinitionBuilder.setDeprecated(ENABLED_ATTRIBUTE_DEPRECATED_MODEL_VERSION);
            }
            AbstractMetricsHandler readHandler = new AbstractMetricsHandler(){

                @Override
                void handle(ModelNode response, OperationContext context, ModelNode operation) {
                    Object result = ManagementResourceDefinition.this.statistics.getValue(statisticName, (EntityManagerFactoryAccess)ManagementResourceDefinition.this.entityManagerFactoryLookup, (StatisticName)StatisticNameLookup.statisticNameLookup(statisticName), (org.jipijapa.management.spi.PathAddress)Path.path(PathAddress.pathAddress((ModelNode)operation.get("address"))));
                    if (result != null) {
                        ManagementResourceDefinition.this.setResponse(response, result, modelType);
                    }
                }
            };
            if (this.statistics.isWriteable(statisticName)) {
                AbstractMetricsHandler writeHandler = new AbstractMetricsHandler(){

                    @Override
                    void handle(ModelNode response, OperationContext context, ModelNode operation) {
                        Object oldSetting = ManagementResourceDefinition.this.statistics.getValue(statisticName, (EntityManagerFactoryAccess)ManagementResourceDefinition.this.entityManagerFactoryLookup, (StatisticName)StatisticNameLookup.statisticNameLookup(statisticName), (org.jipijapa.management.spi.PathAddress)Path.path(PathAddress.pathAddress((ModelNode)operation.get("address"))));
                        ModelNode value = operation.get("value").resolve();
                        if (Boolean.class.equals((Object)ManagementResourceDefinition.this.statistics.getType(statisticName))) {
                            ManagementResourceDefinition.this.statistics.setValue(statisticName, (Object)value.asBoolean(), (EntityManagerFactoryAccess)ManagementResourceDefinition.this.entityManagerFactoryLookup, (StatisticName)StatisticNameLookup.statisticNameLookup(statisticName), (org.jipijapa.management.spi.PathAddress)Path.path(PathAddress.pathAddress((ModelNode)operation.get("address"))));
                        } else if (Integer.class.equals((Object)ManagementResourceDefinition.this.statistics.getType(statisticName))) {
                            ManagementResourceDefinition.this.statistics.setValue(statisticName, (Object)value.asInt(), (EntityManagerFactoryAccess)ManagementResourceDefinition.this.entityManagerFactoryLookup, (StatisticName)StatisticNameLookup.statisticNameLookup(statisticName), (org.jipijapa.management.spi.PathAddress)Path.path(PathAddress.pathAddress((ModelNode)operation.get("address"))));
                        } else if (Long.class.equals((Object)ManagementResourceDefinition.this.statistics.getType(statisticName))) {
                            ManagementResourceDefinition.this.statistics.setValue(statisticName, (Object)value.asLong(), (EntityManagerFactoryAccess)ManagementResourceDefinition.this.entityManagerFactoryLookup, (StatisticName)StatisticNameLookup.statisticNameLookup(statisticName), (org.jipijapa.management.spi.PathAddress)Path.path(PathAddress.pathAddress((ModelNode)operation.get("address"))));
                        } else {
                            ManagementResourceDefinition.this.statistics.setValue(statisticName, (Object)value.asString(), (EntityManagerFactoryAccess)ManagementResourceDefinition.this.entityManagerFactoryLookup, (StatisticName)StatisticNameLookup.statisticNameLookup(statisticName), (org.jipijapa.management.spi.PathAddress)Path.path(PathAddress.pathAddress((ModelNode)operation.get("address"))));
                        }
                        final Object rollBackValue = oldSetting;
                        context.completeStep(new OperationContext.RollbackHandler(){

                            public void handleRollback(OperationContext context, ModelNode operation) {
                                ManagementResourceDefinition.this.statistics.setValue(statisticName, rollBackValue, (EntityManagerFactoryAccess)ManagementResourceDefinition.this.entityManagerFactoryLookup, (StatisticName)StatisticNameLookup.statisticNameLookup(statisticName), (org.jipijapa.management.spi.PathAddress)Path.path(PathAddress.pathAddress((ModelNode)operation.get("address"))));
                            }
                        });
                    }
                };
                resourceRegistration.registerReadWriteAttribute((AttributeDefinition)simpleAttributeDefinitionBuilder.build(), (OperationStepHandler)readHandler, (OperationStepHandler)writeHandler);
                continue;
            }
            resourceRegistration.registerMetric((AttributeDefinition)simpleAttributeDefinitionBuilder.build(), (OperationStepHandler)readHandler);
        }
    }

    private void setResponse(ModelNode response, Object result, ModelType modelType) {
        if (ModelType.INT.equals((Object)modelType)) {
            response.set(((Integer)result).intValue());
        } else if (ModelType.LONG.equals((Object)modelType)) {
            response.set(((Long)result).longValue());
        } else if (ModelType.BOOLEAN.equals((Object)modelType)) {
            response.set(((Boolean)result).booleanValue());
        } else {
            response.set(result.toString());
        }
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        for (final String statisticName : this.statistics.getNames()) {
            final ModelType modelType = this.getModelType(this.statistics.getType(statisticName));
            if (!this.statistics.isOperation(statisticName)) continue;
            SimpleAttributeDefinition attributeDefinition = new SimpleAttributeDefinitionBuilder(statisticName, modelType, true).setXmlName(statisticName).setAllowExpression(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME}).build();
            AbstractMetricsHandler operationHandler = new AbstractMetricsHandler(){

                @Override
                void handle(ModelNode response, OperationContext context, ModelNode operation) {
                    Object result = ManagementResourceDefinition.this.statistics.getValue(statisticName, (EntityManagerFactoryAccess)ManagementResourceDefinition.this.entityManagerFactoryLookup, (StatisticName)StatisticNameLookup.statisticNameLookup(statisticName), (org.jipijapa.management.spi.PathAddress)Path.path(PathAddress.pathAddress((ModelNode)operation.get("address"))));
                    if (result != null) {
                        ManagementResourceDefinition.this.setResponse(response, result, modelType);
                    }
                }
            };
            SimpleOperationDefinition definition = new SimpleOperationDefinition(statisticName, this.descriptionResolver, new AttributeDefinition[]{attributeDefinition});
            resourceRegistration.registerOperationHandler((OperationDefinition)definition, (OperationStepHandler)operationHandler);
        }
    }

    private static abstract class AbstractMetricsHandler
    extends AbstractRuntimeOnlyHandler {
        private AbstractMetricsHandler() {
        }

        abstract void handle(ModelNode var1, OperationContext var2, ModelNode var3);

        protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
            this.handle(context.getResult(), context, operation);
            context.stepCompleted();
        }
    }
}

