/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.container;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.jpa.messages.JpaLogger;

public class ThreadLocalStack<T> {
    private ThreadLocal<ArrayList<T>> stack = new ThreadLocal();

    public void push(T obj) {
        ArrayList<Object> list = this.stack.get();
        if (list == null) {
            list = new ArrayList(1);
            this.stack.set(list);
        }
        list.add(obj);
    }

    public T pop() {
        ArrayList<T> list = this.stack.get();
        if (list == null) {
            return null;
        }
        T rtn = list.remove(list.size() - 1);
        if (list.size() == 0) {
            this.stack.set(null);
            list.clear();
        }
        return rtn;
    }

    public void replace(T obj) {
        ArrayList<T> list = this.stack.get();
        if (list == null) {
            throw JpaLogger.ROOT_LOGGER.cannotReplaceStack();
        }
        list.set(list.size() - 1, obj);
    }

    public T get() {
        ArrayList<T> list = this.stack.get();
        if (list == null) {
            return null;
        }
        return list.get(list.size() - 1);
    }

    public List<T> getList() {
        return this.stack.get();
    }
}

