package org.jboss.as.jsf.logging;

import java.util.Locale;
import org.jboss.vfs.VirtualFile;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import java.lang.String;
import org.jboss.logging.Logger;
import org.jboss.jandex.DotName;
import java.lang.RuntimeException;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.util.List;
import java.lang.Object;
import java.util.Arrays;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2017-08-03T23:23:39-0500")
public class JSFLogger_$logger extends DelegatingBasicLogger implements JSFLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = JSFLogger_$logger.class.getName();
    public JSFLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void viewHandlerImproperlyInitialized() {
        super.log.logf(FQCN, WARN, null, viewHandlerImproperlyInitialized$str());
    }
    private static final String viewHandlerImproperlyInitialized = "WFLYJSF0001: WildFlyConversationAwareViewHandler was improperly initialized. Expected ViewHandler parent.";
    protected String viewHandlerImproperlyInitialized$str() {
        return viewHandlerImproperlyInitialized;
    }
    @Override
    public final void managedBeanLoadFail(final String managedBean) {
        super.log.logf(FQCN, ERROR, null, managedBeanLoadFail$str(), managedBean);
    }
    private static final String managedBeanLoadFail = "WFLYJSF0002: Could not load JSF managed bean class: %s";
    protected String managedBeanLoadFail$str() {
        return managedBeanLoadFail;
    }
    @Override
    public final void managedBeanNoDefaultConstructor(final String managedBean) {
        super.log.logf(FQCN, ERROR, null, managedBeanNoDefaultConstructor$str(), managedBean);
    }
    private static final String managedBeanNoDefaultConstructor = "WFLYJSF0003: JSF managed bean class %s has no default constructor";
    protected String managedBeanNoDefaultConstructor$str() {
        return managedBeanNoDefaultConstructor;
    }
    @Override
    public final void managedBeansConfigParseFailed(final VirtualFile facesConfig) {
        super.log.logf(FQCN, ERROR, null, managedBeansConfigParseFailed$str(), facesConfig);
    }
    private static final String managedBeansConfigParseFailed = "WFLYJSF0004: Failed to parse %s, managed beans defined in this file will not be available";
    protected String managedBeansConfigParseFailed$str() {
        return managedBeansConfigParseFailed;
    }
    @Override
    public final void unknownJSFVersion(final String version, final String defaultVersion) {
        super.log.logf(FQCN, WARN, null, unknownJSFVersion$str(), version, defaultVersion);
    }
    private static final String unknownJSFVersion = "WFLYJSF0005: Unknown JSF version '%s'.  Default version '%s' will be used instead.";
    protected String unknownJSFVersion$str() {
        return unknownJSFVersion;
    }
    @Override
    public final void missingJSFModule(final String version, final String module) {
        super.log.logf(FQCN, WARN, null, missingJSFModule$str(), version, module);
    }
    private static final String missingJSFModule = "WFLYJSF0006: JSF version slot '%s' is missing from module %s";
    protected String missingJSFModule$str() {
        return missingJSFModule;
    }
    @Override
    public final void activatedJSFImplementations(final List target) {
        super.log.logf(FQCN, INFO, null, activatedJSFImplementations$str(), target);
    }
    private static final String activatedJSFImplementations = "WFLYJSF0007: Activated the following JSF Implementations: %s";
    protected String activatedJSFImplementations$str() {
        return activatedJSFImplementations;
    }
    private static final String classLoadingFailed = "WFLYJSF0008: Failed to load annotated class: %s";
    protected String classLoadingFailed$str() {
        return classLoadingFailed;
    }
    @Override
    public final String classLoadingFailed(final DotName clazz) {
        return String.format(getLoggingLocale(), classLoadingFailed$str(), clazz);
    }
    private static final String invalidAnnotationLocation = "WFLYJSF0009: Annotation %s in class %s is only allowed on classes";
    protected String invalidAnnotationLocation$str() {
        return invalidAnnotationLocation;
    }
    @Override
    public final String invalidAnnotationLocation(final Object annotation, final AnnotationTarget classInfo) {
        return String.format(getLoggingLocale(), invalidAnnotationLocation$str(), annotation, classInfo);
    }
    private static final String instanceCreationFailed = "WFLYJSF0010: Instance creation failed";
    protected String instanceCreationFailed$str() {
        return instanceCreationFailed;
    }
    @Override
    public final RuntimeException instanceCreationFailed(final Throwable t) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), instanceCreationFailed$str()), t);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String instanceDestructionFailed = "WFLYJSF0011: Instance destruction failed";
    protected String instanceDestructionFailed$str() {
        return instanceDestructionFailed;
    }
    @Override
    public final RuntimeException instanceDestructionFailed(final Throwable t) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), instanceDestructionFailed$str()), t);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noThreadLocalInjectionContainer = "WFLYJSF0012: Thread local injection container not set";
    protected String noThreadLocalInjectionContainer$str() {
        return noThreadLocalInjectionContainer;
    }
    @Override
    public final IllegalStateException noThreadLocalInjectionContainer() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), noThreadLocalInjectionContainer$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidManagedBeanAnnotation = "WFLYJSF0013: @ManagedBean is only allowed at class level %s";
    protected String invalidManagedBeanAnnotation$str() {
        return invalidManagedBeanAnnotation;
    }
    @Override
    public final String invalidManagedBeanAnnotation(final AnnotationTarget target) {
        return String.format(getLoggingLocale(), invalidManagedBeanAnnotation$str(), target);
    }
    private static final String invalidDefaultJSFImpl = "WFLYJSF0014: Default JSF implementation slot '%s' is invalid";
    protected String invalidDefaultJSFImpl$str() {
        return invalidDefaultJSFImpl;
    }
    @Override
    public final DeploymentUnitProcessingException invalidDefaultJSFImpl(final String defaultJsfVersion) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), invalidDefaultJSFImpl$str(), defaultJsfVersion));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
