/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.access.constraint.SensitivityClassification;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.DiscardAttributeChecker;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.ElementAttributeMarshaller;
import org.jboss.as.logging.KnownModelVersion;
import org.jboss.as.logging.LoggingExtension;
import org.jboss.as.logging.LoggingLogger;
import org.jboss.as.logging.LoggingMessages;
import org.jboss.as.logging.LoggingSubsystemAdd;
import org.jboss.as.logging.TransformerResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class LoggingRootResource
extends TransformerResourceDefinition {
    private static final SensitiveTargetAccessConstraintDefinition VIEW_SERVER_LOGS = new SensitiveTargetAccessConstraintDefinition(new SensitivityClassification("logging", "view-server-logs", false, false, false));
    static final PathElement SUBSYSTEM_PATH = PathElement.pathElement((String)"subsystem", (String)"logging");
    static final SimpleAttributeDefinition ADD_LOGGING_API_DEPENDENCIES = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"add-logging-api-dependencies", (ModelType)ModelType.BOOLEAN, (boolean)true).setAllowExpression(true).setAttributeMarshaller((AttributeMarshaller)ElementAttributeMarshaller.VALUE_ATTRIBUTE_MARSHALLER)).setDefaultValue(new ModelNode(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    static final SimpleAttributeDefinition USE_DEPLOYMENT_LOGGING_CONFIG = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"use-deployment-logging-config", (ModelType)ModelType.BOOLEAN, (boolean)true).setAllowExpression(true).setAttributeMarshaller((AttributeMarshaller)ElementAttributeMarshaller.VALUE_ATTRIBUTE_MARSHALLER)).setDefaultValue(new ModelNode(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    static final SimpleAttributeDefinition NAME = SimpleAttributeDefinitionBuilder.create((String)"name", (ModelType)ModelType.STRING, (boolean)false).setAllowExpression(true).setValidator((ParameterValidator)new StringLengthValidator(1, false)).build();
    static final SimpleAttributeDefinition LINES = SimpleAttributeDefinitionBuilder.create((String)"lines", (ModelType)ModelType.INT, (boolean)true).setAllowExpression(true).setDefaultValue(new ModelNode(10)).setValidator((ParameterValidator)new IntRangeValidator(-1, true)).build();
    static final SimpleAttributeDefinition SKIP = SimpleAttributeDefinitionBuilder.create((String)"skip", (ModelType)ModelType.INT, (boolean)true).setAllowExpression(true).setDefaultValue(new ModelNode(0)).setValidator((ParameterValidator)new IntRangeValidator(0, true)).build();
    static final SimpleAttributeDefinition TAIL = SimpleAttributeDefinitionBuilder.create((String)"tail", (ModelType)ModelType.BOOLEAN, (boolean)true).setAllowExpression(true).setDefaultValue(new ModelNode(true)).build();
    static final SimpleAttributeDefinition FILE_NAME = SimpleAttributeDefinitionBuilder.create((String)"file-name", (ModelType)ModelType.STRING, (boolean)false).build();
    static final SimpleAttributeDefinition FILE_SIZE = SimpleAttributeDefinitionBuilder.create((String)"file-size", (ModelType)ModelType.LONG, (boolean)false).build();
    static final SimpleOperationDefinition READ_LOG_FILE = new SimpleOperationDefinitionBuilder("read-log-file", (ResourceDescriptionResolver)LoggingExtension.getResourceDescriptionResolver(new String[0])).addAccessConstraint((AccessConstraintDefinition)VIEW_SERVER_LOGS).setParameters(new AttributeDefinition[]{NAME, CommonAttributes.ENCODING, LINES, SKIP, TAIL}).setReplyType(ModelType.LIST).setReplyValueType(ModelType.STRING).setReadOnly().setRuntimeOnly().build();
    static final SimpleOperationDefinition LIST_LOG_FILES = new SimpleOperationDefinitionBuilder("list-log-files", (ResourceDescriptionResolver)LoggingExtension.getResourceDescriptionResolver(new String[0])).addAccessConstraint((AccessConstraintDefinition)VIEW_SERVER_LOGS).setReplyType(ModelType.LIST).setReplyParameters(new AttributeDefinition[]{FILE_NAME, FILE_SIZE}).setReadOnly().setRuntimeOnly().build();
    static final SimpleAttributeDefinition[] ATTRIBUTES = new SimpleAttributeDefinition[]{ADD_LOGGING_API_DEPENDENCIES, USE_DEPLOYMENT_LOGGING_CONFIG};
    private final PathManager pathManager;

    protected LoggingRootResource(PathManager pathManager) {
        super(SUBSYSTEM_PATH, (ResourceDescriptionResolver)LoggingExtension.getResourceDescriptionResolver(new String[0]), (OperationStepHandler)LoggingSubsystemAdd.INSTANCE, (OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE);
        this.pathManager = pathManager;
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        super.registerAttributes(resourceRegistration);
        ReloadRequiredWriteAttributeHandler writeHandler = new ReloadRequiredWriteAttributeHandler((AttributeDefinition[])ATTRIBUTES);
        for (SimpleAttributeDefinition attribute : ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute((AttributeDefinition)attribute, null, (OperationStepHandler)writeHandler);
        }
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        if (this.pathManager != null) {
            resourceRegistration.registerOperationHandler((OperationDefinition)LIST_LOG_FILES, (OperationStepHandler)new ListLogFilesOperation(this.pathManager));
            resourceRegistration.registerOperationHandler((OperationDefinition)READ_LOG_FILE, (OperationStepHandler)new ReadLogFileOperation(this.pathManager));
        }
    }

    @Override
    public void registerTransformers(KnownModelVersion modelVersion, ResourceTransformationDescriptionBuilder rootResourceBuilder, ResourceTransformationDescriptionBuilder loggingProfileBuilder) {
        switch (modelVersion) {
            case VERSION_1_1_0: 
            case VERSION_1_2_0: 
            case VERSION_1_3_0: {
                AttributeTransformationDescriptionBuilder attributeBuilder = rootResourceBuilder.getAttributeBuilder();
                for (SimpleAttributeDefinition attribute : ATTRIBUTES) {
                    ((AttributeTransformationDescriptionBuilder)attributeBuilder.setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(false, true, new ModelNode[]{attribute.getDefaultValue()}), new AttributeDefinition[]{attribute})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{attribute});
                }
                attributeBuilder.end();
            }
        }
    }

    private static void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Throwable t) {
                LoggingLogger.ROOT_LOGGER.failedToCloseResource(t, closeable);
            }
        }
    }

    static final class LifoFileInputStream
    extends InputStream {
        private final RandomAccessFile raf;
        private final long len;
        private long start;
        private long end;
        private long pos;

        LifoFileInputStream(File file) throws IOException {
            this.raf = new RandomAccessFile(file, "r");
            this.start = this.len = this.raf.length();
            this.pos = this.end = this.len;
        }

        private void positionFile() throws IOException {
            this.end = this.start;
            if (this.end == 0L) {
                this.end = -1L;
                this.start = -1L;
                this.pos = -1L;
                return;
            }
            long filePointer = this.start - 1L;
            while (--filePointer >= 0L) {
                this.raf.seek(filePointer);
                byte readByte = this.raf.readByte();
                if (readByte != 10 || filePointer == this.len - 1L) continue;
                break;
            }
            this.pos = this.start = filePointer + 1L;
        }

        @Override
        public int read() throws IOException {
            if (this.pos < this.end) {
                this.raf.seek(this.pos++);
                return this.raf.readByte();
            }
            if (this.pos < 0L) {
                return -1;
            }
            this.positionFile();
            return this.read();
        }

        @Override
        public void close() throws IOException {
            this.raf.close();
        }
    }

    private static class ReadLogFileOperation
    implements OperationStepHandler {
        private final PathManager pathManager;

        private ReadLogFileOperation(PathManager pathManager) {
            this.pathManager = pathManager;
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            for (AttributeDefinition attribute : READ_LOG_FILE.getParameters()) {
                attribute.validateOperation(operation);
            }
            String fileName = NAME.resolveModelAttribute(context, operation).asString();
            int numberOfLines = LINES.resolveModelAttribute(context, operation).asInt();
            int skip = SKIP.resolveModelAttribute(context, operation).asInt();
            boolean tail = TAIL.resolveModelAttribute(context, operation).asBoolean();
            ModelNode encodingModel = CommonAttributes.ENCODING.resolveModelAttribute(context, operation);
            String encoding = encodingModel.isDefined() ? encodingModel.asString() : null;
            File path = new File(this.pathManager.resolveRelativePathEntry(fileName, "jboss.server.log.dir"));
            if (!path.exists()) {
                throw LoggingMessages.MESSAGES.logFileNotFound(fileName, "jboss.server.log.dir");
            }
            if (!path.canRead()) {
                throw LoggingMessages.MESSAGES.readPermissionDenied(fileName, "jboss.server.log.dir");
            }
            try {
                List<Object> lines = numberOfLines == 0 ? Collections.emptyList() : this.readLines(path, encoding, tail, skip, numberOfLines);
                ModelNode result = context.getResult().setEmptyList();
                for (String line : lines) {
                    result.add(line);
                }
            }
            catch (IOException e) {
                throw LoggingMessages.MESSAGES.failedToReadLogFile(e, fileName);
            }
            context.completeStep(OperationContext.ResultHandler.NOOP_RESULT_HANDLER);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<String> readLines(File file, String encoding, boolean tail, int skip, int numberOfLines) throws IOException {
            ArrayList<String> arrayList;
            ArrayList<String> lines = numberOfLines < 0 ? new ArrayList<String>() : new ArrayList(numberOfLines);
            BufferedReader reader = null;
            try {
                String line;
                InputStream in = tail ? new LifoFileInputStream(file) : new FileInputStream(file);
                reader = encoding == null ? new BufferedReader(new InputStreamReader(in)) : new BufferedReader(new InputStreamReader(in, encoding));
                int lineCount = 0;
                while ((line = reader.readLine()) != null) {
                    if (++lineCount <= skip) continue;
                    if (lines.size() == numberOfLines) break;
                    lines.add(line);
                }
                if (tail) {
                    Collections.reverse(lines);
                }
                arrayList = lines;
            }
            catch (Throwable throwable) {
                LoggingRootResource.safeClose(reader);
                throw throwable;
            }
            LoggingRootResource.safeClose(reader);
            return arrayList;
        }
    }

    private static class ListLogFilesOperation
    implements OperationStepHandler {
        private final PathManager pathManager;

        private ListLogFilesOperation(PathManager pathManager) {
            this.pathManager = pathManager;
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            String logDir = this.pathManager.getPathEntry("jboss.server.log.dir").resolvePath();
            File[] logFiles = new File(logDir).listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isFile() && pathname.canRead();
                }
            });
            ModelNode result = context.getResult().setEmptyList();
            for (File logFile : logFiles) {
                ModelNode fileInfo = new ModelNode();
                fileInfo.get(FILE_NAME.getName()).set(logFile.getName());
                fileInfo.get(FILE_SIZE.getName()).set(logFile.length());
                result.add(fileInfo);
            }
            context.completeStep(OperationContext.ResultHandler.NOOP_RESULT_HANDLER);
        }
    }
}

