/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.gpg;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.gpg.AbstractGpgSigner;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.bc.BcPBESecretKeyDecryptorBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPGPDigestCalculatorProvider;
import org.bouncycastle.util.encoders.Hex;
import org.codehaus.plexus.util.io.CachingOutputStream;
import org.eclipse.aether.RepositorySystemSession;

public class BcSigner
extends AbstractGpgSigner {
    public static final String NAME = "bc";
    private final RepositorySystemSession session;
    private final String keyEnvName;
    private final String keyFingerprintEnvName;
    private final String agentSocketLocations;
    private final String keyFilePath;
    private final String keyFingerprint;
    private PGPSecretKey secretKey;
    private PGPPrivateKey privateKey;
    private PGPSignatureSubpacketVector hashSubPackets;

    public BcSigner(RepositorySystemSession session, String keyEnvName, String keyFingerprintEnvName, String agentSocketLocations, String keyFilePath, String keyFingerprint) {
        this.session = session;
        this.keyEnvName = keyEnvName;
        this.keyFingerprintEnvName = keyFingerprintEnvName;
        this.agentSocketLocations = agentSocketLocations;
        this.keyFilePath = keyFilePath;
        this.keyFingerprint = keyFingerprint;
    }

    @Override
    public String signerName() {
        return NAME;
    }

    @Override
    public void prepare() throws MojoFailureException {
        try {
            boolean keyPassNeeded;
            Loader loader;
            Object loader2;
            List loaders = Stream.of(new GpgEnvLoader(), new GpgConfLoader(), new GpgAgentPasswordLoader()).collect(Collectors.toList());
            byte[] keyRingMaterial = null;
            Iterator iterator = loaders.iterator();
            while (iterator.hasNext() && (keyRingMaterial = (loader2 = (Loader)iterator.next()).loadKeyRingMaterial(this.session)) == null) {
            }
            if (keyRingMaterial == null) {
                throw new MojoFailureException("Key ring material not found");
            }
            byte[] fingerprint = null;
            loader2 = loaders.iterator();
            while (loader2.hasNext() && (fingerprint = (loader = (Loader)loader2.next()).loadKeyFingerprint(this.session)) == null) {
            }
            PGPSecretKeyRingCollection pgpSecretKeyRingCollection = new PGPSecretKeyRingCollection(PGPUtil.getDecoderStream((InputStream)new ByteArrayInputStream(keyRingMaterial)), (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
            PGPSecretKey secretKey = null;
            block4: for (PGPSecretKeyRing ring : pgpSecretKeyRingCollection) {
                for (PGPSecretKey key : ring) {
                    if (key.isPrivateKeyEmpty() || fingerprint != null && !Arrays.equals(fingerprint, key.getFingerprint())) continue;
                    secretKey = key;
                    continue block4;
                }
            }
            if (secretKey == null) {
                throw new MojoFailureException("Secret key not found");
            }
            if (secretKey.isPrivateKeyEmpty()) {
                throw new MojoFailureException("Private key not found in Secret key");
            }
            long validSeconds = secretKey.getPublicKey().getValidSeconds();
            if (validSeconds > 0L) {
                LocalDateTime expireDateTime = secretKey.getPublicKey().getCreationTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime().plusSeconds(validSeconds);
                if (LocalDateTime.now().isAfter(expireDateTime)) {
                    throw new MojoFailureException("Secret key expired at: " + expireDateTime);
                }
            }
            char[] keyPassword = this.passphrase != null ? this.passphrase.toCharArray() : null;
            boolean bl = keyPassNeeded = secretKey.getKeyEncryptionAlgorithm() != 0;
            if (keyPassNeeded && keyPassword == null) {
                Loader loader3;
                Iterator iterator2 = loaders.iterator();
                while (iterator2.hasNext() && (keyPassword = (loader3 = (Loader)iterator2.next()).loadPassword(this.session, secretKey.getFingerprint())) == null) {
                }
                if (keyPassword == null) {
                    throw new MojoFailureException("Secret key is encrypted but no passphrase provided");
                }
            }
            this.secretKey = secretKey;
            this.privateKey = secretKey.extractPrivateKey(new BcPBESecretKeyDecryptorBuilder((PGPDigestCalculatorProvider)new BcPGPDigestCalculatorProvider()).build(keyPassword));
            if (keyPassword != null) {
                Arrays.fill(keyPassword, ' ');
            }
            PGPSignatureSubpacketGenerator subPacketGenerator = new PGPSignatureSubpacketGenerator();
            subPacketGenerator.setIssuerFingerprint(false, secretKey);
            this.hashSubPackets = subPacketGenerator.generate();
        }
        catch (IOException | PGPException e) {
            throw new MojoFailureException(e);
        }
    }

    @Override
    public String getKeyInfo() {
        Iterator userIds = this.secretKey.getPublicKey().getUserIDs();
        if (userIds.hasNext()) {
            return (String)userIds.next();
        }
        return Hex.toHexString((byte[])this.secretKey.getPublicKey().getFingerprint());
    }

    @Override
    protected void generateSignatureForFile(File file, File signature) throws MojoExecutionException {
        try (InputStream in = Files.newInputStream(file.toPath(), new OpenOption[0]);
             CachingOutputStream out = new CachingOutputStream(signature.toPath());){
            int len;
            PGPSignatureGenerator sGen = new PGPSignatureGenerator((PGPContentSignerBuilder)new BcPGPContentSignerBuilder(this.secretKey.getPublicKey().getAlgorithm(), 10));
            sGen.init(0, this.privateKey);
            sGen.setHashedSubpackets(this.hashSubPackets);
            byte[] buffer = new byte[8192];
            while ((len = in.read(buffer)) >= 0) {
                sGen.update(buffer, 0, len);
            }
            try (BCPGOutputStream bcpgOutputStream = new BCPGOutputStream((OutputStream)new ArmoredOutputStream((OutputStream)out));){
                sGen.generate().encode((OutputStream)bcpgOutputStream);
            }
        }
        catch (IOException | PGPException e) {
            throw new MojoExecutionException(e);
        }
    }

    public final class GpgAgentPasswordLoader
    implements Loader {
        @Override
        public char[] loadPassword(RepositorySystemSession session, byte[] fingerprint) throws IOException {
            if (!BcSigner.this.useAgent) {
                return null;
            }
            List socketLocations = Arrays.stream(BcSigner.this.agentSocketLocations.split(",")).filter(s -> s != null && !s.isEmpty()).collect(Collectors.toList());
            for (String socketLocation : socketLocations) {
                try {
                    Path socketLocationPath = Paths.get(socketLocation, new String[0]);
                    if (!socketLocationPath.isAbsolute()) {
                        socketLocationPath = Paths.get(System.getProperty("user.home"), new String[0]).resolve(socketLocationPath).toAbsolutePath();
                    }
                    return this.load(fingerprint, socketLocationPath);
                }
                catch (SocketException socketException) {
                }
            }
            return null;
        }

        /*
         * Exception decompiling
         */
        private char[] load(byte[] fingerprint, Path socketPath) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private void expectOK(BufferedReader in) throws IOException {
            String response = in.readLine();
            if (!response.startsWith("OK")) {
                throw new IOException("Expected OK but got this instead: " + response);
            }
        }

        private char[] mayExpectOK(BufferedReader in) throws IOException {
            String response = in.readLine();
            if (response.startsWith("ERR")) {
                return null;
            }
            if (!response.startsWith("OK")) {
                throw new IOException("Expected OK/ERR but got this instead: " + response);
            }
            return new String(Hex.decode((String)response.substring(Math.min(response.length(), 3)).trim())).toCharArray();
        }
    }

    public final class GpgConfLoader
    implements Loader {
        private static final long MAX_SIZE = 64001L;

        @Override
        public byte[] loadKeyRingMaterial(RepositorySystemSession session) throws IOException {
            Path keyPath = Paths.get(BcSigner.this.keyFilePath, new String[0]);
            if (!keyPath.isAbsolute()) {
                keyPath = Paths.get(System.getProperty("user.home"), new String[0]).resolve(keyPath).toAbsolutePath();
            }
            if (Files.isRegularFile(keyPath, new LinkOption[0])) {
                if (Files.size(keyPath) < 64001L) {
                    return Files.readAllBytes(keyPath);
                }
                throw new IOException("Refusing to load file " + keyPath + "; is larger than 64 kB");
            }
            return null;
        }

        @Override
        public byte[] loadKeyFingerprint(RepositorySystemSession session) {
            if (BcSigner.this.keyFingerprint != null) {
                if (BcSigner.this.keyFingerprint.trim().length() == 40) {
                    return Hex.decode((String)BcSigner.this.keyFingerprint);
                }
                throw new IllegalArgumentException("Key fingerprint configuration is wrong (hex encoded, 40 characters)");
            }
            return null;
        }
    }

    public final class GpgEnvLoader
    implements Loader {
        @Override
        public byte[] loadKeyRingMaterial(RepositorySystemSession session) {
            String keyMaterial = (String)session.getConfigProperties().get("env." + BcSigner.this.keyEnvName);
            if (keyMaterial != null) {
                return keyMaterial.getBytes(StandardCharsets.UTF_8);
            }
            return null;
        }

        @Override
        public byte[] loadKeyFingerprint(RepositorySystemSession session) {
            String keyFingerprint = (String)session.getConfigProperties().get("env." + BcSigner.this.keyFingerprintEnvName);
            if (keyFingerprint != null) {
                if (keyFingerprint.trim().length() == 40) {
                    return Hex.decode((String)keyFingerprint);
                }
                throw new IllegalArgumentException("Key fingerprint configuration is wrong (hex encoded, 40 characters)");
            }
            return null;
        }
    }

    public static interface Loader {
        default public byte[] loadKeyRingMaterial(RepositorySystemSession session) throws IOException {
            return null;
        }

        default public byte[] loadKeyFingerprint(RepositorySystemSession session) throws IOException {
            return null;
        }

        default public char[] loadPassword(RepositorySystemSession session, byte[] fingerprint) throws IOException {
            return null;
        }
    }
}

