/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.mcp.api;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.wildfly.mcp.api.Content;
import org.wildfly.mcp.api.PromptMessage;
import org.wildfly.mcp.api.ResourceContents;
import org.wildfly.mcp.api.TextContent;
import org.wildfly.mcp.api.TextResourceContents;

public class ContentMapper {
    public static Collection<? extends Content> processResultAsText(Object result) {
        if (result instanceof Collection) {
            Collection collection = (Collection)result;
            if (ContentMapper.isContent(collection)) {
                return (Collection)result;
            }
            return collection.stream().map(c -> new TextContent(c.toString())).toList();
        }
        if (result.getClass().isArray()) {
            if (Content.class.isAssignableFrom((Class<?>)result.getClass().arrayType())) {
                return Arrays.asList((Content[])result);
            }
            return Arrays.stream((Object[])result).map(c -> new TextContent(c.toString())).toList();
        }
        if (Content.class.isAssignableFrom(result.getClass())) {
            return List.of((Content)result);
        }
        return List.of(new TextContent(result.toString()));
    }

    private static boolean isContent(Collection result) {
        Type resultType = result.getClass().getGenericSuperclass();
        if (resultType instanceof ParameterizedType) {
            Type realType = ((ParameterizedType)resultType).getActualTypeArguments()[0];
            return Content.class.isAssignableFrom(realType.getClass());
        }
        return false;
    }

    public static Collection<? extends PromptMessage> processResultAsPromptMessage(Object result) {
        if (result instanceof Collection) {
            Collection collection = (Collection)result;
            if (ContentMapper.isPromptMessage(collection)) {
                return (Collection)result;
            }
            return collection.stream().map(c -> PromptMessage.withUserRole(new TextContent(c.toString()))).toList();
        }
        if (result.getClass().isArray()) {
            if (PromptMessage.class.isAssignableFrom((Class<?>)result.getClass().arrayType())) {
                return Arrays.asList((PromptMessage[])result);
            }
            return Arrays.stream((Object[])result).map(c -> PromptMessage.withUserRole(new TextContent(c.toString()))).toList();
        }
        if (PromptMessage.class.isAssignableFrom(result.getClass())) {
            return List.of((PromptMessage)result);
        }
        return List.of(PromptMessage.withUserRole(new TextContent(result.toString())));
    }

    private static boolean isPromptMessage(Collection result) {
        Type resultType = result.getClass().getGenericSuperclass();
        if (resultType instanceof ParameterizedType) {
            Type realType = ((ParameterizedType)resultType).getActualTypeArguments()[0];
            return PromptMessage.class.isAssignableFrom(realType.getClass());
        }
        return false;
    }

    public static Collection<? extends ResourceContents> processResultAsResourceText(String uri, Object result) {
        if (result instanceof Collection) {
            Collection collection = (Collection)result;
            if (ContentMapper.isResourceContents(collection)) {
                return (Collection)result;
            }
            return collection.stream().map(c -> TextResourceContents.create(uri, c.toString())).toList();
        }
        if (result.getClass().isArray()) {
            if (ResourceContents.class.isAssignableFrom((Class<?>)result.getClass().arrayType())) {
                return Arrays.asList((ResourceContents[])result);
            }
            return Arrays.stream((Object[])result).map(c -> TextResourceContents.create(uri, c.toString())).toList();
        }
        if (ResourceContents.class.isAssignableFrom(result.getClass())) {
            return List.of((ResourceContents)result);
        }
        return List.of(TextResourceContents.create(uri, result.toString()));
    }

    private static boolean isResourceContents(Collection result) {
        Type resultType = result.getClass().getGenericSuperclass();
        if (resultType instanceof ParameterizedType) {
            Type realType = ((ParameterizedType)resultType).getActualTypeArguments()[0];
            return ResourceContents.class.isAssignableFrom(realType.getClass());
        }
        return false;
    }
}

