/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.mcp.injection;

import jakarta.enterprise.inject.spi.Extension;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.wildfly.extension.mcp.injection.MCPLogger;
import org.wildfly.extension.mcp.injection.tool.McpFeatureMetadata;
import org.wildfly.extension.mcp.injection.tool.MethodMetadata;

public class WildFlyMCPRegistry {
    private final Map<String, McpFeatureMetadata> tools = new HashMap<String, McpFeatureMetadata>();
    private final Map<String, McpFeatureMetadata> prompts = new HashMap<String, McpFeatureMetadata>();
    private final Map<String, McpFeatureMetadata> resources = new HashMap<String, McpFeatureMetadata>();
    private final Map<String, MethodHandle> toolInvokers = new HashMap<String, MethodHandle>();
    private final Map<String, MethodHandle> promptInvokers = new HashMap<String, MethodHandle>();
    private final Map<String, MethodHandle> resourceInvokers = new HashMap<String, MethodHandle>();
    private final MethodHandles.Lookup lookup = MethodHandles.lookup();

    public static final List<Extension> getCDIExtensions() {
        return List.of();
    }

    public Iterable<McpFeatureMetadata> listTools() {
        return this.tools.values();
    }

    public Iterable<McpFeatureMetadata> listPrompts() {
        return this.prompts.values();
    }

    public Iterable<McpFeatureMetadata> listResources() {
        return this.resources.values();
    }

    public void addTool(String name, McpFeatureMetadata metadata) {
        this.tools.put(name, metadata);
    }

    public void addPrompt(String name, McpFeatureMetadata metadata) {
        this.prompts.put(name, metadata);
    }

    public void addResource(String uri, McpFeatureMetadata metadata) {
        this.resources.put(uri, metadata);
    }

    public McpFeatureMetadata getTool(String tool) {
        return this.tools.get(tool);
    }

    public McpFeatureMetadata getPrompt(String prompt) {
        return this.prompts.get(prompt);
    }

    public McpFeatureMetadata getResource(String resource) {
        return this.resources.get(resource);
    }

    public MethodHandle getToolInvoker(String tool) {
        return this.toolInvokers.get(tool);
    }

    public MethodHandle getPromptInvoker(String prompt) {
        return this.promptInvokers.get(prompt);
    }

    public MethodHandle getResourceInvoker(String uri) {
        return this.resourceInvokers.get(uri);
    }

    public void prepareTool(String toolName, Class<?> clazz) {
        try {
            MethodMetadata method = this.tools.get(toolName).method();
            MethodType mt = MethodType.methodType(Class.forName(method.returnType(), true, clazz.getClassLoader()), method.argumentTypes());
            MethodHandles.Lookup privateLookup = MethodHandles.privateLookupIn(clazz, this.lookup);
            MethodHandle handle = privateLookup.findVirtual(clazz, method.name(), mt);
            this.toolInvokers.put(toolName, handle);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException ex) {
            MCPLogger.ROOT_LOGGER.error("Unexpected error ", ex);
        }
    }

    public void preparePrompt(String promptName, Class<?> clazz) {
        try {
            MethodMetadata method = this.prompts.get(promptName).method();
            MethodType mt = MethodType.methodType(Class.forName(method.returnType(), true, clazz.getClassLoader()), method.argumentTypes());
            MethodHandles.Lookup privateLookup = MethodHandles.privateLookupIn(clazz, this.lookup);
            MethodHandle handle = privateLookup.findVirtual(clazz, method.name(), mt);
            this.promptInvokers.put(promptName, handle);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException ex) {
            MCPLogger.ROOT_LOGGER.error("Unexpected error ", ex);
        }
    }

    public void prepareResource(String resourceUri, Class<?> clazz) {
        try {
            MethodMetadata method = this.resources.get(resourceUri).method();
            MethodType mt = MethodType.methodType(Class.forName(method.returnType(), true, clazz.getClassLoader()), method.argumentTypes());
            MethodHandles.Lookup privateLookup = MethodHandles.privateLookupIn(clazz, this.lookup);
            MethodHandle handle = privateLookup.findVirtual(clazz, method.name(), mt);
            this.resourceInvokers.put(resourceUri, handle);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException ex) {
            MCPLogger.ROOT_LOGGER.error("Unexpected error ", ex);
        }
    }
}

