/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.mcp.injection.tool;

import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.literal.SingletonLiteral;
import jakarta.enterprise.inject.spi.AfterTypeDiscovery;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.configurator.AnnotatedTypeConfigurator;
import jakarta.enterprise.util.AnnotationLiteral;
import java.lang.annotation.Annotation;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.wildfly.extension.mcp.injection.MCPLogger;
import org.wildfly.extension.mcp.injection.WildFlyMCPRegistry;
import org.wildfly.extension.mcp.injection.tool.McpFeatureMetadata;
import org.wildfly.extension.mcp.injection.tool.McpPrompt;
import org.wildfly.extension.mcp.injection.tool.McpResource;
import org.wildfly.extension.mcp.injection.tool.McpTool;

public class McpPortableExtension
implements Extension {
    private final WildFlyMCPRegistry registry;
    private final ClassLoader deploymentClassLoader;

    public McpPortableExtension(WildFlyMCPRegistry registry, ClassLoader deploymentClassLoader) {
        this.registry = registry;
        this.deploymentClassLoader = deploymentClassLoader;
    }

    public void atd(@Observes AfterTypeDiscovery atd) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException {
        Class<?> clazz;
        String className;
        HashMap beanClasses = new HashMap();
        HashMap ids = new HashMap();
        for (McpFeatureMetadata mcpFeatureMetadata : this.registry.listTools()) {
            className = mcpFeatureMetadata.method().declaringClassName();
            MCPLogger.ROOT_LOGGER.info("Adding " + className + " to CDI for discovery");
            try {
                clazz = Class.forName(className, true, this.deploymentClassLoader);
                this.registry.prepareTool(mcpFeatureMetadata.name(), clazz);
                this.updateAnnotations(beanClasses, clazz, McpTool.McpToolLiteral.INSTANCE);
                ids.putIfAbsent(clazz, (CallSite)((Object)(mcpFeatureMetadata.name() + "-" + mcpFeatureMetadata.method().name())));
            }
            catch (ClassNotFoundException ex) {
                MCPLogger.ROOT_LOGGER.error("Unexpected error ", ex);
            }
        }
        for (McpFeatureMetadata mcpFeatureMetadata : this.registry.listPrompts()) {
            className = mcpFeatureMetadata.method().declaringClassName();
            MCPLogger.ROOT_LOGGER.info("Adding " + className + " to CDI for discovery");
            try {
                clazz = Class.forName(className, true, this.deploymentClassLoader);
                this.registry.preparePrompt(mcpFeatureMetadata.name(), clazz);
                this.updateAnnotations(beanClasses, clazz, McpPrompt.McpPromptLiteral.INSTANCE);
                ids.putIfAbsent(clazz, (CallSite)((Object)(mcpFeatureMetadata.name() + "-" + mcpFeatureMetadata.method().name())));
            }
            catch (ClassNotFoundException ex) {
                MCPLogger.ROOT_LOGGER.error("Unexpected error ", ex);
            }
        }
        for (McpFeatureMetadata mcpFeatureMetadata : this.registry.listResources()) {
            className = mcpFeatureMetadata.method().declaringClassName();
            MCPLogger.ROOT_LOGGER.info("Adding " + className + " to CDI for discovery");
            try {
                clazz = Class.forName(className, true, this.deploymentClassLoader);
                this.registry.prepareResource(mcpFeatureMetadata.method().uri(), clazz);
                this.updateAnnotations(beanClasses, clazz, McpResource.McpResourceLiteral.INSTANCE);
                ids.putIfAbsent(clazz, (CallSite)((Object)(mcpFeatureMetadata.method().uri() + "-" + mcpFeatureMetadata.method().name())));
            }
            catch (ClassNotFoundException ex) {
                MCPLogger.ROOT_LOGGER.error("Unexpected error ", ex);
            }
        }
        for (Map.Entry entry : beanClasses.entrySet()) {
            AnnotatedTypeConfigurator config = atd.addAnnotatedType((Class)entry.getKey(), (String)ids.get(entry.getKey())).add((Annotation)SingletonLiteral.INSTANCE);
            for (AnnotationLiteral annotation : (Set)entry.getValue()) {
                config.add((Annotation)annotation);
            }
            MCPLogger.ROOT_LOGGER.info(((Class)entry.getKey()).getName() + " should be discoverable by CDI");
        }
    }

    private void updateAnnotations(Map<Class<?>, Set<AnnotationLiteral>> beanClasses, Class<?> clazz, AnnotationLiteral ... annotations) {
        if (!beanClasses.containsKey(clazz)) {
            beanClasses.put(clazz, new HashSet());
        }
        for (AnnotationLiteral annotation : annotations) {
            beanClasses.get(clazz).add(annotation);
        }
    }
}

