/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import java.util.HashSet;
import java.util.Set;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.messaging.activemq.MessagingServices;

class SecurityRoleRemove
extends AbstractRemoveStepHandler {
    static final SecurityRoleRemove INSTANCE = new SecurityRoleRemove();

    SecurityRoleRemove() {
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        ActiveMQServer server = SecurityRoleRemove.getServer(context, operation);
        String match = address.getElement(address.size() - 2).getValue();
        String roleName = address.getLastElement().getValue();
        SecurityRoleRemove.removeRole(server, match, roleName);
    }

    static void removeRole(ActiveMQServer server, String match, String roleName) {
        if (server != null) {
            Set roles = (Set)server.getSecurityRepository().getMatch(match);
            HashSet<Role> newRoles = new HashSet<Role>();
            for (Role role : roles) {
                if (roleName.equals(role.getName())) continue;
                newRoles.add(role);
            }
            server.getSecurityRepository().addMatch(match, newRoles);
        }
    }

    static ActiveMQServer getServer(OperationContext context, ModelNode operation) {
        ServiceName serviceName = MessagingServices.getActiveMQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address")));
        ServiceController controller = context.getServiceRegistry(true).getService(serviceName);
        if (controller != null) {
            return (ActiveMQServer)ActiveMQServer.class.cast(controller.getValue());
        }
        return null;
    }
}

