/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.shallow;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.messaging.activemq.shallow.OperationAddressConverter;

public class TranslatedOperationHandler
implements OperationStepHandler {
    private final OperationAddressConverter converter;

    public TranslatedOperationHandler(OperationAddressConverter converter) {
        this.converter = converter;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        PathAddress targetAddress = this.converter.convert(context, operation);
        ModelNode op = operation.clone();
        op.get("address").set(targetAddress.toModelNode());
        String operationName = op.require("operation").asString();
        OperationStepHandler operationHandler = context.getRootResourceRegistration().getOperationHandler(targetAddress, operationName);
        context.addStep(op, operationHandler, context.getCurrentStage(), true);
    }
}

