/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import io.netty.channel.Channel;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.ListenerRegistry;
import io.undertow.server.handlers.ChannelUpgradeHandler;
import io.undertow.server.handlers.HttpUpgradeHandshake;
import java.io.IOException;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyAcceptor;
import org.apache.activemq.artemis.core.remoting.server.RemotingService;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.jboss.as.remoting.HttpListenerRegistryService;
import org.jboss.as.remoting.SimpleHttpUpgradeHandshake;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.messaging.activemq.ActiveMQActivationService;
import org.wildfly.extension.messaging.activemq.MessagingServices;
import org.wildfly.extension.messaging.activemq.logging.MessagingLogger;
import org.xnio.ChannelListener;
import org.xnio.StreamConnection;
import org.xnio.netty.transport.WrappingXnioSocketChannel;

public class HTTPUpgradeService
implements Service<HTTPUpgradeService> {
    public static final ServiceName HTTP_UPGRADE_REGISTRY = ServiceName.JBOSS.append(new String[]{"http-upgrade-registry"});
    public static final ServiceName UPGRADE_SERVICE_NAME = MessagingServices.JBOSS_MESSAGING_ACTIVEMQ.append(new String[]{"http-upgrade-service"});
    private final String activeMQServerName;
    private final String acceptorName;
    private final String httpListenerName;
    private InjectedValue<ChannelUpgradeHandler> injectedRegistry = new InjectedValue();
    private InjectedValue<ListenerRegistry> listenerRegistry = new InjectedValue();
    private ListenerRegistry.HttpUpgradeMetadata httpUpgradeMetadata;

    public HTTPUpgradeService(String activeMQServerName, String acceptorName, String httpListenerName) {
        this.activeMQServerName = activeMQServerName;
        this.acceptorName = acceptorName;
        this.httpListenerName = httpListenerName;
    }

    public static void installService(ServiceTarget serviceTarget, String activeMQServerName, String acceptorName, String httpListenerName) {
        HTTPUpgradeService service = new HTTPUpgradeService(activeMQServerName, acceptorName, httpListenerName);
        serviceTarget.addService(UPGRADE_SERVICE_NAME.append(new String[]{acceptorName}), (Service)service).addDependency(HTTP_UPGRADE_REGISTRY.append(new String[]{httpListenerName}), ChannelUpgradeHandler.class, service.injectedRegistry).addDependency(HttpListenerRegistryService.SERVICE_NAME, ListenerRegistry.class, service.listenerRegistry).addDependency(ActiveMQActivationService.getServiceName(MessagingServices.getActiveMQServiceName(activeMQServerName))).setInitialMode(ServiceController.Mode.PASSIVE).install();
    }

    public void start(StartContext context) throws StartException {
        ListenerRegistry.Listener listenerInfo = ((ListenerRegistry)this.listenerRegistry.getValue()).getListener(this.httpListenerName);
        assert (listenerInfo != null);
        this.httpUpgradeMetadata = new ListenerRegistry.HttpUpgradeMetadata("activemq-remoting", "core");
        listenerInfo.addHttpUpgradeMetadata(this.httpUpgradeMetadata);
        MessagingLogger.ROOT_LOGGER.registeredHTTPUpgradeHandler("activemq-remoting", this.acceptorName);
        ServiceController activeMQService = context.getController().getServiceContainer().getService(MessagingServices.getActiveMQServiceName(this.activeMQServerName));
        ActiveMQServer activeMQServer = (ActiveMQServer)ActiveMQServer.class.cast(activeMQService.getValue());
        ((ChannelUpgradeHandler)this.injectedRegistry.getValue()).addProtocol("activemq-remoting", HTTPUpgradeService.switchToActiveMQCoreProtocol(activeMQServer, this.acceptorName), (HttpUpgradeHandshake)new SimpleHttpUpgradeHandshake("CF70DEB8-70F9-4FBA-8B4F-DFC3E723B4CD", "Sec-ActiveMQRemoting-Key", "Sec-ActiveMQRemoting-Accept"){

            public boolean handleUpgrade(HttpServerExchange exchange) throws IOException {
                if (super.handleUpgrade(exchange)) {
                    String endpoint = exchange.getRequestHeaders().getFirst("httpPpgradeEndpoint");
                    if (endpoint == null) {
                        return true;
                    }
                    return HTTPUpgradeService.this.acceptorName.equals(endpoint);
                }
                return false;
            }
        });
    }

    public void stop(StopContext context) {
        ((ListenerRegistry)this.listenerRegistry.getValue()).getListener(this.httpListenerName).removeHttpUpgradeMetadata(this.httpUpgradeMetadata);
        this.httpUpgradeMetadata = null;
        ((ChannelUpgradeHandler)this.injectedRegistry.getValue()).removeProtocol("activemq-remoting");
    }

    public HTTPUpgradeService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    private static ChannelListener<StreamConnection> switchToActiveMQCoreProtocol(final ActiveMQServer activeMQServer, final String acceptorName) {
        return new ChannelListener<StreamConnection>(){

            public void handleEvent(StreamConnection connection) {
                MessagingLogger.ROOT_LOGGER.debugf("Switching to %s protocol for %s http-acceptor", "activemq-remoting", acceptorName);
                WrappingXnioSocketChannel channel = new WrappingXnioSocketChannel(connection);
                RemotingService remotingService = activeMQServer.getRemotingService();
                NettyAcceptor acceptor = (NettyAcceptor)remotingService.getAcceptor(acceptorName);
                acceptor.transfer((Channel)channel);
                connection.getSourceChannel().resumeReads();
            }
        };
    }
}

