/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.jms;

import javax.jms.Queue;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.extension.messaging.activemq.BinderServiceUtil;
import org.wildfly.extension.messaging.activemq.CommonAttributes;
import org.wildfly.extension.messaging.activemq.MessagingServices;
import org.wildfly.extension.messaging.activemq.jms.JMSQueueDefinition;
import org.wildfly.extension.messaging.activemq.jms.JMSQueueService;
import org.wildfly.extension.messaging.activemq.jms.JMSServices;

public class JMSQueueAdd
extends AbstractAddStepHandler {
    public static final JMSQueueAdd INSTANCE = new JMSQueueAdd();

    private JMSQueueAdd() {
        super(JMSQueueDefinition.ATTRIBUTES);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        String[] jndiBindings;
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String name = address.getLastElement().getValue();
        ServiceTarget serviceTarget = context.getServiceTarget();
        ServiceName serviceName = MessagingServices.getActiveMQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address")));
        ModelNode selectorNode = CommonAttributes.SELECTOR.resolveModelAttribute(context, model);
        boolean durable = CommonAttributes.DURABLE.resolveModelAttribute(context, model).asBoolean();
        String selector = selectorNode.isDefined() ? selectorNode.asString() : null;
        Service<Queue> queueService = JMSQueueService.installService(name, serviceTarget, serviceName, selector, durable, new String[0]);
        ModelNode entries = CommonAttributes.DESTINATION_ENTRIES.resolveModelAttribute(context, model);
        ServiceName jmsQueueServiceName = JMSServices.getJmsQueueBaseServiceName(serviceName).append(new String[]{name});
        for (String jndiBinding : jndiBindings = JMSServices.getJndiBindings(entries)) {
            BinderServiceUtil.installBinderService(serviceTarget, jndiBinding, queueService, jmsQueueServiceName);
        }
    }
}

