/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.jms.bridge;

import java.util.Arrays;
import java.util.Collection;
import org.apache.activemq.artemis.jms.bridge.QualityOfServiceMode;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.PropertiesAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.messaging.activemq.CommonAttributes;
import org.wildfly.extension.messaging.activemq.MessagingExtension;
import org.wildfly.extension.messaging.activemq.jms.bridge.InfiniteOrPositiveValidators;
import org.wildfly.extension.messaging.activemq.jms.bridge.JMSBridgeAdd;
import org.wildfly.extension.messaging.activemq.jms.bridge.JMSBridgeHandler;
import org.wildfly.extension.messaging.activemq.jms.bridge.JMSBridgeRemove;
import org.wildfly.extension.messaging.activemq.jms.bridge.JMSBridgeWriteAttributeHandler;

public class JMSBridgeDefinition
extends PersistentResourceDefinition {
    public static final String PAUSE = "pause";
    public static final String RESUME = "resume";
    public static final SimpleAttributeDefinition MODULE = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"module", (ModelType)ModelType.STRING).setAllowNull(true)).build();
    public static final SimpleAttributeDefinition SOURCE_CONNECTION_FACTORY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"source-connection-factory", (ModelType)ModelType.STRING).setAttributeGroup("source")).setXmlName("connection-factory")).build();
    public static final SimpleAttributeDefinition SOURCE_DESTINATION = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"source-destination", (ModelType)ModelType.STRING).setAttributeGroup("source")).setXmlName("destination")).build();
    public static final SimpleAttributeDefinition SOURCE_USER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"source-user", (ModelType)ModelType.STRING).setAttributeGroup("source")).setXmlName("user")).setAllowNull(true)).setAllowExpression(true)).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.CREDENTIAL)).addAccessConstraint((AccessConstraintDefinition)MessagingExtension.MESSAGING_SECURITY_SENSITIVE_TARGET)).build();
    public static final SimpleAttributeDefinition SOURCE_PASSWORD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"source-password", (ModelType)ModelType.STRING).setAttributeGroup("source")).setXmlName("password")).setAllowNull(true)).setAllowExpression(true)).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.CREDENTIAL)).addAccessConstraint((AccessConstraintDefinition)MessagingExtension.MESSAGING_SECURITY_SENSITIVE_TARGET)).build();
    public static final PropertiesAttributeDefinition SOURCE_CONTEXT = ((PropertiesAttributeDefinition.Builder)((PropertiesAttributeDefinition.Builder)((PropertiesAttributeDefinition.Builder)new PropertiesAttributeDefinition.Builder("source-context", true).setAttributeGroup("source")).setWrapXmlElement(true).setWrapperElement("context").setXmlName("property")).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition TARGET_CONNECTION_FACTORY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"target-connection-factory", (ModelType)ModelType.STRING).setAttributeGroup("target")).setXmlName("connection-factory")).build();
    public static final SimpleAttributeDefinition TARGET_DESTINATION = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"target-destination", (ModelType)ModelType.STRING).setAttributeGroup("target")).setXmlName("destination")).build();
    public static final SimpleAttributeDefinition TARGET_USER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"target-user", (ModelType)ModelType.STRING).setAttributeGroup("target")).setXmlName("user")).setAllowNull(true)).setAllowExpression(true)).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.CREDENTIAL)).addAccessConstraint((AccessConstraintDefinition)MessagingExtension.MESSAGING_SECURITY_SENSITIVE_TARGET)).build();
    public static final SimpleAttributeDefinition TARGET_PASSWORD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"target-password", (ModelType)ModelType.STRING).setAttributeGroup("target")).setXmlName("password")).setAllowNull(true)).setAllowExpression(true)).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.CREDENTIAL)).addAccessConstraint((AccessConstraintDefinition)MessagingExtension.MESSAGING_SECURITY_SENSITIVE_TARGET)).build();
    public static final PropertiesAttributeDefinition TARGET_CONTEXT = ((PropertiesAttributeDefinition.Builder)((PropertiesAttributeDefinition.Builder)((PropertiesAttributeDefinition.Builder)new PropertiesAttributeDefinition.Builder("target-context", true).setAttributeGroup("target")).setWrapXmlElement(true).setWrapperElement("context").setXmlName("property")).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition QUALITY_OF_SERVICE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"quality-of-service", (ModelType)ModelType.STRING).setValidator((ParameterValidator)new EnumValidator(QualityOfServiceMode.class, false, false))).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition FAILURE_RETRY_INTERVAL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"failure-retry-interval", (ModelType)ModelType.LONG).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setValidator((ParameterValidator)InfiniteOrPositiveValidators.LONG_INSTANCE)).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition MAX_RETRIES = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"max-retries", (ModelType)ModelType.INT).setValidator((ParameterValidator)InfiniteOrPositiveValidators.INT_INSTANCE)).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition MAX_BATCH_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"max-batch-size", (ModelType)ModelType.INT).setValidator((ParameterValidator)new IntRangeValidator(0, Integer.MAX_VALUE, false, false))).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition MAX_BATCH_TIME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"max-batch-time", (ModelType)ModelType.LONG).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setValidator((ParameterValidator)InfiniteOrPositiveValidators.LONG_INSTANCE)).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition SUBSCRIPTION_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"subscription-name", (ModelType)ModelType.STRING).setAllowNull(true)).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition CLIENT_ID = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"client-id", (ModelType)ModelType.STRING).setAllowNull(true)).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition ADD_MESSAGE_ID_IN_HEADER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"add-messageID-in-header", (ModelType)ModelType.BOOLEAN).setAllowNull(true)).setDefaultValue(new ModelNode().set(false))).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition STARTED = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"started", (ModelType)ModelType.BOOLEAN).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME})).build();
    public static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{MODULE, QUALITY_OF_SERVICE, FAILURE_RETRY_INTERVAL, MAX_RETRIES, MAX_BATCH_SIZE, MAX_BATCH_TIME, CommonAttributes.SELECTOR, SUBSCRIPTION_NAME, CommonAttributes.CLIENT_ID, ADD_MESSAGE_ID_IN_HEADER, SOURCE_CONNECTION_FACTORY, SOURCE_DESTINATION, SOURCE_USER, SOURCE_PASSWORD, SOURCE_CONTEXT, TARGET_CONNECTION_FACTORY, TARGET_DESTINATION, TARGET_USER, TARGET_PASSWORD, TARGET_CONTEXT};
    public static final AttributeDefinition[] READONLY_ATTRIBUTES = new AttributeDefinition[]{STARTED, CommonAttributes.PAUSED};
    public static final String[] OPERATIONS = new String[]{"start", "stop", "pause", "resume"};
    public static final JMSBridgeDefinition INSTANCE = new JMSBridgeDefinition();

    private JMSBridgeDefinition() {
        super(MessagingExtension.JMS_BRIDGE_PATH, MessagingExtension.getResourceDescriptionResolver("jms-bridge"), (OperationStepHandler)JMSBridgeAdd.INSTANCE, (OperationStepHandler)JMSBridgeRemove.INSTANCE);
    }

    public Collection<AttributeDefinition> getAttributes() {
        return Arrays.asList(ATTRIBUTES);
    }

    public void registerAttributes(ManagementResourceRegistration registry) {
        for (AttributeDefinition attr : ATTRIBUTES) {
            registry.registerReadWriteAttribute(attr, null, (OperationStepHandler)JMSBridgeWriteAttributeHandler.INSTANCE);
        }
        for (AttributeDefinition attr : READONLY_ATTRIBUTES) {
            registry.registerReadOnlyAttribute(attr, (OperationStepHandler)JMSBridgeHandler.INSTANCE);
        }
    }

    public void registerOperations(ManagementResourceRegistration registry) {
        super.registerOperations(registry);
        for (String operationName : OPERATIONS) {
            registry.registerOperationHandler((OperationDefinition)new SimpleOperationDefinition(operationName, this.getResourceDescriptionResolver()), (OperationStepHandler)JMSBridgeHandler.INSTANCE);
        }
    }
}

