/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServer;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.BroadcastGroupConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.JournalType;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.security.plugins.SecurityDomainContext;
import org.jboss.as.security.service.SecurityDomainService;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.jgroups.spi.ChannelFactory;
import org.wildfly.clustering.jgroups.spi.service.ProtocolStackServiceName;
import org.wildfly.extension.messaging.activemq.ActiveMQServerResource;
import org.wildfly.extension.messaging.activemq.ActiveMQServerService;
import org.wildfly.extension.messaging.activemq.AddressSettingAdd;
import org.wildfly.extension.messaging.activemq.BridgeAdd;
import org.wildfly.extension.messaging.activemq.BroadcastGroupAdd;
import org.wildfly.extension.messaging.activemq.ClusterConnectionAdd;
import org.wildfly.extension.messaging.activemq.CommonAttributes;
import org.wildfly.extension.messaging.activemq.ConnectorServiceDefinition;
import org.wildfly.extension.messaging.activemq.DiscoveryGroupAdd;
import org.wildfly.extension.messaging.activemq.DivertAdd;
import org.wildfly.extension.messaging.activemq.GroupBindingService;
import org.wildfly.extension.messaging.activemq.GroupingHandlerAdd;
import org.wildfly.extension.messaging.activemq.HTTPAcceptorDefinition;
import org.wildfly.extension.messaging.activemq.HTTPUpgradeService;
import org.wildfly.extension.messaging.activemq.MessagingServices;
import org.wildfly.extension.messaging.activemq.PathDefinition;
import org.wildfly.extension.messaging.activemq.QueueAdd;
import org.wildfly.extension.messaging.activemq.SecurityRoleDefinition;
import org.wildfly.extension.messaging.activemq.ServerDefinition;
import org.wildfly.extension.messaging.activemq.TransportConfigOperationHandlers;
import org.wildfly.extension.messaging.activemq.ha.HAPolicyConfigurationBuilder;
import org.wildfly.extension.messaging.activemq.jms.JMSService;

class ServerAdd
extends AbstractAddStepHandler {
    static final String PATH_BASE = "paths";
    public static final ServerAdd INSTANCE = new ServerAdd();

    private ServerAdd() {
        super(ServerDefinition.ATTRIBUTES);
    }

    protected Resource createResource(OperationContext context) {
        ActiveMQServerResource resource = new ActiveMQServerResource();
        context.addResource(PathAddress.EMPTY_ADDRESS, (Resource)resource);
        return resource;
    }

    protected void recordCapabilitiesAndRequirements(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        super.recordCapabilitiesAndRequirements(context, operation, resource);
        context.registerCapability(ServerDefinition.ACTIVEMQ_SERVER_CAPABILITY.fromBaseCapability(context.getCurrentAddressValue()), null);
    }

    protected void populateModel(OperationContext context, ModelNode operation, final Resource resource) throws OperationFailedException {
        super.populateModel(context, operation, resource);
        if (context.isNormalServer()) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    ModelNode model = Resource.Tools.readModel((Resource)resource);
                    for (String path : PathDefinition.PATHS.keySet()) {
                        if (model.get("path").hasDefined(path)) continue;
                        PathAddress pathAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"path", (String)path)});
                        context.createResource(pathAddress);
                    }
                }
            }, OperationContext.Stage.MODEL);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, final Resource resource) throws OperationFailedException {
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                ServiceName groupBinding;
                String channelName;
                String jgroupsStack;
                String key;
                String name;
                ServiceTarget serviceTarget = context.getServiceTarget();
                String serverName = context.getCurrentAddressValue();
                ModelNode model = Resource.Tools.readModel((Resource)resource);
                Configuration configuration = ServerAdd.this.transformConfig(context, serverName, model);
                String bindingsPath = PathDefinition.PATHS.get("bindings-directory").resolveModelAttribute(context, model.get(new String[]{"path", "bindings-directory"})).asString();
                String bindingsRelativeToPath = PathDefinition.RELATIVE_TO.resolveModelAttribute(context, model.get(new String[]{"path", "bindings-directory"})).asString();
                String journalPath = PathDefinition.PATHS.get("journal-directory").resolveModelAttribute(context, model.get(new String[]{"path", "journal-directory"})).asString();
                String journalRelativeToPath = PathDefinition.RELATIVE_TO.resolveModelAttribute(context, model.get(new String[]{"path", "journal-directory"})).asString();
                String largeMessagePath = PathDefinition.PATHS.get("large-messages-directory").resolveModelAttribute(context, model.get(new String[]{"path", "large-messages-directory"})).asString();
                String largeMessageRelativeToPath = PathDefinition.RELATIVE_TO.resolveModelAttribute(context, model.get(new String[]{"path", "large-messages-directory"})).asString();
                String pagingPath = PathDefinition.PATHS.get("paging-directory").resolveModelAttribute(context, model.get(new String[]{"path", "paging-directory"})).asString();
                String pagingRelativeToPath = PathDefinition.RELATIVE_TO.resolveModelAttribute(context, model.get(new String[]{"path", "paging-directory"})).asString();
                ActiveMQServerService serverService = new ActiveMQServerService(configuration, new ActiveMQServerService.PathConfig(bindingsPath, bindingsRelativeToPath, journalPath, journalRelativeToPath, largeMessagePath, largeMessageRelativeToPath, pagingPath, pagingRelativeToPath));
                ServiceName activeMQServiceName = MessagingServices.getActiveMQServiceName(serverName);
                ServiceBuilder serviceBuilder = serviceTarget.addService(activeMQServiceName, (Service)serverService);
                if (context.hasOptionalCapability("org.wildfly.management.jmx", ServerDefinition.ACTIVEMQ_SERVER_CAPABILITY.getDynamicName(serverName), null)) {
                    ServiceName jmxCapability = context.getCapabilityServiceName("org.wildfly.management.jmx", MBeanServer.class);
                    serviceBuilder.addDependency(jmxCapability, MBeanServer.class, serverService.getMBeanServer());
                }
                serviceBuilder.addDependency(PathManagerService.SERVICE_NAME, PathManager.class, serverService.getPathManagerInjector());
                String domain = ServerDefinition.SECURITY_DOMAIN.resolveModelAttribute(context, model).asString();
                serviceBuilder.addDependency(ServiceBuilder.DependencyType.REQUIRED, SecurityDomainService.SERVICE_NAME.append(new String[]{domain}), SecurityDomainContext.class, serverService.getSecurityDomainContextInjector());
                HashSet<String> socketBindings = new HashSet<String>();
                TransportConfigOperationHandlers.processAcceptors(context, configuration, model, socketBindings);
                if (model.hasDefined("http-acceptor")) {
                    for (Property property : model.get("http-acceptor").asPropertyList()) {
                        String httpListener = HTTPAcceptorDefinition.HTTP_LISTENER.resolveModelAttribute(context, property.getValue()).asString();
                        serviceBuilder.addDependency(HTTPUpgradeService.HTTP_UPGRADE_REGISTRY.append(new String[]{httpListener}));
                    }
                }
                for (String string : socketBindings) {
                    ServiceName socketName = SocketBinding.JBOSS_BINDING_NAME.append(new String[]{string});
                    serviceBuilder.addDependency(socketName, SocketBinding.class, serverService.getSocketBindingInjector(string));
                }
                HashSet<String> outboundSocketBindings = new HashSet<String>();
                TransportConfigOperationHandlers.processConnectors(context, configuration, model, outboundSocketBindings);
                for (String outboundSocketBinding : outboundSocketBindings) {
                    ServiceName outboundSocketName = OutboundSocketBinding.OUTBOUND_SOCKET_BINDING_BASE_SERVICE_NAME.append(new String[]{outboundSocketBinding});
                    serviceBuilder.addDependency(ServiceBuilder.DependencyType.OPTIONAL, outboundSocketName, OutboundSocketBinding.class, serverService.getOutboundSocketBindingInjector(outboundSocketBinding));
                    if (socketBindings.contains(outboundSocketBinding)) continue;
                    ServiceName socketName = SocketBinding.JBOSS_BINDING_NAME.append(new String[]{outboundSocketBinding});
                    serviceBuilder.addDependency(ServiceBuilder.DependencyType.OPTIONAL, socketName, SocketBinding.class, serverService.getSocketBindingInjector(outboundSocketBinding));
                }
                BroadcastGroupAdd.addBroadcastGroupConfigs(context, configuration, model);
                List list = configuration.getBroadcastGroupConfigurations();
                Map discoveryGroupConfigurations = configuration.getDiscoveryGroupConfigurations();
                if (list != null) {
                    for (BroadcastGroupConfiguration config : list) {
                        name = config.getName();
                        key = "broadcast" + name;
                        ModelNode broadcastGroupModel = model.get(new String[]{"broadcast-group", name});
                        if (broadcastGroupModel.hasDefined(CommonAttributes.JGROUPS_STACK.getName())) {
                            jgroupsStack = CommonAttributes.JGROUPS_STACK.resolveModelAttribute(context, broadcastGroupModel).asString();
                            channelName = CommonAttributes.JGROUPS_CHANNEL.resolveModelAttribute(context, broadcastGroupModel).asString();
                            serviceBuilder.addDependency(ProtocolStackServiceName.CHANNEL_FACTORY.getServiceName(jgroupsStack), ChannelFactory.class, serverService.getJGroupsInjector(key));
                            serverService.getJGroupsChannels().put(key, channelName);
                            continue;
                        }
                        groupBinding = GroupBindingService.getBroadcastBaseServiceName(activeMQServiceName).append(new String[]{name});
                        serviceBuilder.addDependency(groupBinding, SocketBinding.class, serverService.getGroupBindingInjector(key));
                    }
                }
                if (discoveryGroupConfigurations != null) {
                    for (BroadcastGroupConfiguration config : discoveryGroupConfigurations.values()) {
                        name = config.getName();
                        key = "discovery" + name;
                        ModelNode discoveryGroupModel = model.get(new String[]{"discovery-group", name});
                        if (discoveryGroupModel.hasDefined(CommonAttributes.JGROUPS_STACK.getName())) {
                            jgroupsStack = CommonAttributes.JGROUPS_STACK.resolveModelAttribute(context, discoveryGroupModel).asString();
                            channelName = CommonAttributes.JGROUPS_CHANNEL.resolveModelAttribute(context, discoveryGroupModel).asString();
                            serviceBuilder.addDependency(ProtocolStackServiceName.CHANNEL_FACTORY.getServiceName(jgroupsStack), ChannelFactory.class, serverService.getJGroupsInjector(key));
                            serverService.getJGroupsChannels().put(key, channelName);
                            continue;
                        }
                        groupBinding = GroupBindingService.getDiscoveryBaseServiceName(activeMQServiceName).append(new String[]{name});
                        serviceBuilder.addDependency(groupBinding, SocketBinding.class, serverService.getGroupBindingInjector(key));
                    }
                }
                ServiceController activeMQServerServiceController = serviceBuilder.install();
                ((ActiveMQServerResource)resource).setActiveMQServerServiceController((ServiceController<ActiveMQServer>)activeMQServerServiceController);
                boolean overrideInVMSecurity = ServerDefinition.OVERRIDE_IN_VM_SECURITY.resolveModelAttribute(context, operation).asBoolean();
                JMSService.addService(serviceTarget, activeMQServiceName, overrideInVMSecurity);
                context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
            }
        }, OperationContext.Stage.RUNTIME);
    }

    private Configuration transformConfig(OperationContext context, String serverName, ModelNode model) throws OperationFailedException {
        ConfigurationImpl configuration = new ConfigurationImpl();
        configuration.setName(serverName);
        configuration.setEnabledAsyncConnectionExecution(ServerDefinition.ASYNC_CONNECTION_EXECUTION_ENABLED.resolveModelAttribute(context, model).asBoolean());
        configuration.setClusterPassword(ServerDefinition.CLUSTER_PASSWORD.resolveModelAttribute(context, model).asString());
        configuration.setClusterUser(ServerDefinition.CLUSTER_USER.resolveModelAttribute(context, model).asString());
        configuration.setConnectionTTLOverride((long)ServerDefinition.CONNECTION_TTL_OVERRIDE.resolveModelAttribute(context, model).asInt());
        configuration.setCreateBindingsDir(ServerDefinition.CREATE_BINDINGS_DIR.resolveModelAttribute(context, model).asBoolean());
        configuration.setCreateJournalDir(ServerDefinition.CREATE_JOURNAL_DIR.resolveModelAttribute(context, model).asBoolean());
        configuration.setIDCacheSize(ServerDefinition.ID_CACHE_SIZE.resolveModelAttribute(context, model).asInt());
        configuration.setJMXDomain(ServerDefinition.JMX_DOMAIN.resolveModelAttribute(context, model).asString());
        configuration.setJMXManagementEnabled(ServerDefinition.JMX_MANAGEMENT_ENABLED.resolveModelAttribute(context, model).asBoolean());
        JournalType journalType = JournalType.valueOf((String)ServerDefinition.JOURNAL_TYPE.resolveModelAttribute(context, model).asString());
        configuration.setJournalType(journalType);
        configuration.setJournalBufferSize_AIO(ServerDefinition.JOURNAL_BUFFER_SIZE.resolveModelAttribute(context, model).asInt(ActiveMQDefaultConfiguration.getDefaultJournalBufferSizeAio()));
        configuration.setJournalBufferTimeout_AIO(ServerDefinition.JOURNAL_BUFFER_TIMEOUT.resolveModelAttribute(context, model).asInt(ActiveMQDefaultConfiguration.getDefaultJournalBufferTimeoutAio()));
        configuration.setJournalMaxIO_AIO(ServerDefinition.JOURNAL_MAX_IO.resolveModelAttribute(context, model).asInt(ActiveMQDefaultConfiguration.getDefaultJournalMaxIoAio()));
        configuration.setJournalBufferSize_NIO(ServerDefinition.JOURNAL_BUFFER_SIZE.resolveModelAttribute(context, model).asInt(ActiveMQDefaultConfiguration.getDefaultJournalBufferSizeNio()));
        configuration.setJournalBufferTimeout_NIO(ServerDefinition.JOURNAL_BUFFER_TIMEOUT.resolveModelAttribute(context, model).asInt(ActiveMQDefaultConfiguration.getDefaultJournalBufferTimeoutNio()));
        configuration.setJournalMaxIO_NIO(ServerDefinition.JOURNAL_MAX_IO.resolveModelAttribute(context, model).asInt(ActiveMQDefaultConfiguration.getDefaultJournalMaxIoNio()));
        configuration.setJournalCompactMinFiles(ServerDefinition.JOURNAL_COMPACT_MIN_FILES.resolveModelAttribute(context, model).asInt());
        configuration.setJournalCompactPercentage(ServerDefinition.JOURNAL_COMPACT_PERCENTAGE.resolveModelAttribute(context, model).asInt());
        configuration.setJournalFileSize(ServerDefinition.JOURNAL_FILE_SIZE.resolveModelAttribute(context, model).asInt());
        configuration.setJournalMinFiles(ServerDefinition.JOURNAL_MIN_FILES.resolveModelAttribute(context, model).asInt());
        configuration.setJournalSyncNonTransactional(ServerDefinition.JOURNAL_SYNC_NON_TRANSACTIONAL.resolveModelAttribute(context, model).asBoolean());
        configuration.setJournalSyncTransactional(ServerDefinition.JOURNAL_SYNC_TRANSACTIONAL.resolveModelAttribute(context, model).asBoolean());
        configuration.setLogJournalWriteRate(ServerDefinition.LOG_JOURNAL_WRITE_RATE.resolveModelAttribute(context, model).asBoolean());
        configuration.setManagementAddress(SimpleString.toSimpleString((String)ServerDefinition.MANAGEMENT_ADDRESS.resolveModelAttribute(context, model).asString()));
        configuration.setManagementNotificationAddress(SimpleString.toSimpleString((String)ServerDefinition.MANAGEMENT_NOTIFICATION_ADDRESS.resolveModelAttribute(context, model).asString()));
        configuration.setMemoryMeasureInterval(ServerDefinition.MEMORY_MEASURE_INTERVAL.resolveModelAttribute(context, model).asLong());
        configuration.setMemoryWarningThreshold(ServerDefinition.MEMORY_WARNING_THRESHOLD.resolveModelAttribute(context, model).asInt());
        configuration.setMessageCounterEnabled(ServerDefinition.STATISTICS_ENABLED.resolveModelAttribute(context, model).asBoolean());
        configuration.setMessageCounterSamplePeriod((long)ServerDefinition.MESSAGE_COUNTER_SAMPLE_PERIOD.resolveModelAttribute(context, model).asInt());
        configuration.setMessageCounterMaxDayHistory(ServerDefinition.MESSAGE_COUNTER_MAX_DAY_HISTORY.resolveModelAttribute(context, model).asInt());
        configuration.setMessageExpiryScanPeriod(ServerDefinition.MESSAGE_EXPIRY_SCAN_PERIOD.resolveModelAttribute(context, model).asLong());
        configuration.setMessageExpiryThreadPriority(ServerDefinition.MESSAGE_EXPIRY_THREAD_PRIORITY.resolveModelAttribute(context, model).asInt());
        configuration.setJournalPerfBlastPages(ServerDefinition.PERF_BLAST_PAGES.resolveModelAttribute(context, model).asInt());
        configuration.setPersistDeliveryCountBeforeDelivery(ServerDefinition.PERSIST_DELIVERY_COUNT_BEFORE_DELIVERY.resolveModelAttribute(context, model).asBoolean());
        configuration.setPageMaxConcurrentIO(ServerDefinition.PAGE_MAX_CONCURRENT_IO.resolveModelAttribute(context, model).asInt());
        configuration.setPersistenceEnabled(ServerDefinition.PERSISTENCE_ENABLED.resolveModelAttribute(context, model).asBoolean());
        configuration.setPersistIDCache(ServerDefinition.PERSIST_ID_CACHE.resolveModelAttribute(context, model).asBoolean());
        configuration.setRunSyncSpeedTest(ServerDefinition.RUN_SYNC_SPEED_TEST.resolveModelAttribute(context, model).asBoolean());
        configuration.setScheduledThreadPoolMaxSize(ServerDefinition.SCHEDULED_THREAD_POOL_MAX_SIZE.resolveModelAttribute(context, model).asInt());
        configuration.setSecurityEnabled(ServerDefinition.SECURITY_ENABLED.resolveModelAttribute(context, model).asBoolean());
        configuration.setSecurityInvalidationInterval(ServerDefinition.SECURITY_INVALIDATION_INTERVAL.resolveModelAttribute(context, model).asLong());
        configuration.setServerDumpInterval(ServerDefinition.SERVER_DUMP_INTERVAL.resolveModelAttribute(context, model).asLong());
        configuration.setThreadPoolMaxSize(ServerDefinition.THREAD_POOL_MAX_SIZE.resolveModelAttribute(context, model).asInt());
        configuration.setTransactionTimeout(ServerDefinition.TRANSACTION_TIMEOUT.resolveModelAttribute(context, model).asLong());
        configuration.setTransactionTimeoutScanPeriod(ServerDefinition.TRANSACTION_TIMEOUT_SCAN_PERIOD.resolveModelAttribute(context, model).asLong());
        configuration.setWildcardRoutingEnabled(ServerDefinition.WILD_CARD_ROUTING_ENABLED.resolveModelAttribute(context, model).asBoolean());
        HAPolicyConfigurationBuilder.addHAPolicyConfiguration(context, (Configuration)configuration, model);
        ServerAdd.processAddressSettings(context, (Configuration)configuration, model);
        ServerAdd.processSecuritySettings(context, (Configuration)configuration, model);
        ServerAdd.processRemotingIncomingInterceptors(context, (Configuration)configuration, model);
        ServerAdd.processRemotingOutgoingInterceptors(context, (Configuration)configuration, model);
        GroupingHandlerAdd.addGroupingHandlerConfig(context, (Configuration)configuration, model);
        DiscoveryGroupAdd.addDiscoveryGroupConfigs(context, (Configuration)configuration, model);
        DivertAdd.addDivertConfigs(context, (Configuration)configuration, model);
        QueueAdd.addQueueConfigs(context, (Configuration)configuration, model);
        BridgeAdd.addBridgeConfigs(context, (Configuration)configuration, model);
        ClusterConnectionAdd.addClusterConnectionConfigs(context, (Configuration)configuration, model);
        ConnectorServiceDefinition.addConnectorServiceConfigs(context, (Configuration)configuration, model);
        return configuration;
    }

    static void processAddressSettings(OperationContext context, Configuration configuration, ModelNode params) throws OperationFailedException {
        if (params.hasDefined("address-setting")) {
            for (Property property : params.get("address-setting").asPropertyList()) {
                String match = property.getName();
                ModelNode config = property.getValue();
                AddressSettings settings = AddressSettingAdd.createSettings(context, config);
                configuration.getAddressesSettings().put(match, settings);
            }
        }
    }

    static void processRemotingIncomingInterceptors(OperationContext context, Configuration configuration, ModelNode params) {
        ModelNode interceptors = params.get(CommonAttributes.REMOTING_INCOMING_INTERCEPTORS.getName());
        if (interceptors.isDefined()) {
            ArrayList<String> interceptorClassNames = new ArrayList<String>();
            for (ModelNode child : interceptors.asList()) {
                interceptorClassNames.add(child.asString());
            }
            configuration.setIncomingInterceptorClassNames(interceptorClassNames);
        }
    }

    static void processRemotingOutgoingInterceptors(OperationContext context, Configuration configuration, ModelNode params) {
        ModelNode interceptors = params.get(CommonAttributes.REMOTING_OUTGOING_INTERCEPTORS.getName());
        if (interceptors.isDefined()) {
            ArrayList<String> interceptorClassNames = new ArrayList<String>();
            for (ModelNode child : interceptors.asList()) {
                interceptorClassNames.add(child.asString());
            }
            configuration.setOutgoingInterceptorClassNames(interceptorClassNames);
        }
    }

    static void processSecuritySettings(OperationContext context, Configuration configuration, ModelNode params) throws OperationFailedException {
        if (params.get("security-setting").isDefined()) {
            for (Property property : params.get("security-setting").asPropertyList()) {
                String match = property.getName();
                ModelNode config = property.getValue();
                if (!config.hasDefined("role")) continue;
                HashSet<Role> roles = new HashSet<Role>();
                for (Property role : config.get("role").asPropertyList()) {
                    roles.add(SecurityRoleDefinition.transform(context, role.getName(), role.getValue()));
                }
                configuration.getSecurityRoles().put(match, roles);
            }
        }
    }
}

