package org.wildfly.extension.messaging.activemq.logging;

import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.modules.ModuleLoadException;
import java.lang.IllegalStateException;
import java.io.Serializable;
import java.util.Set;
import org.jboss.logging.DelegatingBasicLogger;
import java.lang.String;
import org.jboss.logging.Logger;
import org.jboss.as.controller.RunningMode;
import java.lang.RuntimeException;
import org.jboss.as.controller.PathElement;
import org.jboss.logging.BasicLogger;
import org.jboss.msc.service.StartException;
import java.lang.IllegalArgumentException;
import java.lang.UnsupportedOperationException;
import javax.annotation.Generated;
import org.jboss.as.controller.OperationFailedException;
import javax.jms.IllegalStateRuntimeException;
import javax.xml.stream.XMLStreamException;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceController.State;
import org.jboss.as.controller.PathAddress;
import java.lang.Throwable;
import org.jboss.dmr.ModelType;
import java.util.Collection;
import java.lang.Object;
import org.jboss.as.controller.ModelVersion;
import java.util.Arrays;
import org.jboss.dmr.ModelNode;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2016-07-28T00:59:00-0500")
public class MessagingLogger_$logger extends DelegatingBasicLogger implements MessagingLogger,BasicLogger,Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = MessagingLogger_$logger.class.getName();
    public MessagingLogger_$logger(final Logger log) {
        super(log);
    }
    @Override
    public final void aioInfo() {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.INFO, null, aioInfo$str());
    }
    private static final String aioInfo = "WFLYMSGAMQ0001: AIO wasn't located on this platform, it will fall back to using pure Java NIO.";
    protected String aioInfo$str() {
        return aioInfo;
    }
    @Override
    public final void boundJndiName(final String jndiName) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.INFO, null, boundJndiName$str(), jndiName);
    }
    private static final String boundJndiName = "WFLYMSGAMQ0002: Bound messaging object to jndi name %s";
    protected String boundJndiName$str() {
        return boundJndiName;
    }
    @Override
    public final void errorStoppingJmsServer(final Throwable cause) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.ERROR, cause, errorStoppingJmsServer$str());
    }
    private static final String errorStoppingJmsServer = "WFLYMSGAMQ0003: Exception while stopping JMS server";
    protected String errorStoppingJmsServer$str() {
        return errorStoppingJmsServer;
    }
    @Override
    public final void failedToDestroy(final Throwable cause, final String description, final String name) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, cause, failedToDestroy$str(), description, name);
    }
    private static final String failedToDestroy = "WFLYMSGAMQ0004: Failed to destroy %s: %s";
    protected String failedToDestroy$str() {
        return failedToDestroy;
    }
    @Override
    public final void failedToDestroy(final String description, final String name) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, null, failedToDestroy$str(), description, name);
    }
    @Override
    public final void revertOperationFailed(final Throwable cause, final String className, final String operation, final PathAddress address) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.ERROR, cause, revertOperationFailed$str(), className, operation, address);
    }
    private static final String revertOperationFailed = "WFLYMSGAMQ0005: %s caught exception attempting to revert operation %s at address %s";
    protected String revertOperationFailed$str() {
        return revertOperationFailed;
    }
    @Override
    public final void unboundJndiName(final String jndiName) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.INFO, null, unboundJndiName$str(), jndiName);
    }
    private static final String unboundJndiName = "WFLYMSGAMQ0006: Unbound messaging object to jndi name %s";
    protected String unboundJndiName$str() {
        return unboundJndiName;
    }
    @Override
    public final void couldNotCloseFile(final String file, final Throwable cause) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.ERROR, cause, couldNotCloseFile$str(), file);
    }
    private static final String couldNotCloseFile = "WFLYMSGAMQ0007: Could not close file %s";
    protected String couldNotCloseFile$str() {
        return couldNotCloseFile;
    }
    @Override
    public final void failedToUnbindJndiName(final String jndiName, final long timeout, final String timeUnit) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, null, failedToUnbindJndiName$str(), jndiName, timeout, timeUnit);
    }
    private static final String failedToUnbindJndiName = "WFLYMSGAMQ0008: Failed to unbind messaging object bound to jndi name %s in %d %s";
    protected String failedToUnbindJndiName$str() {
        return failedToUnbindJndiName;
    }
    @Override
    public final void deprecatedXMLElement(final String name) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, null, deprecatedXMLElement1$str(), name);
    }
    private static final String deprecatedXMLElement1 = "WFLYMSGAMQ0009: Element %s is deprecated and will not be taken into account";
    protected String deprecatedXMLElement1$str() {
        return deprecatedXMLElement1;
    }
    @Override
    public final void deprecatedXMLAttribute(final String name) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, null, deprecatedXMLAttribute$str(), name);
    }
    private static final String deprecatedXMLAttribute = "WFLYMSGAMQ0010: Attribute %s is deprecated and will not be taken into account";
    protected String deprecatedXMLAttribute$str() {
        return deprecatedXMLAttribute;
    }
    @Override
    public final void startedService(final String type, final String name) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.INFO, null, startedService$str(), type, name);
    }
    private static final String startedService = "WFLYMSGAMQ0011: Started %s %s";
    protected String startedService$str() {
        return startedService;
    }
    @Override
    public final void stoppedService(final String type, final String name) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.INFO, null, stoppedService$str(), type, name);
    }
    private static final String stoppedService = "WFLYMSGAMQ0012: Stopped %s %s";
    protected String stoppedService$str() {
        return stoppedService;
    }
    @Override
    public final void deprecatedAttribute(final String name, final PathAddress address) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, null, deprecatedAttribute$str(), name, address);
    }
    private static final String deprecatedAttribute = "WFLYMSGAMQ0013: Attribute %s of the resource at %s is deprecated and setting its value will not be taken into account";
    protected String deprecatedAttribute$str() {
        return deprecatedAttribute;
    }
    private static final String canNotChangeClusteredAttribute = "WFLYMSGAMQ0014: Can not change the clustered attribute to false: The server resource at %s has cluster-connection children resources and will remain clustered.";
    protected String canNotChangeClusteredAttribute$str() {
        return canNotChangeClusteredAttribute;
    }
    @Override
    public final String canNotChangeClusteredAttribute(final PathAddress address) {
        return String.format(canNotChangeClusteredAttribute$str(), address);
    }
    @Override
    public final void unknownPooledConnectionFactoryAttribute(final String name) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, null, unknownPooledConnectionFactoryAttribute$str(), name);
    }
    private static final String unknownPooledConnectionFactoryAttribute = "WFLYMSGAMQ0015: Ignoring %s property that is not a known property for pooled connection factory.";
    protected String unknownPooledConnectionFactoryAttribute$str() {
        return unknownPooledConnectionFactoryAttribute;
    }
    @Override
    public final void registeredHTTPUpgradeHandler(final String name, final String acceptor) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.INFO, null, registeredHTTPUpgradeHandler$str(), name, acceptor);
    }
    private static final String registeredHTTPUpgradeHandler = "WFLYMSGAMQ0016: Registered HTTP upgrade for %s protocol handled by %s acceptor";
    protected String registeredHTTPUpgradeHandler$str() {
        return registeredHTTPUpgradeHandler;
    }
    @Override
    public final void deprecatedXMLElement(final String name, final String replacement) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, null, deprecatedXMLElement2$str(), name, replacement);
    }
    private static final String deprecatedXMLElement2 = "WFLYMSGAMQ0017: Element %s is deprecated and %s will be used in its place";
    protected String deprecatedXMLElement2$str() {
        return deprecatedXMLElement2;
    }
    @Override
    public final void connectorForPooledConnectionFactory(final String name, final String connectorName) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, null, connectorForPooledConnectionFactory$str(), name, connectorName);
    }
    private static final String connectorForPooledConnectionFactory = "WFLYMSGAMQ0018: No connectors were explicitly defined for the pooled connection factory %s. Using %s as the connector.";
    protected String connectorForPooledConnectionFactory$str() {
        return connectorForPooledConnectionFactory;
    }
    private static final String altAttributeAlreadyDefined = "WFLYMSGAMQ0019: Alternative attribute of (%s) is already defined.";
    protected String altAttributeAlreadyDefined$str() {
        return altAttributeAlreadyDefined;
    }
    @Override
    public final String altAttributeAlreadyDefined(final String name) {
        return String.format(altAttributeAlreadyDefined$str(), name);
    }
    private static final String attributeDefinitionsMustMatch = "WFLYMSGAMQ0020: All attribute definitions must have the same xml name -- found %s but already had %s";
    protected String attributeDefinitionsMustMatch$str() {
        return attributeDefinitionsMustMatch;
    }
    @Override
    public final IllegalArgumentException attributeDefinitionsMustMatch(final String nameFound, final String nameRequired) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(attributeDefinitionsMustMatch$str(), nameFound, nameRequired));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String attributeDefinitionsNotUnique = "WFLYMSGAMQ0021: All attribute definitions must have unique names -- already found %s";
    protected String attributeDefinitionsNotUnique$str() {
        return attributeDefinitionsNotUnique;
    }
    @Override
    public final IllegalArgumentException attributeDefinitionsNotUnique(final String nameFound) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(attributeDefinitionsNotUnique$str(), nameFound));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotBindJndiName = "WFLYMSGAMQ0022: Cannot bind a null or empty string as jndi name";
    protected String cannotBindJndiName$str() {
        return cannotBindJndiName;
    }
    @Override
    public final IllegalArgumentException cannotBindJndiName() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(cannotBindJndiName$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotIncludeOperationParameters = "WFLYMSGAMQ0023: Operation cannot include both parameter %s and parameter %s";
    protected String cannotIncludeOperationParameters$str() {
        return cannotIncludeOperationParameters;
    }
    @Override
    public final String cannotIncludeOperationParameters(final String paramName1, final String paramName2) {
        return String.format(cannotIncludeOperationParameters$str(), paramName1, paramName2);
    }
    private static final String cannotMarshalAttribute = "WFLYMSGAMQ0024: %s cannot be marshalled as an attribute; use marshallAsElement";
    protected String cannotMarshalAttribute$str() {
        return cannotMarshalAttribute;
    }
    @Override
    public final UnsupportedOperationException cannotMarshalAttribute(final String name) {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(cannotMarshalAttribute$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotUnbindJndiName = "WFLYMSGAMQ0025: Cannot unbind a null or empty string as jndi name";
    protected String cannotUnbindJndiName$str() {
        return cannotUnbindJndiName;
    }
    @Override
    public final IllegalArgumentException cannotUnbindJndiName() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(cannotUnbindJndiName$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String childResourceAlreadyExists = "WFLYMSGAMQ0026: A child resource of type %1$s already exists; the messaging subsystem only allows a single resource of type %1$s";
    protected String childResourceAlreadyExists$str() {
        return childResourceAlreadyExists;
    }
    @Override
    public final String childResourceAlreadyExists(final String type) {
        return String.format(childResourceAlreadyExists$str(), type);
    }
    private static final String connectorNotDefined = "WFLYMSGAMQ0027: Connector %s not defined";
    protected String connectorNotDefined$str() {
        return connectorNotDefined;
    }
    @Override
    public final IllegalStateException connectorNotDefined(final String connectorName) {
        final IllegalStateException result = new IllegalStateException(String.format(connectorNotDefined$str(), connectorName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToCreate = "WFLYMSGAMQ0028: Failed to create %s";
    protected String failedToCreate$str() {
        return failedToCreate;
    }
    @Override
    public final StartException failedToCreate(final Throwable cause, final String name) {
        final StartException result = new StartException(String.format(failedToCreate$str(), name), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToFindBroadcastSocketBinding = "WFLYMSGAMQ0029: Failed to find SocketBinding for broadcast binding: %s";
    protected String failedToFindBroadcastSocketBinding$str() {
        return failedToFindBroadcastSocketBinding;
    }
    @Override
    public final StartException failedToFindBroadcastSocketBinding(final String name) {
        final StartException result = new StartException(String.format(failedToFindBroadcastSocketBinding$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToFindConnectorSocketBinding = "WFLYMSGAMQ0030: Failed to find SocketBinding for connector: %s";
    protected String failedToFindConnectorSocketBinding$str() {
        return failedToFindConnectorSocketBinding;
    }
    @Override
    public final StartException failedToFindConnectorSocketBinding(final String name) {
        final StartException result = new StartException(String.format(failedToFindConnectorSocketBinding$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToFindDiscoverySocketBinding = "WFLYMSGAMQ0031: Failed to find SocketBinding for discovery binding: %s";
    protected String failedToFindDiscoverySocketBinding$str() {
        return failedToFindDiscoverySocketBinding;
    }
    @Override
    public final StartException failedToFindDiscoverySocketBinding(final String name) {
        final StartException result = new StartException(String.format(failedToFindDiscoverySocketBinding$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToShutdownServer = "WFLYMSGAMQ0032: Failed to shutdown %s server";
    protected String failedToShutdownServer$str() {
        return failedToShutdownServer;
    }
    @Override
    public final RuntimeException failedToShutdownServer(final Throwable cause, final String server) {
        final RuntimeException result = new RuntimeException(String.format(failedToShutdownServer$str(), server), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToStartService = "WFLYMSGAMQ0033: Failed to start service";
    protected String failedToStartService$str() {
        return failedToStartService;
    }
    @Override
    public final StartException failedToStartService(final Throwable cause) {
        final StartException result = new StartException(String.format(failedToStartService$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String ignoringUnhandledElement = "WFLYMSGAMQ0034: Ignoring unhandled element: %s, at: %s";
    protected String ignoringUnhandledElement$str() {
        return ignoringUnhandledElement;
    }
    @Override
    public final XMLStreamException ignoringUnhandledElement(final String element, final String location) {
        final XMLStreamException result = new XMLStreamException(String.format(ignoringUnhandledElement$str(), element, location));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String illegalElement = "WFLYMSGAMQ0035: Illegal element %s: cannot be used when %s is used";
    protected String illegalElement$str() {
        return illegalElement;
    }
    @Override
    public final String illegalElement(final String illegalElement, final String element) {
        return String.format(illegalElement$str(), illegalElement, element);
    }
    private static final String illegalValue2 = "WFLYMSGAMQ0036: Illegal value %s for element %s";
    protected String illegalValue2$str() {
        return illegalValue2;
    }
    @Override
    public final String illegalValue(final Object value, final String element) {
        return String.format(illegalValue2$str(), value, element);
    }
    private static final String illegalValue3 = "WFLYMSGAMQ0036: Illegal value %s for element %s as it could not be converted to required type %s";
    protected String illegalValue3$str() {
        return illegalValue3;
    }
    @Override
    public final String illegalValue(final Object value, final String element, final ModelType expectedType) {
        return String.format(illegalValue3$str(), value, element, expectedType);
    }
    private static final String immutableResource = "WFLYMSGAMQ0037: Resource is immutable";
    protected String immutableResource$str() {
        return immutableResource;
    }
    @Override
    public final UnsupportedOperationException immutableResource() {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(immutableResource$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalid = "WFLYMSGAMQ0038: %s is invalid";
    protected String invalid$str() {
        return invalid;
    }
    @Override
    public final String invalid(final Object obj) {
        return String.format(invalid$str(), obj);
    }
    private static final String invalidAttributeType = "WFLYMSGAMQ0039: Attribute %s has unexpected type %s";
    protected String invalidAttributeType$str() {
        return invalidAttributeType;
    }
    @Override
    public final IllegalStateException invalidAttributeType(final String name, final ModelType type) {
        final IllegalStateException result = new IllegalStateException(String.format(invalidAttributeType$str(), name, type));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidOperationParameters = "WFLYMSGAMQ0040: Operation must include parameter %s or parameter %s";
    protected String invalidOperationParameters$str() {
        return invalidOperationParameters;
    }
    @Override
    public final String invalidOperationParameters(final String paramName1, final String paramName2) {
        return String.format(invalidOperationParameters$str(), paramName1, paramName2);
    }
    private static final String invalidParameterValue = "WFLYMSGAMQ0041: %s is an invalid value for parameter %s. Values must be one of: %s";
    protected String invalidParameterValue$str() {
        return invalidParameterValue;
    }
    @Override
    public final String invalidParameterValue(final Object value, final String name, final Collection<? extends Object> allowedValues) {
        return String.format(invalidParameterValue$str(), value, name, allowedValues);
    }
    private static final String invalidServiceState = "WFLYMSGAMQ0042: Service %s is not in state %s, it is in state %s";
    protected String invalidServiceState$str() {
        return invalidServiceState;
    }
    @Override
    public final IllegalStateException invalidServiceState(final ServiceName service, final State validState, final State currentState) {
        final IllegalStateException result = new IllegalStateException(String.format(invalidServiceState$str(), service, validState, currentState));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String jndiNameAlreadyRegistered = "WFLYMSGAMQ0043: JNDI name %s is already registered";
    protected String jndiNameAlreadyRegistered$str() {
        return jndiNameAlreadyRegistered;
    }
    @Override
    public final String jndiNameAlreadyRegistered(final String jndiName) {
        return String.format(jndiNameAlreadyRegistered$str(), jndiName);
    }
    private static final String multipleChildrenFound = "WFLYMSGAMQ0044: Multiple %s children found; only one is allowed";
    protected String multipleChildrenFound$str() {
        return multipleChildrenFound;
    }
    @Override
    public final IllegalStateException multipleChildrenFound(final String element) {
        final IllegalStateException result = new IllegalStateException(String.format(multipleChildrenFound$str(), element));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String required1 = "WFLYMSGAMQ0045: %s is required";
    protected String required1$str() {
        return required1;
    }
    @Override
    public final String required(final Object obj) {
        return String.format(required1$str(), obj);
    }
    private static final String required2 = "WFLYMSGAMQ0046: Either %s or %s is required";
    protected String required2$str() {
        return required2;
    }
    @Override
    public final String required(final Object obj1, final Object obj2) {
        return String.format(required2$str(), obj1, obj2);
    }
    private static final String nullVar = "WFLYMSGAMQ0047: %s is null";
    protected String nullVar$str() {
        return nullVar;
    }
    @Override
    public final IllegalArgumentException nullVar(final String varName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(nullVar$str(), varName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String parameterNotDefined = "WFLYMSGAMQ0048: Parameter not defined: %s";
    protected String parameterNotDefined$str() {
        return parameterNotDefined;
    }
    @Override
    public final String parameterNotDefined(final Object parameter) {
        return String.format(parameterNotDefined$str(), parameter);
    }
    private static final String unknownAttribute = "WFLYMSGAMQ0049: No such attribute (%s)";
    protected String unknownAttribute$str() {
        return unknownAttribute;
    }
    @Override
    public final String unknownAttribute(final String name) {
        return String.format(unknownAttribute$str(), name);
    }
    private static final String unsupportedAttribute = "WFLYMSGAMQ0050: Read support for attribute %s was not properly implemented";
    protected String unsupportedAttribute$str() {
        return unsupportedAttribute;
    }
    @Override
    public final IllegalStateException unsupportedAttribute(final String name) {
        final IllegalStateException result = new IllegalStateException(String.format(unsupportedAttribute$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unsupportedElement = "WFLYMSGAMQ0051: Implement support for element %s";
    protected String unsupportedElement$str() {
        return unsupportedElement;
    }
    @Override
    public final UnsupportedOperationException unsupportedElement(final String name) {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(unsupportedElement$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unsupportedOperation = "WFLYMSGAMQ0052: Support for operation %s was not properly implemented";
    protected String unsupportedOperation$str() {
        return unsupportedOperation;
    }
    @Override
    public final IllegalStateException unsupportedOperation(final String name) {
        final IllegalStateException result = new IllegalStateException(String.format(unsupportedOperation$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unsupportedRuntimeAttribute = "WFLYMSGAMQ0053: Runtime handling for %s is not implemented";
    protected String unsupportedRuntimeAttribute$str() {
        return unsupportedRuntimeAttribute;
    }
    @Override
    public final UnsupportedOperationException unsupportedRuntimeAttribute(final String name) {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(unsupportedRuntimeAttribute$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String activeMQServerNotInstalled = "WFLYMSGAMQ0054: No ActiveMQ Server is available under name %s";
    protected String activeMQServerNotInstalled$str() {
        return activeMQServerNotInstalled;
    }
    @Override
    public final OperationFailedException activeMQServerNotInstalled(final String name) {
        final OperationFailedException result = new OperationFailedException(String.format(activeMQServerNotInstalled$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotParseDeployment = "WFLYMSGAMQ0055: Could not parse file %s";
    protected String couldNotParseDeployment$str() {
        return couldNotParseDeployment;
    }
    @Override
    public final DeploymentUnitProcessingException couldNotParseDeployment(final String file, final Throwable cause) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(couldNotParseDeployment$str(), file), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String operationNotValid = "WFLYMSGAMQ0056: Handler cannot handle operation %s";
    protected String operationNotValid$str() {
        return operationNotValid;
    }
    @Override
    public final IllegalStateException operationNotValid(final String operation) {
        final IllegalStateException result = new IllegalStateException(String.format(operationNotValid$str(), operation));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noDestinationRegisteredForAddress = "WFLYMSGAMQ0057: No message destination registered at address %s";
    protected String noDestinationRegisteredForAddress$str() {
        return noDestinationRegisteredForAddress;
    }
    @Override
    public final String noDestinationRegisteredForAddress(final PathAddress address) {
        return String.format(noDestinationRegisteredForAddress$str(), address);
    }
    private static final String securityDomainContextNotSet = "WFLYMSGAMQ0058: SecurityDomainContext has not been set";
    protected String securityDomainContextNotSet$str() {
        return securityDomainContextNotSet;
    }
    @Override
    public final IllegalStateException securityDomainContextNotSet() {
        final IllegalStateException result = new IllegalStateException(String.format(securityDomainContextNotSet$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String onlyOneRequired = "WFLYMSGAMQ0059: Only one of %s or %s is required";
    protected String onlyOneRequired$str() {
        return onlyOneRequired;
    }
    @Override
    public final String onlyOneRequired(final Object obj1, final Object obj2) {
        return String.format(onlyOneRequired$str(), obj1, obj2);
    }
    private static final String failedToRecover = "WFLYMSGAMQ0060: Failed to recover %s";
    protected String failedToRecover$str() {
        return failedToRecover;
    }
    @Override
    public final OperationFailedException failedToRecover(final Throwable cause, final String name) {
        final OperationFailedException result = new OperationFailedException(String.format(failedToRecover$str(), name), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unsupportedAttributeInVersion = "WFLYMSGAMQ0061: Attribute(s) %s are not supported by messaging management model %s";
    protected String unsupportedAttributeInVersion$str() {
        return unsupportedAttributeInVersion;
    }
    @Override
    public final String unsupportedAttributeInVersion(final String attributes, final ModelVersion version) {
        return String.format(unsupportedAttributeInVersion$str(), attributes, version);
    }
    private static final String canNotWriteClusteredAttribute = "WFLYMSGAMQ0062: The clustered attribute is deprecated. To create a clustered ActiveMQ server, define at least one cluster-connection";
    protected String canNotWriteClusteredAttribute$str() {
        return canNotWriteClusteredAttribute;
    }
    @Override
    public final UnsupportedOperationException canNotWriteClusteredAttribute() {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(canNotWriteClusteredAttribute$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String canNotRegisterResourceOfType = "WFLYMSGAMQ0063: Resources of type %s cannot be registered";
    protected String canNotRegisterResourceOfType$str() {
        return canNotRegisterResourceOfType;
    }
    @Override
    public final UnsupportedOperationException canNotRegisterResourceOfType(final String childType) {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(canNotRegisterResourceOfType$str(), childType));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String canNotRemoveResourceOfType = "WFLYMSGAMQ0064: Resources of type %s cannot be removed";
    protected String canNotRemoveResourceOfType$str() {
        return canNotRemoveResourceOfType;
    }
    @Override
    public final UnsupportedOperationException canNotRemoveResourceOfType(final String childType) {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(canNotRemoveResourceOfType$str(), childType));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String serverInBackupMode = "WFLYMSGAMQ0066: Resource at the address %s can not be managed, the server is in backup mode";
    protected String serverInBackupMode$str() {
        return serverInBackupMode;
    }
    @Override
    public final String serverInBackupMode(final PathAddress address) {
        return String.format(serverInBackupMode$str(), address);
    }
    private static final String wrongConnectorRefInBroadCastGroup = "WFLYMSGAMQ0067: The broadcast group '%s' defines reference to nonexistent connector '%s'. Available connectors '%s'.";
    protected String wrongConnectorRefInBroadCastGroup$str() {
        return wrongConnectorRefInBroadCastGroup;
    }
    @Override
    public final OperationFailedException wrongConnectorRefInBroadCastGroup(final String bgName, final String connectorRef, final Collection<String> presentConnectors) {
        final OperationFailedException result = new OperationFailedException(String.format(wrongConnectorRefInBroadCastGroup$str(), bgName, connectorRef, presentConnectors));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String callNotPermittedOnInjectedJMSContext = "WFLYMSGAMQ0068: It is not permitted to call this method on injected JMSContext (see JMS 2.0 spec, §12.4.5).";
    protected String callNotPermittedOnInjectedJMSContext$str() {
        return callNotPermittedOnInjectedJMSContext;
    }
    @Override
    public final IllegalStateRuntimeException callNotPermittedOnInjectedJMSContext() {
        final IllegalStateRuntimeException result = new IllegalStateRuntimeException(String.format(callNotPermittedOnInjectedJMSContext$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String undefineAttributeWithoutAlternative = "WFLYMSGAMQ0069: Attribute (%s) can not been undefined as the resource does not define any alternative to this attribute.";
    protected String undefineAttributeWithoutAlternative$str() {
        return undefineAttributeWithoutAlternative;
    }
    @Override
    public final String undefineAttributeWithoutAlternative(final String name) {
        return String.format(undefineAttributeWithoutAlternative$str(), name);
    }
    private static final String inconsistentStatisticsSettings = "WFLYMSGAMQ0070: Attributes %s is an alias for attribute %s; both cannot be set with conflicting values.";
    protected String inconsistentStatisticsSettings$str() {
        return inconsistentStatisticsSettings;
    }
    @Override
    public final OperationFailedException inconsistentStatisticsSettings(final String attrOne, final String attrTwo) {
        final OperationFailedException result = new OperationFailedException(String.format(inconsistentStatisticsSettings$str(), attrOne, attrTwo));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void noMatchingExpiryAddress(final String address, final String addressSettings) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, null, noMatchingExpiryAddress$str(), address, addressSettings);
    }
    private static final String noMatchingExpiryAddress = "WFLYMSGAMQ0071: There is no resource matching the expiry-address %s for the address-settings %s, expired messages from destinations matching this address-setting will be lost!";
    protected String noMatchingExpiryAddress$str() {
        return noMatchingExpiryAddress;
    }
    @Override
    public final void noMatchingDeadLetterAddress(final String address, final String addressSettings) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, null, noMatchingDeadLetterAddress$str(), address, addressSettings);
    }
    private static final String noMatchingDeadLetterAddress = "WFLYMSGAMQ0072: There is no resource matching the dead-letter-address %s for the address-settings %s, undelivered messages from destinations matching this address-setting will be lost!";
    protected String noMatchingDeadLetterAddress$str() {
        return noMatchingDeadLetterAddress;
    }
    private static final String canNotRemoveLastJNDIName = "WFLYMSGAMQ0073: Can not remove JNDI name %s. The resource must have at least one JNDI name";
    protected String canNotRemoveLastJNDIName$str() {
        return canNotRemoveLastJNDIName;
    }
    @Override
    public final String canNotRemoveLastJNDIName(final String jndiName) {
        return String.format(canNotRemoveLastJNDIName$str(), jndiName);
    }
    private static final String invalidParameterName = "WFLYMSGAMQ0074: Invalid parameter key: %s, the allowed keys are %s.";
    protected String invalidParameterName$str() {
        return invalidParameterName;
    }
    @Override
    public final OperationFailedException invalidParameterName(final String parameterName, final Set<String> allowedKeys) {
        final OperationFailedException result = new OperationFailedException(String.format(invalidParameterName$str(), parameterName, allowedKeys));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void aioInfoLinux() {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.INFO, null, aioInfoLinux$str());
    }
    private static final String aioInfoLinux = "WFLYMSGAMQ0075: AIO wasn't located on this platform, it will fall back to using pure Java NIO. Your platform is Linux, install LibAIO to enable the AIO journal and achieve optimal performance.";
    protected String aioInfoLinux$str() {
        return aioInfoLinux;
    }
    private static final String duplicateElements = "WFLYMSGAMQ0076: Parameter %s contains duplicate elements [%s]";
    protected String duplicateElements$str() {
        return duplicateElements;
    }
    @Override
    public final OperationFailedException duplicateElements(final String parameterName, final ModelNode elements) {
        final OperationFailedException result = new OperationFailedException(String.format(duplicateElements$str(), parameterName, elements));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String canNotRemoveUnknownEntry = "WFLYMSGAMQ0077: Can not remove unknown entry %s";
    protected String canNotRemoveUnknownEntry$str() {
        return canNotRemoveUnknownEntry;
    }
    @Override
    public final OperationFailedException canNotRemoveUnknownEntry(final String entry) {
        final OperationFailedException result = new OperationFailedException(String.format(canNotRemoveUnknownEntry$str(), entry));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String onlyOneChildIsAllowed = "WFLYMSGAMQ0078: Only one %s child resource is allowed, found children: %s";
    protected String onlyOneChildIsAllowed$str() {
        return onlyOneChildIsAllowed;
    }
    @Override
    public final OperationFailedException onlyOneChildIsAllowed(final String childType, final Set<String> childrenNames) {
        final OperationFailedException result = new OperationFailedException(String.format(onlyOneChildIsAllowed$str(), childType, childrenNames));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String indexedChildResourceRegistrationNotAvailable = "WFLYMSGAMQ0079: Indexed child resources can only be registered if the parent resource supports ordered children. The parent of '%s' is not indexed";
    protected String indexedChildResourceRegistrationNotAvailable$str() {
        return indexedChildResourceRegistrationNotAvailable;
    }
    @Override
    public final IllegalStateException indexedChildResourceRegistrationNotAvailable(final PathElement address) {
        final IllegalStateException result = new IllegalStateException(String.format(indexedChildResourceRegistrationNotAvailable$str(), address));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String discoveryGroupIsNotDefined = "WFLYMSGAMQ0080: Discovery group %s is not defined";
    protected String discoveryGroupIsNotDefined$str() {
        return discoveryGroupIsNotDefined;
    }
    @Override
    public final StartException discoveryGroupIsNotDefined(final String discoveryGroupName) {
        final StartException result = new StartException(String.format(discoveryGroupIsNotDefined$str(), discoveryGroupName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unsupportedBroadcastGroupConfigurationForLegacy = "WFLYMSGAMQ0081: Unsupported type of broadcast group configuration for legacy resource: %s";
    protected String unsupportedBroadcastGroupConfigurationForLegacy$str() {
        return unsupportedBroadcastGroupConfigurationForLegacy;
    }
    @Override
    public final StartException unsupportedBroadcastGroupConfigurationForLegacy(final String broadcastGroupConfigurationClassName) {
        final StartException result = new StartException(String.format(unsupportedBroadcastGroupConfigurationForLegacy$str(), broadcastGroupConfigurationClassName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unsupportedConnectorFactoryForLegacy = "WFLYMSGAMQ0082: Unsupported type of connector factory for legacy resource: %s";
    protected String unsupportedConnectorFactoryForLegacy$str() {
        return unsupportedConnectorFactoryForLegacy;
    }
    @Override
    public final StartException unsupportedConnectorFactoryForLegacy(final String connectorFactoryClassName) {
        final StartException result = new StartException(String.format(unsupportedConnectorFactoryForLegacy$str(), connectorFactoryClassName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String managementOperationAllowedOnlyInRunningMode = "WFLYMSGAMQ0083: The %s operation can not be performed: the server must be in %s mode";
    protected String managementOperationAllowedOnlyInRunningMode$str() {
        return managementOperationAllowedOnlyInRunningMode;
    }
    @Override
    public final OperationFailedException managementOperationAllowedOnlyInRunningMode(final String operationName, final RunningMode mode) {
        final OperationFailedException result = new OperationFailedException(String.format(managementOperationAllowedOnlyInRunningMode$str(), operationName, mode));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noInVMConnector = "WFLYMSGAMQ0084: The server does not define any in-vm connector. One is required to be able to import a journal";
    protected String noInVMConnector$str() {
        return noInVMConnector;
    }
    @Override
    public final OperationFailedException noInVMConnector() {
        final OperationFailedException result = new OperationFailedException(String.format(noInVMConnector$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToLoadClassFromModule = "WFLYMSGAMQ0085: Unable to load class %s from module %s";
    protected String unableToLoadClassFromModule$str() {
        return unableToLoadClassFromModule;
    }
    @Override
    public final OperationFailedException unableToLoadClassFromModule(final String className, final String moduleName) {
        final OperationFailedException result = new OperationFailedException(String.format(unableToLoadClassFromModule$str(), className, moduleName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToLoadModule = "WFLYMSGAMQ0086: Unable to load module %s";
    protected String unableToLoadModule$str() {
        return unableToLoadModule;
    }
    @Override
    public final OperationFailedException unableToLoadModule(final String moduleName, final ModuleLoadException cause) {
        final OperationFailedException result = new OperationFailedException(String.format(unableToLoadModule$str(), moduleName), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToLoadConnectorServiceFactoryClass = "WFLYMSGAMQ0087: Unable to load connector service factory class: %s";
    protected String unableToLoadConnectorServiceFactoryClass$str() {
        return unableToLoadConnectorServiceFactoryClass;
    }
    @Override
    public final OperationFailedException unableToLoadConnectorServiceFactoryClass(final String factroyClass) {
        final OperationFailedException result = new OperationFailedException(String.format(unableToLoadConnectorServiceFactoryClass$str(), factroyClass));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
