/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.msc.service.ServiceName;

public class MessagingServices {
    static final ServiceName JBOSS_MESSAGING_ACTIVEMQ = ServiceName.JBOSS.append(new String[]{"messaging-activemq"});
    static final ServiceName HTTP_UPGRADE_REGISTRY = ServiceName.JBOSS.append(new String[]{"http-upgrade-registry"});

    public static ServiceName getActiveMQServiceName(PathAddress pathAddress) {
        String serverName = null;
        PathAddress serverPathAddress = MessagingServices.getActiveMQServerPathAddress(pathAddress);
        if (serverPathAddress != null) {
            serverName = serverPathAddress.getLastElement().getValue();
        }
        return JBOSS_MESSAGING_ACTIVEMQ.append(new String[]{serverName});
    }

    public static PathAddress getActiveMQServerPathAddress(PathAddress pathAddress) {
        for (int i = pathAddress.size() - 1; i >= 0; --i) {
            PathElement pe = pathAddress.getElement(i);
            if (!"server".equals(pe.getKey())) continue;
            return pathAddress.subAddress(0, i + 1);
        }
        return PathAddress.EMPTY_ADDRESS;
    }

    public static ServiceName getActiveMQServiceName(String serverName) {
        return JBOSS_MESSAGING_ACTIVEMQ.append(new String[]{serverName});
    }

    public static ServiceName getQueueBaseServiceName(ServiceName serverServiceName) {
        return serverServiceName.append(new String[]{"queue"});
    }

    static ServiceName getHttpUpgradeServiceName(String activemqServerName, String acceptorName) {
        return MessagingServices.getActiveMQServiceName(activemqServerName).append(new String[]{"http-upgrade-service", acceptorName});
    }

    static ServiceName getLegacyHttpUpgradeServiceName(String activemqServerName, String acceptorName) {
        return MessagingServices.getActiveMQServiceName(activemqServerName).append(new String[]{"legacy", "http-upgrade-service", acceptorName});
    }

    public static ServiceName getJMSBridgeServiceName(String bridgeName) {
        return JBOSS_MESSAGING_ACTIVEMQ.append(new String[]{"jms-bridge"}).append(new String[]{bridgeName});
    }
}

