/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.messaging.activemq.Capabilities;
import org.wildfly.extension.messaging.activemq.GroupBindingService;
import org.wildfly.extension.messaging.activemq.MessagingServices;
import org.wildfly.extension.messaging.activemq.jms.JMSServices;

class ServerRemove
extends AbstractRemoveStepHandler {
    static final ServerRemove INSTANCE = new ServerRemove();

    private ServerRemove() {
        super(new RuntimeCapability[]{Capabilities.ACTIVEMQ_SERVER_CAPABILITY});
    }

    protected void performRemove(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        final Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                String serverName = context.getCurrentAddressValue();
                ServiceName serviceName = MessagingServices.getActiveMQServiceName(serverName);
                for (Resource.ResourceEntry broadcastGroup : resource.getChildren("broadcast-group")) {
                    context.removeService(GroupBindingService.getBroadcastBaseServiceName(serviceName).append(new String[]{broadcastGroup.getName()}));
                }
                for (Resource.ResourceEntry divertGroup : resource.getChildren("discovery-group")) {
                    context.removeService(GroupBindingService.getDiscoveryBaseServiceName(serviceName).append(new String[]{divertGroup.getName()}));
                }
            }
        }, OperationContext.Stage.RUNTIME);
        super.performRemove(context, operation, model);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        String serverName = context.getCurrentAddressValue();
        ServiceName serviceName = MessagingServices.getActiveMQServiceName(serverName);
        context.removeService(JMSServices.getJmsManagerBaseServiceName(serviceName));
        context.removeService(MessagingServices.getActiveMQServiceName(serverName));
    }
}

