/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.broadcast;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.activemq.artemis.api.core.BroadcastEndpoint;
import org.wildfly.clustering.dispatcher.Command;
import org.wildfly.clustering.dispatcher.CommandDispatcher;
import org.wildfly.clustering.dispatcher.CommandDispatcherFactory;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.service.concurrent.ServiceExecutor;
import org.wildfly.clustering.service.concurrent.StampedLockServiceExecutor;
import org.wildfly.common.function.ExceptionRunnable;
import org.wildfly.extension.messaging.activemq.broadcast.BroadcastCommand;
import org.wildfly.extension.messaging.activemq.broadcast.BroadcastManager;
import org.wildfly.extension.messaging.activemq.broadcast.BroadcastReceiver;

public class CommandDispatcherBroadcastEndpoint
implements BroadcastEndpoint {
    private final CommandDispatcherFactory factory;
    private final String name;
    private final BroadcastManager manager;
    private final AtomicReference<Mode> mode = new AtomicReference<Mode>(Mode.CLOSED);
    private final ServiceExecutor executor = new StampedLockServiceExecutor();
    private volatile CommandDispatcher<BroadcastReceiver> dispatcher;

    public CommandDispatcherBroadcastEndpoint(CommandDispatcherFactory factory, String name, BroadcastManager manager) {
        this.factory = factory;
        this.name = name;
        this.manager = manager;
    }

    public void openClient() throws Exception {
        if (this.mode.compareAndSet(Mode.CLOSED, Mode.RECEIVER)) {
            this.open();
        }
    }

    public void openBroadcaster() throws Exception {
        if (this.mode.compareAndSet(Mode.CLOSED, Mode.BROADCASTER)) {
            this.open();
        }
    }

    private void open() throws Exception {
        this.dispatcher = this.factory.createCommandDispatcher((Object)this.name, (Object)this.manager);
    }

    public void close(boolean isBroadcast) throws Exception {
        if (this.mode.getAndSet(Mode.CLOSED) != Mode.CLOSED) {
            this.executor.close(() -> this.dispatcher.close());
            this.manager.clear();
        }
    }

    public void broadcast(byte[] data) throws Exception {
        if (this.mode.get() == Mode.BROADCASTER) {
            ExceptionRunnable task = () -> this.dispatcher.executeOnCluster((Command)new BroadcastCommand(data), new Node[0]);
            this.executor.execute(task);
        }
    }

    public byte[] receiveBroadcast() throws Exception {
        return this.mode.get() == Mode.RECEIVER ? this.manager.getBroadcast() : null;
    }

    public byte[] receiveBroadcast(long time, TimeUnit unit) throws Exception {
        return this.mode.get() == Mode.RECEIVER ? this.manager.getBroadcast(time, unit) : null;
    }

    private static enum Mode {
        BROADCASTER,
        RECEIVER,
        CLOSED;

    }
}

