/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.access.constraint.ApplicationTypeConfig;
import org.jboss.as.controller.access.constraint.SensitivityClassification;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.ApplicationTypeAccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.wildfly.extension.messaging.activemq.MessagingSubsystemParser_1_0;
import org.wildfly.extension.messaging.activemq.MessagingSubsystemParser_2_0;
import org.wildfly.extension.messaging.activemq.MessagingSubsystemParser_3_0;
import org.wildfly.extension.messaging.activemq.MessagingSubsystemRootResourceDefinition;
import org.wildfly.extension.messaging.activemq.PathDefinition;
import org.wildfly.extension.messaging.activemq.ServerDefinition;
import org.wildfly.extension.messaging.activemq.jms.JMSQueueDefinition;
import org.wildfly.extension.messaging.activemq.jms.JMSTopicDefinition;
import org.wildfly.extension.messaging.activemq.jms.PooledConnectionFactoryDefinition;
import org.wildfly.extension.messaging.activemq.jms.bridge.JMSBridgeDefinition;

public class MessagingExtension
implements Extension {
    public static final String SUBSYSTEM_NAME = "messaging-activemq";
    static final PathElement SUBSYSTEM_PATH = PathElement.pathElement((String)"subsystem", (String)"messaging-activemq");
    static final PathElement SERVER_PATH = PathElement.pathElement((String)"server");
    public static final PathElement LIVE_ONLY_PATH = PathElement.pathElement((String)"ha-policy", (String)"live-only");
    public static final PathElement REPLICATION_MASTER_PATH = PathElement.pathElement((String)"ha-policy", (String)"replication-master");
    public static final PathElement REPLICATION_SLAVE_PATH = PathElement.pathElement((String)"ha-policy", (String)"replication-slave");
    public static final PathElement SHARED_STORE_MASTER_PATH = PathElement.pathElement((String)"ha-policy", (String)"shared-store-master");
    public static final PathElement SHARED_STORE_SLAVE_PATH = PathElement.pathElement((String)"ha-policy", (String)"shared-store-slave");
    public static final PathElement REPLICATION_COLOCATED_PATH = PathElement.pathElement((String)"ha-policy", (String)"replication-colocated");
    public static final PathElement CONFIGURATION_MASTER_PATH = PathElement.pathElement((String)"configuration", (String)"master");
    public static final PathElement CONFIGURATION_SLAVE_PATH = PathElement.pathElement((String)"configuration", (String)"slave");
    static final PathElement BINDINGS_DIRECTORY_PATH = PathElement.pathElement((String)"path", (String)"bindings-directory");
    static final PathElement JOURNAL_DIRECTORY_PATH = PathElement.pathElement((String)"path", (String)"journal-directory");
    static final PathElement PAGING_DIRECTORY_PATH = PathElement.pathElement((String)"path", (String)"paging-directory");
    static final PathElement LARGE_MESSAGES_DIRECTORY_PATH = PathElement.pathElement((String)"path", (String)"large-messages-directory");
    static final PathElement CONNECTOR_SERVICE_PATH = PathElement.pathElement((String)"connector-service");
    static final PathElement QUEUE_PATH = PathElement.pathElement((String)"queue");
    static final PathElement RUNTIME_QUEUE_PATH = PathElement.pathElement((String)"runtime-queue");
    static final PathElement GROUPING_HANDLER_PATH = PathElement.pathElement((String)"grouping-handler");
    static final PathElement HTTP_CONNECTOR_PATH = PathElement.pathElement((String)"http-connector");
    static final PathElement HTTP_ACCEPTOR_PATH = PathElement.pathElement((String)"http-acceptor");
    static final PathElement BROADCAST_GROUP_PATH = PathElement.pathElement((String)"broadcast-group");
    static final PathElement CLUSTER_CONNECTION_PATH = PathElement.pathElement((String)"cluster-connection");
    static final PathElement BRIDGE_PATH = PathElement.pathElement((String)"bridge");
    static final PathElement ADDRESS_SETTING_PATH = PathElement.pathElement((String)"address-setting");
    static final PathElement ROLE_PATH = PathElement.pathElement((String)"role");
    static final PathElement SECURITY_SETTING_PATH = PathElement.pathElement((String)"security-setting");
    public static final PathElement JMS_QUEUE_PATH = PathElement.pathElement((String)"jms-queue");
    public static final PathElement JMS_TOPIC_PATH = PathElement.pathElement((String)"jms-topic");
    public static final PathElement POOLED_CONNECTION_FACTORY_PATH = PathElement.pathElement((String)"pooled-connection-factory");
    public static final PathElement CONNECTION_FACTORY_PATH = PathElement.pathElement((String)"connection-factory");
    public static final PathElement JMS_BRIDGE_PATH = PathElement.pathElement((String)"jms-bridge");
    public static final PathElement LEGACY_CONNECTION_FACTORY_PATH = PathElement.pathElement((String)"legacy-connection-factory");
    public static final SensitiveTargetAccessConstraintDefinition MESSAGING_SECURITY_SENSITIVE_TARGET = new SensitiveTargetAccessConstraintDefinition(new SensitivityClassification("messaging-activemq", "messaging-security", false, false, true));
    public static final SensitiveTargetAccessConstraintDefinition MESSAGING_MANAGEMENT_SENSITIVE_TARGET = new SensitiveTargetAccessConstraintDefinition(new SensitivityClassification("messaging-activemq", "messaging-management", false, false, true));
    static final AccessConstraintDefinition SECURITY_SETTING_ACCESS_CONSTRAINT = new ApplicationTypeAccessConstraintDefinition(new ApplicationTypeConfig("messaging-activemq", "security-setting"));
    static final AccessConstraintDefinition QUEUE_ACCESS_CONSTRAINT = new ApplicationTypeAccessConstraintDefinition(new ApplicationTypeConfig("messaging-activemq", "queue"));
    public static final AccessConstraintDefinition JMS_QUEUE_ACCESS_CONSTRAINT = new ApplicationTypeAccessConstraintDefinition(new ApplicationTypeConfig("messaging-activemq", "jms-queue"));
    public static final AccessConstraintDefinition JMS_TOPIC_ACCESS_CONSTRAINT = new ApplicationTypeAccessConstraintDefinition(new ApplicationTypeConfig("messaging-activemq", "jms-topic"));
    static final String RESOURCE_NAME = MessagingExtension.class.getPackage().getName() + ".LocalDescriptions";
    protected static final ModelVersion VERSION_3_0_0 = ModelVersion.create((int)3, (int)0, (int)0);
    protected static final ModelVersion VERSION_2_0_0 = ModelVersion.create((int)2, (int)0, (int)0);
    protected static final ModelVersion VERSION_1_0_0 = ModelVersion.create((int)1, (int)0, (int)0);
    private static final ModelVersion CURRENT_MODEL_VERSION = VERSION_3_0_0;
    private static final MessagingSubsystemParser_3_0 CURRENT_PARSER = new MessagingSubsystemParser_3_0();

    public static ResourceDescriptionResolver getResourceDescriptionResolver(String ... keyPrefix) {
        return MessagingExtension.getResourceDescriptionResolver(true, keyPrefix);
    }

    public static ResourceDescriptionResolver getResourceDescriptionResolver(boolean useUnprefixedChildTypes, String ... keyPrefix) {
        StringBuilder prefix = new StringBuilder();
        for (String kp : keyPrefix) {
            if (prefix.length() > 0) {
                prefix.append('.');
            }
            prefix.append(kp);
        }
        return new StandardResourceDescriptionResolver(prefix.toString(), RESOURCE_NAME, MessagingExtension.class.getClassLoader(), true, useUnprefixedChildTypes);
    }

    public void initialize(ExtensionContext context) {
        SubsystemRegistration subsystemRegistration = context.registerSubsystem(SUBSYSTEM_NAME, CURRENT_MODEL_VERSION);
        subsystemRegistration.registerXMLElementWriter((XMLElementWriter)CURRENT_PARSER);
        boolean registerRuntimeOnly = context.isRuntimeOnlyRegistrationValid();
        ManagementResourceRegistration subsystem = subsystemRegistration.registerSubsystemModel((ResourceDefinition)MessagingSubsystemRootResourceDefinition.INSTANCE);
        subsystem.registerOperationHandler((OperationDefinition)GenericSubsystemDescribeHandler.DEFINITION, (OperationStepHandler)GenericSubsystemDescribeHandler.INSTANCE);
        ManagementResourceRegistration server = subsystem.registerSubModel((ResourceDefinition)new ServerDefinition(registerRuntimeOnly));
        for (PathDefinition path : new PathDefinition[]{PathDefinition.JOURNAL_INSTANCE, PathDefinition.BINDINGS_INSTANCE, PathDefinition.LARGE_MESSAGES_INSTANCE, PathDefinition.PAGING_INSTANCE}) {
            ManagementResourceRegistration pathRegistry = server.registerSubModel((ResourceDefinition)path);
            PathDefinition.registerResolveOperationHandler(context, pathRegistry);
        }
        subsystem.registerSubModel((ResourceDefinition)JMSBridgeDefinition.INSTANCE);
        if (registerRuntimeOnly) {
            ManagementResourceRegistration deployment = subsystemRegistration.registerDeploymentModel((ResourceDefinition)new SimpleResourceDefinition(new SimpleResourceDefinition.Parameters(SUBSYSTEM_PATH, MessagingExtension.getResourceDescriptionResolver("deployed")).setFeature(false)));
            ManagementResourceRegistration deployedServer = deployment.registerSubModel((ResourceDefinition)new SimpleResourceDefinition(new SimpleResourceDefinition.Parameters(SERVER_PATH, MessagingExtension.getResourceDescriptionResolver("server")).setFeature(false)));
            deployedServer.registerSubModel((ResourceDefinition)new JMSQueueDefinition(true, registerRuntimeOnly));
            deployedServer.registerSubModel((ResourceDefinition)new JMSTopicDefinition(true, registerRuntimeOnly));
            deployedServer.registerSubModel((ResourceDefinition)PooledConnectionFactoryDefinition.DEPLOYMENT_INSTANCE);
        }
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, "urn:jboss:domain:messaging-activemq:1.0", MessagingSubsystemParser_1_0::new);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, "urn:jboss:domain:messaging-activemq:2.0", MessagingSubsystemParser_2_0::new);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, "urn:jboss:domain:messaging-activemq:3.0", (XMLElementReader)CURRENT_PARSER);
    }
}

