/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.deployment;

import java.util.Map;
import javax.jms.Destination;
import javax.jms.Queue;
import org.jboss.as.connector.deployers.ra.AdministeredObjectDefinitionInjectionSource;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.ee.resource.definition.ResourceDefinitionInjectionSource;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentResourceSupport;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.LifecycleEvent;
import org.jboss.msc.service.LifecycleListener;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.extension.messaging.activemq.CommonAttributes;
import org.wildfly.extension.messaging.activemq.MessagingServices;
import org.wildfly.extension.messaging.activemq.deployment.JMSConnectionFactoryDefinitionInjectionSource;
import org.wildfly.extension.messaging.activemq.deployment.MessagingJMSDestinationManagedReferenceFactory;
import org.wildfly.extension.messaging.activemq.deployment.MessagingXmlInstallDeploymentUnitProcessor;
import org.wildfly.extension.messaging.activemq.jms.JMSQueueConfigurationRuntimeHandler;
import org.wildfly.extension.messaging.activemq.jms.JMSQueueService;
import org.wildfly.extension.messaging.activemq.jms.JMSTopicConfigurationRuntimeHandler;
import org.wildfly.extension.messaging.activemq.jms.JMSTopicService;
import org.wildfly.extension.messaging.activemq.logging.MessagingLogger;

public class JMSDestinationDefinitionInjectionSource
extends ResourceDefinitionInjectionSource {
    private final String interfaceName;
    private String description;
    private String className;
    private String resourceAdapter;
    private String destinationName;

    public JMSDestinationDefinitionInjectionSource(String jndiName, String interfaceName) {
        super(jndiName);
        this.interfaceName = interfaceName;
    }

    void setDescription(String description) {
        this.description = description;
    }

    void setClassName(String className) {
        this.className = className;
    }

    void setResourceAdapter(String resourceAdapter) {
        this.resourceAdapter = resourceAdapter;
    }

    void setDestinationName(String destinationName) {
        this.destinationName = destinationName;
    }

    private String uniqueName(InjectionSource.ResolutionContext context) {
        if (this.destinationName != null && !this.destinationName.isEmpty()) {
            return this.destinationName;
        }
        StringBuilder uniqueName = new StringBuilder();
        uniqueName.append(context.getApplicationName() + "_");
        uniqueName.append(context.getModuleName() + "_");
        if (context.getComponentName() != null) {
            uniqueName.append(context.getComponentName() + "_");
        }
        uniqueName.append(this.jndiName);
        return uniqueName.toString();
    }

    public void getResourceValue(InjectionSource.ResolutionContext context, ServiceBuilder<?> serviceBuilder, DeploymentPhaseContext phaseContext, Injector<ManagedReferenceFactory> injector) throws DeploymentUnitProcessingException {
        if (JMSConnectionFactoryDefinitionInjectionSource.targetsPooledConnectionFactory(JMSConnectionFactoryDefinitionInjectionSource.getActiveMQServerName(this.properties), this.resourceAdapter, phaseContext.getServiceRegistry())) {
            this.startActiveMQDestination(context, serviceBuilder, phaseContext, injector);
        } else {
            AdministeredObjectDefinitionInjectionSource aodis = new AdministeredObjectDefinitionInjectionSource(this.jndiName, this.className, this.resourceAdapter);
            aodis.setInterface(this.interfaceName);
            aodis.setDescription(this.description);
            for (Map.Entry property : this.properties.entrySet()) {
                aodis.addProperty((String)property.getKey(), (String)property.getValue());
            }
            aodis.getResourceValue(context, serviceBuilder, phaseContext, injector);
        }
    }

    private void startActiveMQDestination(InjectionSource.ResolutionContext context, ServiceBuilder<?> serviceBuilder, DeploymentPhaseContext phaseContext, Injector<ManagedReferenceFactory> injector) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        String uniqueName = this.uniqueName(context);
        try {
            ServiceName serviceName = MessagingServices.getActiveMQServiceName(JMSConnectionFactoryDefinitionInjectionSource.getActiveMQServerName(this.properties));
            if (this.interfaceName.equals(Queue.class.getName())) {
                this.startQueue(uniqueName, phaseContext.getServiceTarget(), serviceName, serviceBuilder, deploymentUnit, injector);
            } else {
                this.startTopic(uniqueName, phaseContext.getServiceTarget(), serviceName, serviceBuilder, deploymentUnit, injector);
            }
        }
        catch (Exception e) {
            throw new DeploymentUnitProcessingException((Throwable)e);
        }
    }

    private void startQueue(String queueName, ServiceTarget serviceTarget, ServiceName serverServiceName, ServiceBuilder<?> serviceBuilder, DeploymentUnit deploymentUnit, Injector<ManagedReferenceFactory> injector) {
        String selector = this.properties.containsKey(CommonAttributes.SELECTOR.getName()) ? (String)this.properties.get(CommonAttributes.SELECTOR.getName()) : null;
        boolean durable = this.properties.containsKey(CommonAttributes.DURABLE.getName()) ? Boolean.valueOf((String)this.properties.get(CommonAttributes.DURABLE.getName())).booleanValue() : CommonAttributes.DURABLE.getDefaultValue().asBoolean();
        ModelNode destination = new ModelNode();
        destination.get("name").set(queueName);
        destination.get(CommonAttributes.DURABLE.getName()).set(durable);
        if (selector != null) {
            destination.get(CommonAttributes.SELECTOR.getName()).set(selector);
        }
        destination.get("entries").add(this.jndiName);
        Service<Queue> queueService = JMSQueueService.installService(queueName, serviceTarget, serverServiceName, selector, durable, new String[0]);
        this.inject(serviceBuilder, injector, queueService);
        String serverName = JMSConnectionFactoryDefinitionInjectionSource.getActiveMQServerName(this.properties);
        PathElement serverElement = PathElement.pathElement((String)"server", (String)serverName);
        PathElement dest = PathElement.pathElement((String)"jms-queue", (String)queueName);
        DeploymentResourceSupport deploymentResourceSupport = (DeploymentResourceSupport)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_RESOURCE_SUPPORT);
        deploymentResourceSupport.getDeploymentSubModel("messaging-activemq", serverElement);
        PathAddress registration = PathAddress.pathAddress((PathElement[])new PathElement[]{serverElement, dest});
        MessagingXmlInstallDeploymentUnitProcessor.createDeploymentSubModel(registration, deploymentUnit);
        JMSQueueConfigurationRuntimeHandler.INSTANCE.registerResource(serverName, queueName, destination);
    }

    private void startTopic(String topicName, ServiceTarget serviceTarget, ServiceName serverServiceName, ServiceBuilder<?> serviceBuilder, DeploymentUnit deploymentUnit, Injector<ManagedReferenceFactory> injector) {
        ModelNode destination = new ModelNode();
        destination.get("name").set(topicName);
        destination.get("entries").add(this.jndiName);
        JMSTopicService topicService = JMSTopicService.installService(topicName, serverServiceName, serviceTarget, new String[0]);
        this.inject(serviceBuilder, injector, topicService);
        String serverName = JMSConnectionFactoryDefinitionInjectionSource.getActiveMQServerName(this.properties);
        PathElement serverElement = PathElement.pathElement((String)"server", (String)serverName);
        PathElement dest = PathElement.pathElement((String)"jms-topic", (String)topicName);
        DeploymentResourceSupport deploymentResourceSupport = (DeploymentResourceSupport)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_RESOURCE_SUPPORT);
        deploymentResourceSupport.getDeploymentSubModel("messaging-activemq", serverElement);
        PathAddress registration = PathAddress.pathAddress((PathElement[])new PathElement[]{serverElement, dest});
        MessagingXmlInstallDeploymentUnitProcessor.createDeploymentSubModel(registration, deploymentUnit);
        JMSTopicConfigurationRuntimeHandler.INSTANCE.registerResource(serverName, topicName, destination);
    }

    private <D extends Destination> void inject(ServiceBuilder<?> serviceBuilder, Injector<ManagedReferenceFactory> injector, Service<D> destinationService) {
        MessagingJMSDestinationManagedReferenceFactory<D> referenceFactoryService = new MessagingJMSDestinationManagedReferenceFactory<D>(destinationService);
        serviceBuilder.addInjection(injector, referenceFactoryService).addListener(new LifecycleListener(){

            public void handleEvent(ServiceController<?> controller, LifecycleEvent event) {
                switch (event) {
                    case UP: {
                        MessagingLogger.ROOT_LOGGER.boundJndiName(JMSDestinationDefinitionInjectionSource.this.jndiName);
                        break;
                    }
                    case DOWN: {
                        MessagingLogger.ROOT_LOGGER.unboundJndiName(JMSDestinationDefinitionInjectionSource.this.jndiName);
                        break;
                    }
                    case REMOVED: {
                        MessagingLogger.ROOT_LOGGER.debugf("Removed messaging object [%s]", JMSDestinationDefinitionInjectionSource.this.jndiName);
                    }
                }
            }
        });
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JMSDestinationDefinitionInjectionSource that = (JMSDestinationDefinitionInjectionSource)((Object)o);
        if (this.className != null ? !this.className.equals(that.className) : that.className != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.destinationName != null ? !this.destinationName.equals(that.destinationName) : that.destinationName != null) {
            return false;
        }
        if (this.interfaceName != null ? !this.interfaceName.equals(that.interfaceName) : that.interfaceName != null) {
            return false;
        }
        return !(this.resourceAdapter != null ? !this.resourceAdapter.equals(that.resourceAdapter) : that.resourceAdapter != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.interfaceName != null ? this.interfaceName.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.className != null ? this.className.hashCode() : 0);
        result = 31 * result + (this.resourceAdapter != null ? this.resourceAdapter.hashCode() : 0);
        result = 31 * result + (this.destinationName != null ? this.destinationName.hashCode() : 0);
        return result;
    }
}

