/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import java.util.List;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.CoreQueueConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.wildfly.extension.messaging.activemq.ActiveMQActivationService;
import org.wildfly.extension.messaging.activemq.CommonAttributes;
import org.wildfly.extension.messaging.activemq.MessagingServices;
import org.wildfly.extension.messaging.activemq.QueueDefinition;
import org.wildfly.extension.messaging.activemq.QueueService;

public class QueueAdd
extends AbstractAddStepHandler {
    public static final QueueAdd INSTANCE = new QueueAdd((AttributeDefinition[])QueueDefinition.ATTRIBUTES);

    private QueueAdd(AttributeDefinition ... attributes) {
        super(attributes);
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (SimpleAttributeDefinition attributeDefinition : QueueDefinition.ATTRIBUTES) {
            attributeDefinition.validateAndSet(operation, model);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        ServiceName serviceName;
        ServiceRegistry registry = context.getServiceRegistry(true);
        ServiceController serverService = registry.getService(serviceName = MessagingServices.getActiveMQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address"))));
        if (serverService != null) {
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
            String queueName = address.getLastElement().getValue();
            CoreQueueConfiguration queueConfiguration = QueueAdd.createCoreQueueConfiguration(context, queueName, model);
            QueueService service = new QueueService(queueConfiguration, false);
            ServiceName queueServiceName = MessagingServices.getQueueBaseServiceName(serviceName).append(new String[]{queueName});
            ServiceBuilder sb = context.getServiceTarget().addService(queueServiceName, (Service)service);
            sb.requires(ActiveMQActivationService.getServiceName(serviceName));
            sb.addDependency(serviceName, ActiveMQServer.class, service.getActiveMQServer());
            sb.setInitialMode(ServiceController.Mode.PASSIVE);
            sb.install();
        }
    }

    static void addQueueConfigs(OperationContext context, Configuration configuration, ModelNode model) throws OperationFailedException {
        if (model.hasDefined("queue")) {
            List configs = configuration.getQueueConfigurations();
            for (Property prop : model.get("queue").asPropertyList()) {
                configs.add(QueueAdd.createCoreQueueConfiguration(context, prop.getName(), prop.getValue()));
            }
        }
    }

    private static CoreQueueConfiguration createCoreQueueConfiguration(OperationContext context, String name, ModelNode model) throws OperationFailedException {
        String queueAddress = QueueDefinition.ADDRESS.resolveModelAttribute(context, model).asString();
        ModelNode filterNode = CommonAttributes.FILTER.resolveModelAttribute(context, model);
        String filter = filterNode.isDefined() ? filterNode.asString() : null;
        boolean durable = CommonAttributes.DURABLE.resolveModelAttribute(context, model).asBoolean();
        return new CoreQueueConfiguration().setAddress(queueAddress).setName(name).setFilterString(filter).setDurable(durable);
    }
}

